/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.codec.v431;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.cloudburstmc.nbt.NBTInputStream;
import org.cloudburstmc.nbt.NBTOutputStream;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.cloudburstmc.protocol.bedrock.codec.EntityDataTypeMap;
import org.cloudburstmc.protocol.bedrock.codec.v428.BedrockCodecHelper_v428;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.CraftResultsDeprecatedAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestActionType;
import org.cloudburstmc.protocol.bedrock.data.inventory.transaction.InventoryActionData;
import org.cloudburstmc.protocol.bedrock.data.inventory.transaction.InventorySource;
import org.cloudburstmc.protocol.common.util.TypeMap;
import org.cloudburstmc.protocol.common.util.VarInts;
import org.cloudburstmc.protocol.common.util.stream.LittleEndianByteBufInputStream;
import org.cloudburstmc.protocol.common.util.stream.LittleEndianByteBufOutputStream;

public class BedrockCodecHelper_v431
extends BedrockCodecHelper_v428 {
    public BedrockCodecHelper_v431(EntityDataTypeMap entityData, TypeMap<Class<?>> gameRulesTypes, TypeMap<ItemStackRequestActionType> stackRequestActionTypes, TypeMap<ContainerSlotType> containerSlotTypes) {
        super(entityData, gameRulesTypes, stackRequestActionTypes, containerSlotTypes);
    }

    @Override
    public ItemData readItemInstance(ByteBuf buffer) {
        String[] canBreak;
        String[] canPlace;
        int runtimeId = VarInts.readInt(buffer);
        if (runtimeId == 0) {
            return ItemData.AIR;
        }
        ItemDefinition definition = (ItemDefinition)this.itemDefinitions.getDefinition(runtimeId);
        int count = buffer.readUnsignedShortLE();
        int damage = VarInts.readUnsignedInt(buffer);
        int blockRuntimeId = VarInts.readInt(buffer);
        NbtMap compoundTag = null;
        long blockingTicks = 0L;
        ByteBuf buf = buffer.readSlice(VarInts.readUnsignedInt(buffer));
        try (LittleEndianByteBufInputStream stream = new LittleEndianByteBufInputStream(buf);
             NBTInputStream nbtStream = new NBTInputStream((DataInput)((Object)stream), this.encodingSettings.maxItemNBTSize());){
            int i;
            short nbtSize = stream.readShort();
            if (nbtSize > 0) {
                compoundTag = (NbtMap)nbtStream.readTag();
            } else if (nbtSize == -1) {
                int tagCount = stream.readUnsignedByte();
                if (tagCount != 1) {
                    throw new IllegalArgumentException("Expected 1 tag but got " + tagCount);
                }
                compoundTag = (NbtMap)nbtStream.readTag();
            }
            canPlace = new String[stream.readInt()];
            for (i = 0; i < canPlace.length; ++i) {
                canPlace[i] = stream.readUTF();
            }
            canBreak = new String[stream.readInt()];
            for (i = 0; i < canBreak.length; ++i) {
                canBreak[i] = stream.readUTF();
            }
            if (definition != null && "minecraft:shield".equals(definition.getIdentifier())) {
                blockingTicks = stream.readLong();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read item user data", e);
        }
        if (buf.isReadable()) {
            log.info("Item user data has {} readable bytes left", (Object)buf.readableBytes());
            if (log.isDebugEnabled()) {
                log.debug("Item data:\n{}", (Object)ByteBufUtil.prettyHexDump((ByteBuf)buf.readerIndex(0)));
            }
        }
        return ItemData.builder().definition(definition).damage(damage).count(count).tag(compoundTag).canPlace(canPlace).canBreak(canBreak).blockingTicks(blockingTicks).blockDefinition((BlockDefinition)this.blockDefinitions.getDefinition(blockRuntimeId)).build();
    }

    @Override
    public ItemData readItem(ByteBuf buffer) {
        String[] canBreak;
        String[] canPlace;
        int runtimeId = VarInts.readInt(buffer);
        if (runtimeId == 0) {
            return ItemData.AIR;
        }
        ItemDefinition definition = (ItemDefinition)this.itemDefinitions.getDefinition(runtimeId);
        int count = buffer.readUnsignedShortLE();
        int damage = VarInts.readUnsignedInt(buffer);
        boolean hasNetId = buffer.readBoolean();
        int netId = 0;
        if (hasNetId) {
            netId = VarInts.readInt(buffer);
        }
        int blockRuntimeId = VarInts.readInt(buffer);
        NbtMap compoundTag = null;
        long blockingTicks = 0L;
        ByteBuf buf = buffer.readSlice(VarInts.readUnsignedInt(buffer));
        try (LittleEndianByteBufInputStream stream = new LittleEndianByteBufInputStream(buf);
             NBTInputStream nbtStream = new NBTInputStream((DataInput)((Object)stream), this.encodingSettings.maxItemNBTSize());){
            int i;
            short nbtSize = stream.readShort();
            if (nbtSize > 0) {
                compoundTag = (NbtMap)nbtStream.readTag();
            } else if (nbtSize == -1) {
                int tagCount = stream.readUnsignedByte();
                if (tagCount != 1) {
                    throw new IllegalArgumentException("Expected 1 tag but got " + tagCount);
                }
                compoundTag = (NbtMap)nbtStream.readTag();
            }
            canPlace = new String[stream.readInt()];
            for (i = 0; i < canPlace.length; ++i) {
                canPlace[i] = stream.readUTF();
            }
            canBreak = new String[stream.readInt()];
            for (i = 0; i < canBreak.length; ++i) {
                canBreak[i] = stream.readUTF();
            }
            if (definition != null && "minecraft:shield".equals(definition.getIdentifier())) {
                blockingTicks = stream.readLong();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read item user data", e);
        }
        if (buf.isReadable()) {
            log.info("Item user data has {} readable bytes left", (Object)buf.readableBytes());
            if (log.isDebugEnabled()) {
                log.debug("Item data:\n{}", (Object)ByteBufUtil.prettyHexDump((ByteBuf)buf.readerIndex(0)));
            }
        }
        return ItemData.builder().definition(definition).damage(damage).count(count).tag(compoundTag).canPlace(canPlace).canBreak(canBreak).blockingTicks(blockingTicks).blockDefinition((BlockDefinition)this.blockDefinitions.getDefinition(blockRuntimeId)).usingNetId(hasNetId).netId(netId).build();
    }

    @Override
    public ItemData readNetItem(ByteBuf buffer) {
        return this.readItem(buffer);
    }

    @Override
    public void writeItemInstance(ByteBuf buffer, ItemData item) {
        Objects.requireNonNull(item, "item is null!");
        ItemDefinition definition = item.getDefinition();
        if (BedrockCodecHelper_v431.isAir(definition)) {
            buffer.writeByte(0);
            return;
        }
        VarInts.writeInt(buffer, definition.getRuntimeId());
        buffer.writeShortLE(item.getCount());
        VarInts.writeUnsignedInt(buffer, item.getDamage());
        VarInts.writeInt(buffer, item.getBlockDefinition() == null ? 0 : item.getBlockDefinition().getRuntimeId());
        ByteBuf userDataBuf = ByteBufAllocator.DEFAULT.ioBuffer();
        try (LittleEndianByteBufOutputStream stream = new LittleEndianByteBufOutputStream(userDataBuf);
             NBTOutputStream nbtStream = new NBTOutputStream((DataOutput)((Object)stream));){
            if (item.getTag() != null) {
                stream.writeShort(-1);
                stream.writeByte(1);
                nbtStream.writeTag(item.getTag());
            } else {
                userDataBuf.writeShortLE(0);
            }
            String[] canPlace = item.getCanPlace();
            stream.writeInt(canPlace.length);
            for (String aCanPlace : canPlace) {
                stream.writeUTF(aCanPlace);
            }
            String[] canBreak = item.getCanBreak();
            stream.writeInt(canBreak.length);
            for (String aCanBreak : canBreak) {
                stream.writeUTF(aCanBreak);
            }
            if ("minecraft:shield".equals(definition.getIdentifier())) {
                stream.writeLong(item.getBlockingTicks());
            }
            VarInts.writeUnsignedInt(buffer, userDataBuf.readableBytes());
            buffer.writeBytes(userDataBuf);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to write item user data", e);
        }
        finally {
            userDataBuf.release();
        }
    }

    @Override
    public void writeItem(ByteBuf buffer, ItemData item) {
        Objects.requireNonNull(item, "item is null!");
        ItemDefinition definition = item.getDefinition();
        if (BedrockCodecHelper_v431.isAir(definition)) {
            buffer.writeByte(0);
            return;
        }
        VarInts.writeInt(buffer, definition.getRuntimeId());
        buffer.writeShortLE(item.getCount());
        VarInts.writeUnsignedInt(buffer, item.getDamage());
        buffer.writeBoolean(item.isUsingNetId());
        if (item.isUsingNetId()) {
            VarInts.writeInt(buffer, item.getNetId());
        }
        VarInts.writeInt(buffer, item.getBlockDefinition() == null ? 0 : item.getBlockDefinition().getRuntimeId());
        ByteBuf userDataBuf = ByteBufAllocator.DEFAULT.ioBuffer();
        try (LittleEndianByteBufOutputStream stream = new LittleEndianByteBufOutputStream(userDataBuf);
             NBTOutputStream nbtStream = new NBTOutputStream((DataOutput)((Object)stream));){
            if (item.getTag() != null) {
                stream.writeShort(-1);
                stream.writeByte(1);
                nbtStream.writeTag(item.getTag());
            } else {
                userDataBuf.writeShortLE(0);
            }
            String[] canPlace = item.getCanPlace();
            stream.writeInt(canPlace.length);
            for (String aCanPlace : canPlace) {
                stream.writeUTF(aCanPlace);
            }
            String[] canBreak = item.getCanBreak();
            stream.writeInt(canBreak.length);
            for (String aCanBreak : canBreak) {
                stream.writeUTF(aCanBreak);
            }
            if ("minecraft:shield".equals(definition.getIdentifier())) {
                stream.writeLong(item.getBlockingTicks());
            }
            VarInts.writeUnsignedInt(buffer, userDataBuf.readableBytes());
            buffer.writeBytes(userDataBuf);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to write item user data", e);
        }
        finally {
            userDataBuf.release();
        }
    }

    @Override
    public void writeNetItem(ByteBuf buffer, ItemData item) {
        this.writeItem(buffer, item);
    }

    @Override
    public boolean readInventoryActions(ByteBuf buffer, List<InventoryActionData> actions) {
        this.readArray(buffer, actions, (ByteBuf buf, BedrockCodecHelper helper) -> {
            InventorySource source = this.readSource((ByteBuf)buf);
            int slot = VarInts.readUnsignedInt(buf);
            ItemData fromItem = helper.readItem((ByteBuf)buf);
            ItemData toItem = helper.readItem((ByteBuf)buf);
            return new InventoryActionData(source, slot, fromItem, toItem);
        }, 64);
        return false;
    }

    @Override
    public void writeInventoryActions(ByteBuf buffer, List<InventoryActionData> actions, boolean hasNetworkIds) {
        this.writeArray(buffer, actions, (ByteBuf buf, BedrockCodecHelper helper, T action) -> {
            this.writeSource((ByteBuf)buf, action.getSource());
            VarInts.writeUnsignedInt(buf, action.getSlot());
            helper.writeItem((ByteBuf)buf, action.getFromItem());
            helper.writeItem((ByteBuf)buf, action.getToItem());
        });
    }

    @Override
    protected ItemStackRequestAction readRequestActionData(ByteBuf byteBuf, ItemStackRequestActionType type) {
        if (type == ItemStackRequestActionType.CRAFT_RESULTS_DEPRECATED) {
            return new CraftResultsDeprecatedAction(this.readArray(byteBuf, new ItemData[0], this::readItemInstance), byteBuf.readUnsignedByte());
        }
        return super.readRequestActionData(byteBuf, type);
    }

    @Override
    protected void writeRequestActionData(ByteBuf byteBuf, ItemStackRequestAction action) {
        if (action.getType() == ItemStackRequestActionType.CRAFT_RESULTS_DEPRECATED) {
            this.writeArray(byteBuf, ((CraftResultsDeprecatedAction)action).getResultItems(), this::writeItemInstance);
            byteBuf.writeByte(((CraftResultsDeprecatedAction)action).getTimesCrafted());
        } else {
            super.writeRequestActionData(byteBuf, action);
        }
    }
}

