/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.packet;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketType;
import org.cloudburstmc.protocol.common.PacketSignal;

public class UpdateBlockPacket
implements BedrockPacket {
    public static final Set<Flag> FLAG_ALL = Collections.unmodifiableSet(EnumSet.of(Flag.NEIGHBORS, Flag.NETWORK));
    public static final Set<Flag> FLAG_ALL_PRIORITY = Collections.unmodifiableSet(EnumSet.of(Flag.NEIGHBORS, Flag.NETWORK, Flag.PRIORITY));
    final Set<Flag> flags = EnumSet.noneOf(Flag.class);
    Vector3i blockPosition;
    BlockDefinition definition;
    int dataLayer;

    @Override
    public PacketSignal handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.UPDATE_BLOCK;
    }

    public Set<Flag> getFlags() {
        return this.flags;
    }

    public Vector3i getBlockPosition() {
        return this.blockPosition;
    }

    public BlockDefinition getDefinition() {
        return this.definition;
    }

    public int getDataLayer() {
        return this.dataLayer;
    }

    public void setBlockPosition(Vector3i blockPosition) {
        this.blockPosition = blockPosition;
    }

    public void setDefinition(BlockDefinition definition) {
        this.definition = definition;
    }

    public void setDataLayer(int dataLayer) {
        this.dataLayer = dataLayer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateBlockPacket)) {
            return false;
        }
        UpdateBlockPacket other = (UpdateBlockPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.dataLayer != other.dataLayer) {
            return false;
        }
        Set<Flag> this$flags = this.flags;
        Set<Flag> other$flags = other.flags;
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        Vector3i this$blockPosition = this.blockPosition;
        Vector3i other$blockPosition = other.blockPosition;
        if (this$blockPosition == null ? other$blockPosition != null : !this$blockPosition.equals(other$blockPosition)) {
            return false;
        }
        BlockDefinition this$definition = this.definition;
        BlockDefinition other$definition = other.definition;
        return !(this$definition == null ? other$definition != null : !this$definition.equals(other$definition));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpdateBlockPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.dataLayer;
        Set<Flag> $flags = this.flags;
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        Vector3i $blockPosition = this.blockPosition;
        result = result * 59 + ($blockPosition == null ? 43 : $blockPosition.hashCode());
        BlockDefinition $definition = this.definition;
        result = result * 59 + ($definition == null ? 43 : $definition.hashCode());
        return result;
    }

    public String toString() {
        return "UpdateBlockPacket(flags=" + this.flags + ", blockPosition=" + this.blockPosition + ", definition=" + this.definition + ", dataLayer=" + this.dataLayer + ")";
    }

    public static enum Flag {
        NEIGHBORS,
        NETWORK,
        NO_GRAPHIC,
        UNUSED,
        PRIORITY;

    }
}

