/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.player;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.AttributeData;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.UpdateAttributesPacket;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.AttributeUtils;
import org.geysermc.geyser.util.DimensionUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.Attribute;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.AttributeType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.GlobalPos;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.FloatEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;

public class SessionPlayerEntity
extends PlayerEntity {
    protected final Map<GeyserAttributeType, AttributeData> attributes = new Object2ObjectOpenHashMap<GeyserAttributeType, AttributeData>();
    private boolean refreshSpeed = false;
    private boolean isRidingInFront;

    public SessionPlayerEntity(GeyserSession session) {
        super(session, -1, 1L, null, Vector3f.ZERO, Vector3f.ZERO, 0.0f, 0.0f, 0.0f, null, null);
        this.valid = true;
    }

    @Override
    protected void setClientSideSilent() {
    }

    @Override
    public void spawnEntity() {
    }

    @Override
    public void moveRelative(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        super.moveRelative(relX, relY, relZ, yaw, pitch, headYaw, isOnGround);
        this.session.getCollisionManager().updatePlayerBoundingBox(this.position.down(this.definition.offset()));
    }

    @Override
    public void setPosition(Vector3f position) {
        if (this.valid) {
            this.session.getCollisionManager().updatePlayerBoundingBox(position);
        }
        super.setPosition(position);
    }

    public void setPositionManual(Vector3f position) {
        this.position = position;
    }

    @Override
    public void setFlags(ByteEntityMetadata entityMetadata) {
        if (!this.session.getGameMode().equals(GameMode.SPECTATOR)) {
            super.setFlags(entityMetadata);
            this.session.setSwimmingInWater((entityMetadata.getPrimitiveValue() & 0x10) == 16 && this.getFlag(EntityFlag.SPRINTING));
        }
        this.refreshSpeed = true;
    }

    public void updateBoundingBox() {
        this.dirtyMetadata.put(EntityDataTypes.HEIGHT, Float.valueOf(this.getBoundingBoxHeight()));
        this.dirtyMetadata.put(EntityDataTypes.WIDTH, Float.valueOf(this.getBoundingBoxWidth()));
        this.updateBedrockMetadata();
    }

    @Override
    public boolean setBoundingBoxHeight(float height) {
        if (super.setBoundingBoxHeight(height)) {
            if (this.valid) {
                this.session.getCollisionManager().updatePlayerBoundingBox();
            }
            return true;
        }
        return false;
    }

    @Override
    public void setPose(Pose pose) {
        super.setPose(pose);
        this.session.setPose(pose);
        this.refreshSpeed = true;
    }

    public float getMaxHealth() {
        return this.maxHealth;
    }

    public float getHealth() {
        return this.health;
    }

    public void setHealth(float health) {
        this.health = health;
    }

    @Override
    protected void setAirSupply(int amount) {
        if (amount == this.getMaxAir()) {
            super.setAirSupply(0);
        } else {
            super.setAirSupply(amount);
        }
    }

    @Override
    public void setRiderSeatPosition(Vector3f position) {
        super.setRiderSeatPosition(position);
        this.isRidingInFront = position != null && position.getX() > 0.0f;
    }

    @Override
    public AttributeData createHealthAttribute() {
        if (this.maxHealth % 2.0f == 1.0f) {
            this.maxHealth += 1.0f;
        }
        return super.createHealthAttribute();
    }

    @Override
    protected boolean hasShield(boolean offhand) {
        if (offhand) {
            return this.session.getPlayerInventory().getOffhand().asItem() == Items.SHIELD;
        }
        return this.session.getPlayerInventory().getItemInHand().asItem() == Items.SHIELD;
    }

    @Override
    public void updateBedrockMetadata() {
        super.updateBedrockMetadata();
        if (this.refreshSpeed) {
            AttributeData speedAttribute = this.session.adjustSpeed();
            if (speedAttribute != null) {
                UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
                attributesPacket.setRuntimeEntityId(this.geyserId);
                attributesPacket.setAttributes(Collections.singletonList(speedAttribute));
                this.session.sendUpstreamPacket(attributesPacket);
            }
            this.refreshSpeed = false;
        }
    }

    @Override
    protected void updateAttribute(Attribute javaAttribute, List<AttributeData> newAttributes) {
        if (javaAttribute.getType() == AttributeType.Builtin.GENERIC_ATTACK_SPEED) {
            this.session.setAttackSpeed(AttributeUtils.calculateValue(javaAttribute));
        } else {
            super.updateAttribute(javaAttribute, newAttributes);
        }
    }

    @Override
    protected AttributeData calculateAttribute(Attribute javaAttribute, GeyserAttributeType type) {
        AttributeData attributeData = super.calculateAttribute(javaAttribute, type);
        if (javaAttribute.getType() == AttributeType.Builtin.GENERIC_MOVEMENT_SPEED) {
            this.session.setOriginalSpeedAttribute(attributeData.getValue());
            AttributeData speedAttribute = this.session.adjustSpeed();
            if (speedAttribute != null) {
                this.attributes.put(type, speedAttribute);
                return speedAttribute;
            }
        }
        this.attributes.put(type, attributeData);
        return attributeData;
    }

    public void setLastDeathPosition(@Nullable GlobalPos pos) {
        if (pos != null) {
            this.dirtyMetadata.put(EntityDataTypes.PLAYER_LAST_DEATH_POS, pos.getPosition());
            this.dirtyMetadata.put(EntityDataTypes.PLAYER_LAST_DEATH_DIMENSION, DimensionUtils.javaToBedrock(pos.getDimension()));
            this.dirtyMetadata.put(EntityDataTypes.PLAYER_HAS_DIED, true);
        } else {
            this.dirtyMetadata.put(EntityDataTypes.PLAYER_HAS_DIED, false);
        }
    }

    @Override
    public UUID getTabListUuid() {
        return this.session.getAuthData().uuid();
    }

    @Override
    public void setAbsorptionHearts(FloatEntityMetadata entityMetadata) {
        this.attributes.put(GeyserAttributeType.ABSORPTION, GeyserAttributeType.ABSORPTION.getAttribute(entityMetadata.getPrimitiveValue()));
        super.setAbsorptionHearts(entityMetadata);
    }

    public void resetMetadata() {
        this.flags.clear();
        this.initializeMetadata();
        this.resetAir();
        this.setParrot(null, true);
        this.setParrot(null, false);
        this.attributes.remove((Object)GeyserAttributeType.ABSORPTION);
        UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
        attributesPacket.setRuntimeEntityId(this.geyserId);
        attributesPacket.setAttributes(Collections.singletonList(GeyserAttributeType.ABSORPTION.getAttribute(0.0f)));
        this.session.sendUpstreamPacket(attributesPacket);
        this.dirtyMetadata.put(EntityDataTypes.EFFECT_COLOR, 0);
        this.dirtyMetadata.put(EntityDataTypes.EFFECT_AMBIENCE, (byte)0);
        this.dirtyMetadata.put(EntityDataTypes.FREEZING_EFFECT_STRENGTH, Float.valueOf(0.0f));
        this.silent = false;
    }

    public void resetAttributes() {
        this.attributes.clear();
        this.maxHealth = GeyserAttributeType.MAX_HEALTH.getDefaultValue();
        UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
        attributesPacket.setRuntimeEntityId(this.geyserId);
        attributesPacket.setAttributes(Collections.singletonList(GeyserAttributeType.MOVEMENT_SPEED.getAttribute()));
        this.session.sendUpstreamPacket(attributesPacket);
    }

    public void resetAir() {
        this.setAirSupply(this.getMaxAir());
    }

    public Map<GeyserAttributeType, AttributeData> getAttributes() {
        return this.attributes;
    }

    public boolean isRidingInFront() {
        return this.isRidingInFront;
    }
}

