/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.item.Enchantment;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ItemEnchantments;

public class EnchantedBookItem
extends Item {
    public EnchantedBookItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateComponentsToBedrock(@NonNull GeyserSession session, @NonNull DataComponents components, @NonNull BedrockItemBuilder builder) {
        super.translateComponentsToBedrock(session, components, builder);
        ArrayList<NbtMap> bedrockEnchants = new ArrayList<NbtMap>();
        ItemEnchantments enchantments = components.get(DataComponentType.STORED_ENCHANTMENTS);
        if (enchantments != null) {
            for (Map.Entry<Integer, Integer> enchantment : enchantments.getEnchantments().entrySet()) {
                NbtMap bedrockTag = this.remapEnchantment(session, enchantment.getKey(), enchantment.getValue(), builder);
                if (bedrockTag == null) continue;
                bedrockEnchants.add(bedrockTag);
            }
        }
        if (!bedrockEnchants.isEmpty()) {
            builder.putList("ench", NbtType.COMPOUND, bedrockEnchants);
        }
    }

    @Override
    public void translateNbtToJava(@NonNull NbtMap bedrockTag, @NonNull DataComponents components, @NonNull ItemMapping mapping) {
        super.translateNbtToJava(bedrockTag, components, mapping);
        List<NbtMap> enchantmentTag = bedrockTag.getList("ench", NbtType.COMPOUND);
        if (enchantmentTag != null) {
            Int2IntOpenHashMap javaEnchantments = new Int2IntOpenHashMap(enchantmentTag.size());
            for (NbtMap bedrockEnchantment : enchantmentTag) {
                short bedrockId = bedrockEnchantment.getShort("id");
                Enchantment enchantment = Enchantment.getByBedrockId(bedrockId);
                if (enchantment != null) {
                    short level = bedrockEnchantment.getShort("lvl", (short)1);
                    javaEnchantments.put(Enchantment.JavaEnchantment.valueOf(enchantment.name()).ordinal(), level);
                    continue;
                }
                GeyserImpl.getInstance().getLogger().debug("Unknown bedrock enchantment: " + bedrockId);
            }
            if (!javaEnchantments.isEmpty()) {
                components.put(DataComponentType.STORED_ENCHANTMENTS, new ItemEnchantments(javaEnchantments, true));
            }
        }
    }
}

