/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.item.Enchantment;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.Identifier;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ItemEnchantments;

public class Item {
    private final String javaIdentifier;
    private int javaId = -1;
    private final int stackSize;
    private final int attackDamage;
    private final int maxDamage;

    public Item(String javaIdentifier, Builder builder) {
        this.javaIdentifier = Identifier.formalize(javaIdentifier).intern();
        this.stackSize = builder.stackSize;
        this.maxDamage = builder.maxDamage;
        this.attackDamage = builder.attackDamage;
    }

    public String javaIdentifier() {
        return this.javaIdentifier;
    }

    public int javaId() {
        return this.javaId;
    }

    public int maxDamage() {
        return this.maxDamage;
    }

    public int attackDamage() {
        return this.attackDamage;
    }

    public int maxStackSize() {
        return this.stackSize;
    }

    public boolean isValidRepairItem(Item other) {
        return false;
    }

    public ItemData.Builder translateToBedrock(int count, DataComponents components, ItemMapping mapping, ItemMappings mappings) {
        if (this == Items.AIR || count <= 0) {
            return ItemData.builder();
        }
        ItemData.Builder builder = ItemData.builder().definition(mapping.getBedrockDefinition()).damage(mapping.getBedrockData()).count(count);
        ItemTranslator.translateCustomItem(components, builder, mapping);
        return builder;
    }

    public @NonNull GeyserItemStack translateToJava(@NonNull ItemData itemData, @NonNull ItemMapping mapping, @NonNull ItemMappings mappings) {
        return GeyserItemStack.of(this.javaId, itemData.getCount());
    }

    public ItemMapping toBedrockDefinition(DataComponents components, ItemMappings mappings) {
        return mappings.getMapping(this.javaId);
    }

    public void translateComponentsToBedrock(@NonNull GeyserSession session, @NonNull DataComponents components, @NonNull BedrockItemBuilder builder) {
        Integer repairCost;
        Integer damage;
        List<Component> loreComponents = components.get(DataComponentType.LORE);
        if (loreComponents != null) {
            List<String> lore = builder.getOrCreateLore();
            for (Component loreComponent : loreComponents) {
                lore.add(MessageTranslator.convertMessage(loreComponent, session.locale()));
            }
        }
        if ((damage = components.get(DataComponentType.DAMAGE)) != null) {
            builder.setDamage(damage);
        }
        ArrayList<NbtMap> enchantNbtList = new ArrayList<NbtMap>();
        ItemEnchantments enchantments = components.get(DataComponentType.ENCHANTMENTS);
        if (enchantments != null) {
            for (Map.Entry<Integer, Integer> enchantment : enchantments.getEnchantments().entrySet()) {
                NbtMap enchantNbt = this.remapEnchantment(session, enchantment.getKey(), enchantment.getValue(), builder);
                if (enchantNbt == null) continue;
                enchantNbtList.add(enchantNbt);
            }
        }
        if (!enchantNbtList.isEmpty()) {
            builder.putList("ench", NbtType.COMPOUND, enchantNbtList);
        }
        if ((repairCost = components.get(DataComponentType.REPAIR_COST)) != null) {
            builder.putInt("RepairCost", repairCost);
        }
        builder.putInt("GeyserHash", components.hashCode());
    }

    public void translateNbtToJava(@NonNull NbtMap bedrockTag, @NonNull DataComponents components, @NonNull ItemMapping mapping) {
    }

    protected final @Nullable NbtMap remapEnchantment(GeyserSession session, int enchantId, int level, BedrockItemBuilder builder) {
        Enchantment.JavaEnchantment enchantment = Enchantment.JavaEnchantment.of(enchantId);
        if (enchantment == Enchantment.JavaEnchantment.SWEEPING_EDGE) {
            this.addSweeping(session, builder, level);
            return null;
        }
        if (enchantment == null) {
            GeyserImpl.getInstance().getLogger().debug("Unknown Java enchantment while NBT item translating: " + enchantId);
            return null;
        }
        return NbtMap.builder().putShort("id", (short)Enchantment.valueOf(enchantment.name()).ordinal()).putShort("lvl", (short)level).build();
    }

    private void addSweeping(GeyserSession session, BedrockItemBuilder builder, int level) {
        String sweepingTranslation = MinecraftLocale.getLocaleString("enchantment.minecraft.sweeping", session.locale());
        String lvlTranslation = MinecraftLocale.getLocaleString("enchantment.level." + level, session.locale());
        builder.getOrCreateLore().add("\u00a7r\u00a77" + sweepingTranslation + " " + lvlTranslation);
    }

    public GeyserItemStack newItemStack(int count, DataComponents components) {
        return GeyserItemStack.of(this.javaId, count, components);
    }

    public void setJavaId(int javaId) {
        if (this.javaId != -1) {
            throw new RuntimeException("Item ID has already been set!");
        }
        this.javaId = javaId;
    }

    public String toString() {
        return "Item{javaIdentifier='" + this.javaIdentifier + "', javaId=" + this.javaId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int stackSize = 64;
        private int maxDamage;
        private int attackDamage;

        public Builder stackSize(int stackSize) {
            this.stackSize = stackSize;
            return this;
        }

        public Builder attackDamage(double attackDamage) {
            this.attackDamage = (int)attackDamage;
            return this;
        }

        public Builder maxDamage(int maxDamage) {
            this.maxDamage = maxDamage;
            return this;
        }

        private Builder() {
        }
    }
}

