/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodec;
import org.cloudburstmc.protocol.bedrock.codec.v622.Bedrock_v622;
import org.cloudburstmc.protocol.bedrock.codec.v630.Bedrock_v630;
import org.cloudburstmc.protocol.bedrock.codec.v649.Bedrock_v649;
import org.cloudburstmc.protocol.bedrock.codec.v662.Bedrock_v662;
import org.cloudburstmc.protocol.bedrock.codec.v671.Bedrock_v671;
import org.geysermc.geyser.network.CodecProcessor;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodec;
import org.geysermc.mcprotocollib.protocol.codec.PacketCodec;

public final class GameProtocol {
    public static final BedrockCodec DEFAULT_BEDROCK_CODEC = CodecProcessor.processCodec(Bedrock_v671.CODEC);
    public static final List<BedrockCodec> SUPPORTED_BEDROCK_CODECS = new ArrayList<BedrockCodec>();
    private static final PacketCodec DEFAULT_JAVA_CODEC = MinecraftCodec.CODEC;

    public static @Nullable BedrockCodec getBedrockCodec(int protocolVersion) {
        for (BedrockCodec packetCodec : SUPPORTED_BEDROCK_CODECS) {
            if (packetCodec.getProtocolVersion() != protocolVersion) continue;
            return packetCodec;
        }
        return null;
    }

    public static boolean isPre1_20_50(GeyserSession session) {
        return session.getUpstream().getProtocolVersion() < Bedrock_v630.CODEC.getProtocolVersion();
    }

    public static boolean isPre1_20_70(GeyserSession session) {
        return session.getUpstream().getProtocolVersion() < Bedrock_v662.CODEC.getProtocolVersion();
    }

    public static boolean is1_20_60orHigher(int protocolVersion) {
        return protocolVersion >= Bedrock_v649.CODEC.getProtocolVersion();
    }

    public static PacketCodec getJavaCodec() {
        return DEFAULT_JAVA_CODEC;
    }

    public static List<String> getJavaVersions() {
        return List.of("1.20.5", DEFAULT_JAVA_CODEC.getMinecraftVersion());
    }

    public static int getJavaProtocolVersion() {
        return DEFAULT_JAVA_CODEC.getProtocolVersion();
    }

    public static String getJavaMinecraftVersion() {
        return DEFAULT_JAVA_CODEC.getMinecraftVersion();
    }

    public static String getAllSupportedBedrockVersions() {
        StringJoiner joiner = new StringJoiner(", ");
        for (BedrockCodec packetCodec : SUPPORTED_BEDROCK_CODECS) {
            joiner.add(packetCodec.getMinecraftVersion());
        }
        return joiner.toString();
    }

    public static String getAllSupportedJavaVersions() {
        StringJoiner joiner = new StringJoiner(", ");
        for (String version : GameProtocol.getJavaVersions()) {
            joiner.add(version);
        }
        return joiner.toString();
    }

    private GameProtocol() {
    }

    static {
        SUPPORTED_BEDROCK_CODECS.add(CodecProcessor.processCodec(Bedrock_v622.CODEC.toBuilder().minecraftVersion("1.20.40/1.20.41").build()));
        SUPPORTED_BEDROCK_CODECS.add(CodecProcessor.processCodec(Bedrock_v630.CODEC.toBuilder().minecraftVersion("1.20.50/1.20.51").build()));
        SUPPORTED_BEDROCK_CODECS.add(CodecProcessor.processCodec(Bedrock_v649.CODEC.toBuilder().minecraftVersion("1.20.60/1.20.62").build()));
        SUPPORTED_BEDROCK_CODECS.add(CodecProcessor.processCodec(Bedrock_v662.CODEC.toBuilder().minecraftVersion("1.20.70/1.20.73").build()));
        SUPPORTED_BEDROCK_CODECS.add(CodecProcessor.processCodec(DEFAULT_BEDROCK_CODEC.toBuilder().minecraftVersion("1.20.80").build()));
    }
}

