/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot.command;

import com.destroystokyo.paper.event.brigadier.AsyncPlayerSendCommandsEvent;
import com.mojang.brigadier.tree.CommandNode;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.command.Command;

public final class GeyserPaperCommandListener
implements Listener {
    @EventHandler
    public void onCommandSend(AsyncPlayerSendCommandsEvent<?> event) {
        CommandNode geyserBrigadier;
        if (event.isAsynchronous() && (geyserBrigadier = event.getCommandNode().getChild("geyser")) != null) {
            Player player = event.getPlayer();
            boolean isJavaPlayer = this.isProbablyJavaPlayer(player);
            Map<String, Command> commands = GeyserImpl.getInstance().commandManager().getCommands();
            Iterator it = geyserBrigadier.getChildren().iterator();
            while (it.hasNext()) {
                CommandNode subnode = (CommandNode)it.next();
                Command command = commands.get(subnode.getName());
                if (command == null || (!command.isBedrockOnly() || !isJavaPlayer) && player.hasPermission(command.permission())) continue;
                it.remove();
            }
        }
    }

    private boolean isProbablyJavaPlayer(Player player) {
        InetSocketAddress address;
        if (GeyserImpl.getInstance().connectionByUuid(player.getUniqueId()) != null) {
            return false;
        }
        if (GeyserImpl.getInstance().getConfig().isUseDirectConnection() && (address = player.getAddress()) != null) {
            return address.getPort() != 0;
        }
        return true;
    }
}

