/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntList;
import org.geysermc.geyser.registry.type.BlockMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.BlockTag;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.mcprotocollib.protocol.packet.common.clientbound.ClientboundUpdateTagsPacket;

@ParametersAreNonnullByDefault
public final class TagCache {
    public static final Map<String, BlockTag> ALL_BLOCK_TAGS = new HashMap<String, BlockTag>();
    public static final Map<String, ItemTag> ALL_ITEM_TAGS = new HashMap<String, ItemTag>();
    private final Map<BlockTag, IntList> blocks = new EnumMap<BlockTag, IntList>(BlockTag.class);
    private final Map<ItemTag, IntList> items = new EnumMap<ItemTag, IntList>(ItemTag.class);

    public void loadPacket(GeyserSession session, ClientboundUpdateTagsPacket packet) {
        Map<String, int[]> blockTags = packet.getTags().get("minecraft:block");
        this.blocks.clear();
        ALL_BLOCK_TAGS.forEach((location, tag) -> {
            int[] values = (int[])blockTags.get(location);
            if (values != null) {
                this.blocks.put((BlockTag)((Object)tag), IntList.of(values));
            } else {
                session.getGeyser().getLogger().debug("Block tag not found from server: " + location);
            }
        });
        GeyserLogger logger = session.getGeyser().getLogger();
        int[] convertableToMud = blockTags.get("minecraft:convertable_to_mud");
        boolean emulatePost1_18Logic = convertableToMud != null && convertableToMud.length != 0;
        session.setEmulatePost1_18Logic(emulatePost1_18Logic);
        if (logger.isDebug()) {
            logger.debug("Emulating post 1.18 block predication logic for " + session.bedrockUsername() + "? " + emulatePost1_18Logic);
        }
        Map<String, int[]> itemTags = packet.getTags().get("minecraft:item");
        this.items.clear();
        ALL_ITEM_TAGS.forEach((location, tag) -> {
            int[] values = (int[])itemTags.get(location);
            if (values != null) {
                this.items.put((ItemTag)((Object)tag), IntList.of(values));
            } else {
                session.getGeyser().getLogger().debug("Item tag not found from server: " + location);
            }
        });
        boolean emulatePost1_13Logic = itemTags.get("minecraft:signs").length > 1;
        session.setEmulatePost1_13Logic(emulatePost1_13Logic);
        if (logger.isDebug()) {
            logger.debug("Emulating post 1.13 villager logic for " + session.bedrockUsername() + "? " + emulatePost1_13Logic);
        }
    }

    public boolean is(BlockTag tag, BlockMapping mapping) {
        IntList values = this.blocks.get((Object)tag);
        if (values != null) {
            return values.contains(mapping.getJavaBlockId());
        }
        return false;
    }

    public boolean is(ItemTag tag, GeyserItemStack itemStack) {
        return this.is(tag, itemStack.asItem());
    }

    public boolean is(ItemTag tag, Item item) {
        IntList values = this.items.get((Object)tag);
        if (values != null) {
            return values.contains(item.javaId());
        }
        return false;
    }
}

