/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import java.util.Collections;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.erosion.util.LecternUtils;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.LecternContainer;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.inventory.updater.ContainerInventoryUpdater;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.util.BlockEntityUtils;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.WritableBookContent;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.WrittenBookContent;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundContainerButtonClickPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundContainerClosePacket;

public class LecternInventoryTranslator
extends AbstractBlockInventoryTranslator {
    private boolean initialized = false;

    public LecternInventoryTranslator() {
        super(1, "minecraft:lectern[facing=north,has_book=true,powered=true]", org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType.LECTERN, ContainerInventoryUpdater.INSTANCE, new String[0]);
    }

    @Override
    public boolean prepareInventory(GeyserSession session, Inventory inventory) {
        super.prepareInventory(session, inventory);
        if (((Container)inventory).isUsingRealBlock()) {
            this.initialized = false;
        } else {
            this.updateBook(session, inventory, inventory.getItem(0));
            this.initialized = true;
        }
        return true;
    }

    @Override
    public void openInventory(GeyserSession session, Inventory inventory) {
        if (this.initialized && !session.isDroppingLecternBook()) {
            super.openInventory(session, inventory);
        }
    }

    @Override
    public void closeInventory(GeyserSession session, Inventory inventory) {
        LecternContainer lecternContainer = (LecternContainer)inventory;
        Vector3i position = lecternContainer.isUsingRealBlock() ? session.getLastInteractionBlockPosition() : inventory.getHolderPosition();
        NbtMapBuilder baseLecternTag = LecternUtils.getBaseLecternTag(position.getX(), position.getY(), position.getZ(), 0);
        BlockEntityUtils.updateBlockEntity(session, baseLecternTag.build(), position);
        super.closeInventory(session, inventory);
        if (lecternContainer.isUsingRealBlock()) {
            GeyserImpl.getInstance().getWorldManager().sendLecternData(session, position.getX(), position.getY(), position.getZ());
        }
    }

    @Override
    public void updateProperty(GeyserSession session, Inventory inventory, int key, int value) {
        if (key == 0) {
            LecternContainer lecternContainer = (LecternContainer)inventory;
            lecternContainer.setCurrentBedrockPage(value / 2);
            lecternContainer.setBlockEntityTag(lecternContainer.getBlockEntityTag().toBuilder().putInt("page", lecternContainer.getCurrentBedrockPage()).build());
            BlockEntityUtils.updateBlockEntity(session, lecternContainer.getBlockEntityTag(), lecternContainer.getPosition());
        }
    }

    @Override
    public void updateInventory(GeyserSession session, Inventory inventory) {
        GeyserItemStack itemStack = inventory.getItem(0);
        if (!itemStack.isEmpty()) {
            boolean isDropping = session.isDroppingLecternBook();
            this.updateBook(session, inventory, itemStack);
            if (!this.initialized && !isDropping) {
                this.initialized = true;
                this.openInventory(session, inventory);
            }
        }
    }

    @Override
    public void updateSlot(GeyserSession session, Inventory inventory, int slot) {
        if (((LecternContainer)inventory).isFakeLectern()) {
            InventoryTranslator.PLAYER_INVENTORY_TRANSLATOR.updateSlot(session, session.getPlayerInventory(), slot);
            return;
        }
        super.updateSlot(session, inventory, slot);
        if (slot == 0) {
            this.updateBook(session, inventory, inventory.getItem(0));
        }
    }

    private void updateBook(GeyserSession session, Inventory inventory, GeyserItemStack book) {
        LecternContainer lecternContainer = (LecternContainer)inventory;
        if (session.isDroppingLecternBook()) {
            ServerboundContainerButtonClickPacket packet = new ServerboundContainerButtonClickPacket(inventory.getJavaId(), 3);
            session.sendDownstreamGamePacket(packet);
            session.setDroppingLecternBook(false);
            InventoryUtils.closeInventory(session, inventory.getJavaId(), false);
        } else if (lecternContainer.getBlockEntityTag() == null) {
            NbtMap blockEntityTag;
            boolean shouldRefresh;
            Vector3i position = lecternContainer.isUsingRealBlock() ? session.getLastInteractionBlockPosition() : inventory.getHolderPosition();
            boolean bl = shouldRefresh = !session.getGeyser().getWorldManager().shouldExpectLecternHandled(session) && !session.getLecternCache().contains(position) && !GameProtocol.is1_20_60orHigher(session.getUpstream().getProtocolVersion());
            if (book.getComponents() != null) {
                int pages = 0;
                WrittenBookContent writtenBookComponents = book.getComponents().get(DataComponentType.WRITTEN_BOOK_CONTENT);
                if (writtenBookComponents != null) {
                    pages = writtenBookComponents.getPages().size();
                } else {
                    WritableBookContent writableBookComponents = book.getComponents().get(DataComponentType.WRITABLE_BOOK_CONTENT);
                    if (writableBookComponents != null) {
                        pages = writableBookComponents.getPages().size();
                    }
                }
                ItemData itemData = book.getItemData(session);
                NbtMapBuilder lecternTag = LecternUtils.getBaseLecternTag(position.getX(), position.getY(), position.getZ(), pages);
                lecternTag.putCompound("book", NbtMap.builder().putByte("Count", (byte)itemData.getCount()).putShort("Damage", (short)0).putString("Name", "minecraft:written_book").putCompound("tag", itemData.getTag()).build());
                lecternTag.putInt("page", lecternContainer.getCurrentBedrockPage());
                blockEntityTag = lecternTag.build();
            } else {
                NbtMapBuilder lecternTag = LecternUtils.getBaseLecternTag(position.getX(), position.getY(), position.getZ(), 1);
                NbtMapBuilder bookTag = NbtMap.builder().putByte("Count", (byte)1).putShort("Damage", (short)0).putString("Name", "minecraft:writable_book").putCompound("tag", NbtMap.builder().putList("pages", NbtType.COMPOUND, Collections.singletonList(NbtMap.builder().putString("photoname", "").putString("text", "").build())).build());
                blockEntityTag = lecternTag.putCompound("book", bookTag.build()).build();
            }
            lecternContainer.setBlockEntityTag(blockEntityTag);
            lecternContainer.setPosition(position);
            BlockEntityUtils.updateBlockEntity(session, blockEntityTag, position);
            if (shouldRefresh) {
                session.getLecternCache().add(position);
                ServerboundContainerClosePacket closeWindowPacket = new ServerboundContainerClosePacket(lecternContainer.getJavaId());
                session.sendDownstreamGamePacket(closeWindowPacket);
                InventoryUtils.closeInventory(session, inventory.getJavaId(), false);
            }
        }
    }

    @Override
    public Inventory createInventory(String name, int windowId, ContainerType containerType, PlayerInventory playerInventory) {
        return new LecternContainer(name, windowId, this.size + playerInventory.getSize(), containerType, playerInventory);
    }
}

