/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.item.type.BannerItem;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.translator.level.block.entity.RequiresBlockState;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;

@BlockEntity(type={BlockEntityType.BANNER})
public class BannerBlockEntityTranslator
extends BlockEntityTranslator
implements RequiresBlockState {
    @Override
    public void translateTag(GeyserSession session, NbtMapBuilder bedrockNbt, @Nullable NbtMap javaNbt, int blockState) {
        String customName;
        int bannerColor = BlockStateValues.getBannerColor(blockState);
        if (bannerColor != -1) {
            bedrockNbt.putInt("Base", 15 - bannerColor);
        }
        if (javaNbt == null) {
            return;
        }
        List<NbtMap> patterns = javaNbt.getList("patterns", NbtType.COMPOUND);
        if (!patterns.isEmpty()) {
            if (BannerItem.isOminous(patterns)) {
                bedrockNbt.putInt("Type", 1);
            } else {
                bedrockNbt.putList("Patterns", NbtType.COMPOUND, BannerItem.convertBannerPattern(patterns));
            }
        }
        if ((customName = javaNbt.getString("CustomName", null)) != null) {
            bedrockNbt.putString("CustomName", customName);
        }
    }
}

