/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.translator.level.block.entity.RequiresBlockState;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;

@BlockEntity(type={BlockEntityType.BRUSHABLE_BLOCK})
public class BrushableBlockEntityTranslator
extends BlockEntityTranslator
implements RequiresBlockState {
    @Override
    public void translateTag(GeyserSession session, NbtMapBuilder bedrockNbt, @Nullable NbtMap javaNbt, int blockState) {
        if (javaNbt == null) {
            return;
        }
        NbtMap itemTag = javaNbt.getCompound("item");
        if (itemTag.isEmpty()) {
            return;
        }
        byte hitDirection = javaNbt.getByte("hit_direction", (byte)-1);
        if (hitDirection == -1) {
            return;
        }
        String id = itemTag.getString("id");
        if (Items.AIR.javaIdentifier().equals(id)) {
            return;
        }
        ItemMapping mapping = session.getItemMappings().getMapping(id);
        if (mapping == null) {
            return;
        }
        NbtMapBuilder itemBuilder = NbtMap.builder().putString("Name", mapping.getBedrockIdentifier()).putByte("Count", itemTag.getByte("Count"));
        bedrockNbt.putCompound("item", itemBuilder.build());
        bedrockNbt.putByte("brush_direction", hitDirection);
        bedrockNbt.putInt("brush_count", BlockStateValues.getBrushProgress(blockState));
    }
}

