/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import java.util.List;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;

@BlockEntity(type={BlockEntityType.CAMPFIRE})
public class CampfireBlockEntityTranslator
extends BlockEntityTranslator {
    @Override
    public void translateTag(GeyserSession session, NbtMapBuilder bedrockNbt, NbtMap javaNbt, int blockState) {
        List<NbtMap> items = javaNbt.getList("Items", NbtType.COMPOUND);
        if (items != null) {
            int i = 1;
            for (NbtMap itemTag : items) {
                bedrockNbt.put("Item" + i, (Object)this.getItem(session, itemTag));
                ++i;
            }
        }
    }

    protected NbtMap getItem(GeyserSession session, NbtMap tag) {
        ItemMapping mapping = session.getItemMappings().getMapping(tag.getString("id"));
        if (mapping == null) {
            mapping = ItemMapping.AIR;
        }
        NbtMapBuilder tagBuilder = BedrockItemBuilder.createItemNbt(mapping, tag.getByte("Count"), mapping.getBedrockData());
        tagBuilder.put("tag", (Object)NbtMap.builder().build());
        return tagBuilder.build();
    }
}

