/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.level.block.DoubleChestValue;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.level.block.entity.BedrockOnlyBlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.util.BlockEntityUtils;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;

@BlockEntity(type={BlockEntityType.CHEST, BlockEntityType.TRAPPED_CHEST})
public class DoubleChestBlockEntityTranslator
extends BlockEntityTranslator
implements BedrockOnlyBlockEntity {
    @Override
    public boolean isBlock(int blockState) {
        return BlockStateValues.getDoubleChestValues().containsKey(blockState);
    }

    @Override
    public void updateBlock(GeyserSession session, int blockState, Vector3i position) {
        NbtMapBuilder tagBuilder = DoubleChestBlockEntityTranslator.getConstantBedrockTag(BlockEntityUtils.getBedrockBlockEntityId(BlockEntityType.CHEST), position.getX(), position.getY(), position.getZ());
        this.translateTag(session, tagBuilder, null, blockState);
        BlockEntityUtils.updateBlockEntity(session, tagBuilder.build(), position);
    }

    @Override
    public void translateTag(GeyserSession session, NbtMapBuilder bedrockNbt, NbtMap javaNbt, int blockState) {
        DoubleChestValue chestValues = (DoubleChestValue)BlockStateValues.getDoubleChestValues().get(blockState);
        if (chestValues != null) {
            int x = (Integer)bedrockNbt.get("x");
            int z = (Integer)bedrockNbt.get("z");
            DoubleChestBlockEntityTranslator.translateChestValue(bedrockNbt, chestValues, x, z);
        }
    }

    public static void translateChestValue(NbtMapBuilder builder, DoubleChestValue chestValues, int x, int z) {
        if (chestValues.isFacingEast()) {
            z = chestValues.isDirectionPositive() ? (z += chestValues.isLeft() ? 1 : -1) : (z += chestValues.isLeft() ? -1 : 1);
        } else {
            x = chestValues.isDirectionPositive() ? (x += chestValues.isLeft() ? -1 : 1) : (x += chestValues.isLeft() ? 1 : -1);
        }
        builder.putInt("pairx", x);
        builder.putInt("pairz", z);
        if (!chestValues.isLeft()) {
            builder.putInt("pairlead", 1);
        }
    }
}

