/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity;

import org.cloudburstmc.protocol.bedrock.data.entity.EntityEventType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.EntityEventPacket;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.living.MobEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundSetEntityLinkPacket;

@Translator(packet=ClientboundSetEntityLinkPacket.class)
public class JavaSetEntityLinkTranslator
extends PacketTranslator<ClientboundSetEntityLinkPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundSetEntityLinkPacket packet) {
        Entity holderId = session.getEntityCache().getEntityByJavaId(packet.getEntityId());
        if (!(holderId instanceof MobEntity)) {
            return;
        }
        MobEntity mobEntity = (MobEntity)holderId;
        Entity attachedToId = session.getEntityCache().getEntityByJavaId(packet.getAttachedToId());
        if (attachedToId == null || packet.getAttachedToId() == 0) {
            mobEntity.setFlag(EntityFlag.LEASHED, false);
            mobEntity.setLeashHolderBedrockId(-1L);
            mobEntity.updateBedrockMetadata();
            EntityEventPacket eventPacket = new EntityEventPacket();
            eventPacket.setRuntimeEntityId(holderId.getGeyserId());
            eventPacket.setType(EntityEventType.REMOVE_LEASH);
            eventPacket.setData(0);
            session.sendUpstreamPacket(eventPacket);
            return;
        }
        mobEntity.setFlag(EntityFlag.LEASHED, true);
        mobEntity.setLeashHolderBedrockId(attachedToId.getGeyserId());
        holderId.updateBedrockMetadata();
    }
}

