/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.inventory;

import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.translator.inventory.PlayerInventoryTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.inventory.ClientboundContainerSetContentPacket;

@Translator(packet=ClientboundContainerSetContentPacket.class)
public class JavaContainerSetContentTranslator
extends PacketTranslator<ClientboundContainerSetContentPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundContainerSetContentPacket packet) {
        Inventory inventory = InventoryUtils.getInventory(session, packet.getContainerId());
        if (inventory == null) {
            return;
        }
        int inventorySize = inventory.getSize();
        for (int i = 0; i < packet.getItems().length; ++i) {
            if (i >= inventorySize) {
                GeyserLogger logger = session.getGeyser().getLogger();
                logger.warning("ClientboundContainerSetContentPacket sent to " + session.bedrockUsername() + " that exceeds inventory size!");
                if (logger.isDebug()) {
                    logger.debug(packet);
                    logger.debug(inventory);
                }
                this.updateInventory(session, inventory, packet.getContainerId());
                return;
            }
            GeyserItemStack newItem = GeyserItemStack.from(packet.getItems()[i]);
            inventory.setItem(i, newItem, session);
        }
        this.updateInventory(session, inventory, packet.getContainerId());
        int stateId = packet.getStateId();
        session.setEmulatePost1_16Logic(stateId > 0 || stateId != inventory.getStateId());
        inventory.setStateId(stateId);
        session.getPlayerInventory().setCursor(GeyserItemStack.from(packet.getCarriedItem()), session);
        InventoryUtils.updateCursor(session);
    }

    private void updateInventory(GeyserSession session, Inventory inventory, int containerId) {
        InventoryTranslator translator = session.getInventoryTranslator();
        if (containerId == 0 && !(translator instanceof PlayerInventoryTranslator)) {
            InventoryTranslator.PLAYER_INVENTORY_TRANSLATOR.updateInventory(session, inventory);
        } else if (translator != null) {
            translator.updateInventory(session, inventory);
        }
    }
}

