/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.level;

import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.data.structure.StructureMirror;
import org.cloudburstmc.protocol.bedrock.data.structure.StructureRotation;
import org.cloudburstmc.protocol.bedrock.packet.ContainerOpenPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.translator.level.block.entity.RequiresBlockState;
import org.geysermc.geyser.translator.level.block.entity.SkullBlockEntityTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.BlockEntityUtils;
import org.geysermc.geyser.util.StructureBlockUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level.ClientboundBlockEntityDataPacket;

@Translator(packet=ClientboundBlockEntityDataPacket.class)
public class JavaBlockEntityDataTranslator
extends PacketTranslator<ClientboundBlockEntityDataPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundBlockEntityDataPacket packet) {
        BlockDefinition blockDefinition;
        BlockEntityType type = packet.getType();
        if (type == null) {
            return;
        }
        BlockEntityTranslator translator = BlockEntityUtils.getBlockEntityTranslator(type);
        int blockState = translator instanceof RequiresBlockState ? session.getGeyser().getWorldManager().getBlockAt(session, packet.getPosition()) : 0;
        Vector3i position = packet.getPosition();
        BlockEntityUtils.updateBlockEntity(session, translator.getBlockEntityTag(session, type, position.getX(), position.getY(), position.getZ(), packet.getNbt(), blockState), packet.getPosition());
        boolean hasCustomHeadBlock = false;
        if (session.getPreferencesCache().showCustomSkulls() && packet.getNbt() != null && packet.getNbt().containsKey("profile") && (blockDefinition = SkullBlockEntityTranslator.translateSkull(session, packet.getNbt(), position, blockState)) != null) {
            hasCustomHeadBlock = true;
            UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
            updateBlockPacket.setDataLayer(0);
            updateBlockPacket.setBlockPosition(position);
            updateBlockPacket.setDefinition(blockDefinition);
            updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NEIGHBORS);
            updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NETWORK);
            session.sendUpstreamPacket(updateBlockPacket);
        }
        if (!hasCustomHeadBlock) {
            BlockEntityUtils.updateBlockEntity(session, translator.getBlockEntityTag(session, type, position.getX(), position.getY(), position.getZ(), packet.getNbt(), blockState), packet.getPosition());
        }
        if (type == BlockEntityType.COMMAND_BLOCK && session.getOpPermissionLevel() >= 2 && session.getGameMode() == GameMode.CREATIVE && packet.getNbt() != null && packet.getNbt().size() > 5) {
            ContainerOpenPacket openPacket = new ContainerOpenPacket();
            openPacket.setBlockPosition(position);
            openPacket.setId((byte)1);
            openPacket.setType(ContainerType.COMMAND_BLOCK);
            openPacket.setUniqueEntityId(-1L);
            session.sendUpstreamPacket(openPacket);
        }
        if (type == BlockEntityType.STRUCTURE_BLOCK && session.getGameMode() == GameMode.CREATIVE && packet.getPosition().equals(session.getStructureBlockCache().getCurrentStructureBlock()) && packet.getNbt() != null && packet.getNbt().size() > 5) {
            String rotation;
            String mirror;
            NbtMap map = packet.getNbt();
            String mode = map.getString("mode");
            if (!mode.equalsIgnoreCase("LOAD")) {
                return;
            }
            StructureMirror bedrockMirror = switch (mirror = map.getString("mirror")) {
                case "FRONT_BACK" -> StructureMirror.X;
                case "LEFT_RIGHT" -> StructureMirror.Z;
                default -> StructureMirror.NONE;
            };
            StructureRotation bedrockRotation = switch (rotation = map.getString("rotation")) {
                case "CLOCKWISE_90" -> StructureRotation.ROTATE_90;
                case "CLOCKWISE_180" -> StructureRotation.ROTATE_180;
                case "COUNTERCLOCKWISE_90" -> StructureRotation.ROTATE_270;
                default -> StructureRotation.NONE;
            };
            String name = map.getString("name");
            int sizeX = map.getInt("sizeX");
            int sizeY = map.getInt("sizeY");
            int sizeZ = map.getInt("sizeZ");
            session.getStructureBlockCache().setCurrentStructureBlock(null);
            Vector3i size = Vector3i.from(sizeX, sizeY, sizeZ);
            if (size.equals(Vector3i.ZERO)) {
                StructureBlockUtils.sendEmptyStructureData(session);
                return;
            }
            Vector3i offset = StructureBlockUtils.calculateOffset(bedrockRotation, bedrockMirror, sizeX, sizeZ);
            session.getStructureBlockCache().setBedrockOffset(offset);
            session.getStructureBlockCache().setCurrentStructureName(name);
            StructureBlockUtils.sendStructureData(session, size, name);
        }
    }
}

