/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.level;

import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.protocol.bedrock.packet.BlockEntityDataPacket;
import org.cloudburstmc.protocol.bedrock.packet.BlockEventPacket;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2IntMaps;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.PistonCache;
import org.geysermc.geyser.translator.level.block.entity.PistonBlockEntity;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.BellValue;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.BlockValue;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.ChestValue;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.EndGatewayValue;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.MobSpawnerValue;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.NoteBlockValue;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.PistonValue;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.value.PistonValueType;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level.ClientboundBlockEventPacket;

@Translator(packet=ClientboundBlockEventPacket.class)
public class JavaBlockEventTranslator
extends PacketTranslator<ClientboundBlockEventPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundBlockEventPacket packet) {
        Vector3i position = packet.getPosition();
        BlockValue value = packet.getValue();
        BlockEventPacket blockEventPacket = new BlockEventPacket();
        blockEventPacket.setBlockPosition(position);
        if (value instanceof ChestValue) {
            ChestValue chestValue = (ChestValue)value;
            blockEventPacket.setEventType(1);
            blockEventPacket.setEventData(chestValue.getViewers() > 0 ? 1 : 0);
            session.sendUpstreamPacket(blockEventPacket);
        } else if (value instanceof EndGatewayValue) {
            blockEventPacket.setEventType(1);
            session.sendUpstreamPacket(blockEventPacket);
        } else if (value instanceof NoteBlockValue) {
            session.getGeyser().getWorldManager().getBlockAtAsync(session, position).thenAccept(blockState -> {
                blockEventPacket.setEventData(BlockStateValues.getNoteblockPitch(blockState));
                session.sendUpstreamPacket(blockEventPacket);
            });
        } else if (value instanceof PistonValue) {
            PistonValue pistonValue = (PistonValue)value;
            PistonValueType action = (PistonValueType)packet.getType();
            org.geysermc.geyser.level.physics.Direction direction = org.geysermc.geyser.level.physics.Direction.fromPistonValue(pistonValue.getDirection());
            PistonCache pistonCache = session.getPistonCache();
            if (session.getGeyser().getPlatformType() == PlatformType.SPIGOT || session.getErosionHandler().isActive()) {
                if (action == PistonValueType.PULLING || action == PistonValueType.CANCELLED_MID_PUSH) {
                    PistonBlockEntity blockEntity;
                    int pistonBlock = session.getGeyser().getWorldManager().getBlockAt(session, position);
                    if (!BlockStateValues.isStickyPiston(pistonBlock)) {
                        return;
                    }
                    if (action != PistonValueType.CANCELLED_MID_PUSH) {
                        Vector3i blockInFrontPos = position.add(direction.getUnitVector());
                        int blockInFront = session.getGeyser().getWorldManager().getBlockAt(session, blockInFrontPos);
                        if (blockInFront != 0) {
                            return;
                        }
                    }
                    if ((blockEntity = pistonCache.getPistons().computeIfAbsent(position, pos -> new PistonBlockEntity(session, (Vector3i)pos, direction, true, true))).getAction() != action) {
                        blockEntity.setAction(action, Object2IntMaps.emptyMap());
                    }
                }
            } else {
                PistonBlockEntity blockEntity = pistonCache.getPistons().computeIfAbsent(position, pos -> {
                    int blockId = session.getGeyser().getWorldManager().getBlockAt(session, position);
                    boolean sticky = BlockStateValues.isStickyPiston(blockId);
                    boolean extended = action != PistonValueType.PUSHING;
                    return new PistonBlockEntity(session, (Vector3i)pos, direction, sticky, extended);
                });
                blockEntity.setAction(action);
            }
        } else if (value instanceof MobSpawnerValue) {
            blockEventPacket.setEventType(1);
            session.sendUpstreamPacket(blockEventPacket);
        } else if (value instanceof BellValue) {
            BellValue bellValue = (BellValue)value;
            BlockEntityDataPacket blockEntityPacket = new BlockEntityDataPacket();
            blockEntityPacket.setBlockPosition(position);
            NbtMapBuilder builder = NbtMap.builder();
            builder.putInt("x", position.getX());
            builder.putInt("y", position.getY());
            builder.putInt("z", position.getZ());
            builder.putString("id", "Bell");
            int bedrockRingDirection = switch (bellValue.getDirection()) {
                case Direction.SOUTH -> 0;
                case Direction.WEST -> 1;
                case Direction.NORTH -> 2;
                case Direction.EAST -> 3;
                default -> throw new IllegalStateException("Unexpected BellValue Direction: " + bellValue.getDirection());
            };
            builder.putInt("Direction", bedrockRingDirection);
            builder.putByte("Ringing", (byte)1);
            builder.putInt("Ticks", 0);
            blockEntityPacket.setData(builder.build());
            session.sendUpstreamPacket(blockEntityPacket);
        }
    }
}

