/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import java.util.Locale;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.GameType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.BoatEntity;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.living.ArmorStandEntity;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.mcprotocollib.protocol.data.game.entity.Effect;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;

public final class EntityUtils {
    public static final Hand[] HANDS = Hand.values();

    public static String[] getAllEffectIdentifiers() {
        String[] identifiers = new String[Effect.VALUES.length];
        for (int i = 0; i < Effect.VALUES.length; ++i) {
            identifiers[i] = "minecraft:" + Effect.VALUES[i].name().toLowerCase(Locale.ROOT);
        }
        return identifiers;
    }

    public static int toBedrockEffectId(Effect effect) {
        return switch (effect) {
            case Effect.GLOWING, Effect.LUCK, Effect.UNLUCK, Effect.DOLPHINS_GRACE -> 0;
            case Effect.LEVITATION -> 24;
            case Effect.CONDUIT_POWER -> 26;
            case Effect.SLOW_FALLING -> 27;
            case Effect.BAD_OMEN -> 28;
            case Effect.HERO_OF_THE_VILLAGE -> 29;
            case Effect.DARKNESS -> 30;
            default -> effect.ordinal() + 1;
        };
    }

    private static float getMountedHeightOffset(Entity mount) {
        float height = mount.getBoundingBoxHeight();
        float mountedHeightOffset = height * 0.75f;
        switch (mount.getDefinition().entityType()) {
            case CAMEL: {
                boolean isBaby = mount.getFlag(EntityFlag.BABY);
                mountedHeightOffset = height - (isBaby ? 0.35f : 0.6f);
                break;
            }
            case CAVE_SPIDER: 
            case CHICKEN: 
            case SPIDER: {
                mountedHeightOffset = height * 0.5f;
                break;
            }
            case DONKEY: 
            case MULE: {
                mountedHeightOffset -= 0.25f;
                break;
            }
            case TRADER_LLAMA: 
            case LLAMA: {
                mountedHeightOffset = height * 0.6f;
                break;
            }
            case MINECART: 
            case HOPPER_MINECART: 
            case TNT_MINECART: 
            case CHEST_MINECART: 
            case FURNACE_MINECART: 
            case SPAWNER_MINECART: 
            case COMMAND_BLOCK_MINECART: {
                mountedHeightOffset = 0.0f;
                break;
            }
            case BOAT: 
            case CHEST_BOAT: {
                boolean isBamboo = ((BoatEntity)mount).getVariant() == 8;
                mountedHeightOffset = isBamboo ? 0.25f : -0.1f;
                break;
            }
            case HOGLIN: 
            case ZOGLIN: {
                boolean isBaby = mount.getFlag(EntityFlag.BABY);
                mountedHeightOffset = height - (isBaby ? 0.2f : 0.15f);
                break;
            }
            case PIGLIN: {
                mountedHeightOffset = height * 0.92f;
                break;
            }
            case PHANTOM: {
                mountedHeightOffset = height * 0.35f;
                break;
            }
            case RAVAGER: {
                mountedHeightOffset = 2.1f;
                break;
            }
            case SKELETON_HORSE: {
                mountedHeightOffset -= 0.1875f;
                break;
            }
            case SNIFFER: {
                mountedHeightOffset = 1.8f;
                break;
            }
            case STRIDER: {
                mountedHeightOffset = height - 0.19f;
            }
        }
        return mountedHeightOffset;
    }

    private static float getHeightOffset(Entity passenger) {
        switch (passenger.getDefinition().entityType()) {
            case ALLAY: 
            case VEX: {
                return 0.4f;
            }
            case SKELETON: 
            case STRAY: 
            case WITHER_SKELETON: {
                return -0.6f;
            }
            case ARMOR_STAND: {
                if (((ArmorStandEntity)passenger).isMarker()) {
                    return 0.0f;
                }
                return 0.1f;
            }
            case ENDERMITE: 
            case SILVERFISH: {
                return 0.1f;
            }
            case PIGLIN: 
            case PIGLIN_BRUTE: 
            case ZOMBIFIED_PIGLIN: {
                boolean isBaby = passenger.getFlag(EntityFlag.BABY);
                return isBaby ? -0.05f : -0.45f;
            }
            case DROWNED: 
            case HUSK: 
            case ZOMBIE_VILLAGER: 
            case ZOMBIE: {
                boolean isBaby = passenger.getFlag(EntityFlag.BABY);
                return isBaby ? 0.0f : -0.45f;
            }
            case RAVAGER: 
            case EVOKER: 
            case ILLUSIONER: 
            case PILLAGER: 
            case VINDICATOR: 
            case WITCH: {
                return -0.45f;
            }
            case PLAYER: {
                return -0.35f;
            }
            case SHULKER: {
                Entity vehicle = passenger.getVehicle();
                if (!(vehicle instanceof BoatEntity) && vehicle.getDefinition() != EntityDefinitions.MINECART) break;
                return 0.1875f - EntityUtils.getMountedHeightOffset(vehicle);
            }
        }
        if (passenger instanceof AnimalEntity) {
            return 0.14f;
        }
        return 0.0f;
    }

    public static void updateMountOffset(Entity passenger, Entity mount, boolean rider, boolean riding, boolean moreThanOneEntity) {
        passenger.setFlag(EntityFlag.RIDING, riding);
        if (riding) {
            float mountedHeightOffset = EntityUtils.getMountedHeightOffset(mount);
            float heightOffset = EntityUtils.getHeightOffset(passenger);
            float xOffset = 0.0f;
            float yOffset = mountedHeightOffset + heightOffset;
            float zOffset = 0.0f;
            switch (mount.getDefinition().entityType()) {
                case BOAT: {
                    if (!moreThanOneEntity) break;
                    xOffset = rider ? 0.2f : -0.6f;
                    if (!(passenger instanceof AnimalEntity)) break;
                    xOffset += 0.2f;
                    break;
                }
                case CAMEL: {
                    zOffset = 0.5f;
                    if (moreThanOneEntity) {
                        if (!rider) {
                            zOffset = -0.7f;
                        }
                        if (passenger instanceof AnimalEntity) {
                            zOffset += 0.2f;
                        }
                    }
                    if (!mount.getFlag(EntityFlag.SITTING)) break;
                    if (mount.getFlag(EntityFlag.BABY)) {
                        yOffset += 0.715f;
                        break;
                    }
                    yOffset += 1.43f;
                    break;
                }
                case CHEST_BOAT: {
                    xOffset = 0.15f;
                    break;
                }
                case CHICKEN: {
                    zOffset = -0.1f;
                    break;
                }
                case TRADER_LLAMA: 
                case LLAMA: {
                    zOffset = -0.3f;
                }
            }
            if (mount.getDefinition().entityType() == EntityType.PLAYER) {
                yOffset -= EntityDefinitions.PLAYER.offset();
            }
            if (passenger.getDefinition().entityType() == EntityType.PLAYER) {
                yOffset += EntityDefinitions.PLAYER.offset();
            }
            switch (mount.getDefinition().entityType()) {
                case MINECART: 
                case HOPPER_MINECART: 
                case TNT_MINECART: 
                case CHEST_MINECART: 
                case FURNACE_MINECART: 
                case SPAWNER_MINECART: 
                case COMMAND_BLOCK_MINECART: 
                case BOAT: 
                case CHEST_BOAT: {
                    yOffset -= mount.getDefinition().height() * 0.5f;
                }
            }
            switch (passenger.getDefinition().entityType()) {
                case MINECART: 
                case HOPPER_MINECART: 
                case TNT_MINECART: 
                case CHEST_MINECART: 
                case FURNACE_MINECART: 
                case SPAWNER_MINECART: 
                case COMMAND_BLOCK_MINECART: 
                case BOAT: 
                case CHEST_BOAT: {
                    yOffset += passenger.getDefinition().height() * 0.5f;
                    break;
                }
                case FALLING_BLOCK: {
                    yOffset += 0.5f;
                }
            }
            if (mount instanceof ArmorStandEntity) {
                ArmorStandEntity armorStand = (ArmorStandEntity)mount;
                yOffset -= armorStand.getYOffset();
            }
            Vector3f offset = Vector3f.from(xOffset, yOffset, zOffset);
            passenger.setRiderSeatPosition(offset);
        }
    }

    public static void updateRiderRotationLock(Entity passenger, Entity mount, boolean isRiding) {
        if (isRiding && mount instanceof BoatEntity) {
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_LOCK_RIDER_ROTATION, true);
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_LOCK_RIDER_ROTATION_DEGREES, Float.valueOf(90.0f));
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_HAS_ROTATION, true);
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_ROTATION_OFFSET_DEGREES, Float.valueOf(-90.0f));
        } else {
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_LOCK_RIDER_ROTATION, false);
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_LOCK_RIDER_ROTATION_DEGREES, Float.valueOf(0.0f));
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_HAS_ROTATION, false);
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_ROTATION_OFFSET_DEGREES, Float.valueOf(0.0f));
        }
    }

    public static boolean attemptToBucket(GeyserItemStack itemInHand) {
        return itemInHand.asItem() == Items.WATER_BUCKET;
    }

    public static InteractionResult attemptToSaddle(Entity entityToSaddle, GeyserItemStack itemInHand) {
        if (itemInHand.asItem() == Items.SADDLE && !entityToSaddle.getFlag(EntityFlag.SADDLED) && !entityToSaddle.getFlag(EntityFlag.BABY)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static GameType toBedrockGamemode(GameMode gamemode) {
        return switch (gamemode) {
            case GameMode.CREATIVE -> GameType.CREATIVE;
            case GameMode.ADVENTURE -> GameType.ADVENTURE;
            case GameMode.SPECTATOR -> GameType.SURVIVAL_VIEWER;
            default -> GameType.SURVIVAL;
        };
    }

    private EntityUtils() {
    }
}

