/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol;

import com.github.steveice10.mc.auth.data.GameProfile;
import io.netty.buffer.ByteBuf;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Objects;
import java.util.UUID;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtUtils;
import org.geysermc.mcprotocollib.network.Server;
import org.geysermc.mcprotocollib.network.Session;
import org.geysermc.mcprotocollib.network.codec.PacketCodecHelper;
import org.geysermc.mcprotocollib.network.codec.PacketDefinition;
import org.geysermc.mcprotocollib.network.crypt.AESEncryption;
import org.geysermc.mcprotocollib.network.crypt.PacketEncryption;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.network.packet.PacketHeader;
import org.geysermc.mcprotocollib.network.packet.PacketProtocol;
import org.geysermc.mcprotocollib.protocol.ClientListener;
import org.geysermc.mcprotocollib.protocol.MinecraftConstants;
import org.geysermc.mcprotocollib.protocol.ServerListener;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodec;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.PacketCodec;
import org.geysermc.mcprotocollib.protocol.codec.PacketStateCodec;
import org.geysermc.mcprotocollib.protocol.data.ProtocolState;

public class MinecraftProtocol
extends PacketProtocol {
    private static @Nullable NbtMap DEFAULT_NETWORK_CODEC;
    private final PacketCodec codec;
    private ProtocolState state;
    private PacketStateCodec stateCodec;
    private final ProtocolState targetState;
    private GameProfile profile;
    private String accessToken;
    private boolean useDefaultListeners = true;

    public MinecraftProtocol() {
        this(MinecraftCodec.CODEC);
    }

    public MinecraftProtocol(PacketCodec codec) {
        this.codec = codec;
        this.targetState = ProtocolState.STATUS;
        this.setState(ProtocolState.HANDSHAKE);
    }

    public MinecraftProtocol(@NonNull String username) {
        this(new GameProfile(UUID.randomUUID(), username), null);
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
    }

    public MinecraftProtocol(@NonNull PacketCodec codec, @NonNull String username) {
        this(codec, new GameProfile(UUID.randomUUID(), username), null);
        if (codec == null) {
            throw new NullPointerException("codec is marked non-null but is null");
        }
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
    }

    public MinecraftProtocol(@NonNull GameProfile profile, String accessToken) {
        this(MinecraftCodec.CODEC, profile, accessToken);
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
    }

    public MinecraftProtocol(@NonNull PacketCodec codec, @NonNull GameProfile profile, String accessToken) {
        if (codec == null) {
            throw new NullPointerException("codec is marked non-null but is null");
        }
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        this.codec = codec;
        this.targetState = ProtocolState.LOGIN;
        this.profile = profile;
        this.accessToken = accessToken;
        this.setState(ProtocolState.HANDSHAKE);
    }

    @Override
    public String getSRVRecordPrefix() {
        return "_minecraft";
    }

    @Override
    public PacketHeader getPacketHeader() {
        return MinecraftConstants.PACKET_HEADER;
    }

    @Override
    public MinecraftCodecHelper createHelper() {
        return this.codec.getHelperFactory().get();
    }

    @Override
    public void newClientSession(Session session, boolean transferring) {
        session.setFlag(MinecraftConstants.PROFILE_KEY, this.profile);
        session.setFlag(MinecraftConstants.ACCESS_TOKEN_KEY, this.accessToken);
        this.setState(ProtocolState.HANDSHAKE);
        if (this.useDefaultListeners) {
            session.addListener(new ClientListener(this.targetState, transferring));
        }
    }

    @Override
    public void newServerSession(Server server, Session session) {
        this.setState(ProtocolState.HANDSHAKE);
        if (this.useDefaultListeners) {
            if (DEFAULT_NETWORK_CODEC == null) {
                DEFAULT_NETWORK_CODEC = MinecraftProtocol.loadNetworkCodec();
            }
            session.addListener(new ServerListener(DEFAULT_NETWORK_CODEC));
        }
    }

    protected PacketEncryption enableEncryption(Key key) {
        try {
            return new AESEncryption(key);
        }
        catch (GeneralSecurityException e) {
            throw new Error("Failed to enable protocol encryption.", e);
        }
    }

    public ProtocolState getState() {
        return this.state;
    }

    public void setState(ProtocolState state) {
        this.state = state;
        this.stateCodec = this.codec.getCodec(state);
    }

    public Packet createClientboundPacket(int id, ByteBuf buf, PacketCodecHelper codecHelper) {
        return this.stateCodec.createClientboundPacket(id, buf, codecHelper);
    }

    @Override
    public int getClientboundId(Class<? extends Packet> packetClass) {
        return this.stateCodec.getClientboundId(packetClass);
    }

    @Override
    public int getClientboundId(Packet packet) {
        return this.stateCodec.getClientboundId(packet);
    }

    @Override
    public Class<? extends Packet> getClientboundClass(int id) {
        return this.stateCodec.getClientboundClass(id);
    }

    public Packet createServerboundPacket(int id, ByteBuf buf, PacketCodecHelper codecHelper) {
        return this.stateCodec.createServerboundPacket(id, buf, codecHelper);
    }

    @Override
    public int getServerboundId(Class<? extends Packet> packetClass) {
        return this.stateCodec.getServerboundId(packetClass);
    }

    @Override
    public int getServerboundId(Packet packet) {
        return this.stateCodec.getServerboundId(packet);
    }

    @Override
    public Class<? extends Packet> getServerboundClass(int id) {
        return this.stateCodec.getServerboundClass(id);
    }

    @Override
    public PacketDefinition<?, ?> getServerboundDefinition(int id) {
        return this.stateCodec.getServerboundDefinition(id);
    }

    @Override
    public PacketDefinition<?, ?> getClientboundDefinition(int id) {
        return this.stateCodec.getClientboundDefinition(id);
    }

    public static NbtMap loadNetworkCodec() {
        NbtMap nbtMap;
        block8: {
            InputStream inputStream = Objects.requireNonNull(MinecraftProtocol.class.getClassLoader().getResourceAsStream("networkCodec.nbt"));
            try {
                nbtMap = (NbtMap)NbtUtils.createGZIPReader(inputStream).readTag();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AssertionError("Unable to load network codec.", e);
                }
            }
            inputStream.close();
        }
        return nbtMap;
    }

    public PacketCodec getCodec() {
        return this.codec;
    }

    public GameProfile getProfile() {
        return this.profile;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public boolean isUseDefaultListeners() {
        return this.useDefaultListeners;
    }

    public void setUseDefaultListeners(boolean useDefaultListeners) {
        this.useDefaultListeners = useDefaultListeners;
    }
}

