/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game;

import java.util.function.Consumer;

public interface Holder<T> {
    public static <T> Holder<T> ofId(int id) {
        return new IdHolder(id);
    }

    public static <T> Holder<T> ofCustom(T object) {
        return new CustomHolder<T>(object);
    }

    public boolean isId();

    public int id();

    public boolean isCustom();

    public T custom();

    public Holder<T> ifId(Consumer<Holder<T>> var1);

    public Holder<T> ifCustom(Consumer<Holder<T>> var1);

    public record IdHolder<T>(int id) implements Holder<T>
    {
        @Override
        public boolean isId() {
            return true;
        }

        @Override
        public boolean isCustom() {
            return false;
        }

        @Override
        public T custom() {
            throw new IllegalStateException("Check isCustom first!");
        }

        @Override
        public Holder<T> ifId(Consumer<Holder<T>> action) {
            action.accept(this);
            return this;
        }

        @Override
        public Holder<T> ifCustom(Consumer<Holder<T>> action) {
            return this;
        }
    }

    public record CustomHolder<T>(T object) implements Holder<T>
    {
        @Override
        public boolean isId() {
            return false;
        }

        @Override
        public int id() {
            throw new IllegalStateException("Check isId first!");
        }

        @Override
        public boolean isCustom() {
            return true;
        }

        @Override
        public T custom() {
            return this.object;
        }

        @Override
        public Holder<T> ifId(Consumer<Holder<T>> action) {
            return this;
        }

        @Override
        public Holder<T> ifCustom(Consumer<Holder<T>> action) {
            action.accept(this);
            return this;
        }
    }
}

