/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.entity.player;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.GlobalPos;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;

public class PlayerSpawnInfo {
    private final int dimension;
    @lombok.NonNull
    private final String worldName;
    private final long hashedSeed;
    @lombok.NonNull
    private final GameMode gameMode;
    private final @Nullable GameMode previousGamemode;
    private final boolean debug;
    private final boolean flat;
    private final @Nullable GlobalPos lastDeathPos;
    private final int portalCooldown;

    public int getDimension() {
        return this.dimension;
    }

    @lombok.NonNull
    public String getWorldName() {
        return this.worldName;
    }

    public long getHashedSeed() {
        return this.hashedSeed;
    }

    @lombok.NonNull
    public GameMode getGameMode() {
        return this.gameMode;
    }

    public @Nullable GameMode getPreviousGamemode() {
        return this.previousGamemode;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public @Nullable GlobalPos getLastDeathPos() {
        return this.lastDeathPos;
    }

    public int getPortalCooldown() {
        return this.portalCooldown;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerSpawnInfo)) {
            return false;
        }
        PlayerSpawnInfo other = (PlayerSpawnInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDimension() != other.getDimension()) {
            return false;
        }
        if (this.getHashedSeed() != other.getHashedSeed()) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        if (this.isFlat() != other.isFlat()) {
            return false;
        }
        if (this.getPortalCooldown() != other.getPortalCooldown()) {
            return false;
        }
        String this$worldName = this.getWorldName();
        String other$worldName = other.getWorldName();
        if (this$worldName == null ? other$worldName != null : !this$worldName.equals(other$worldName)) {
            return false;
        }
        GameMode this$gameMode = this.getGameMode();
        GameMode other$gameMode = other.getGameMode();
        if (this$gameMode == null ? other$gameMode != null : !this$gameMode.equals(other$gameMode)) {
            return false;
        }
        GameMode this$previousGamemode = this.getPreviousGamemode();
        GameMode other$previousGamemode = other.getPreviousGamemode();
        if (this$previousGamemode == null ? other$previousGamemode != null : !this$previousGamemode.equals(other$previousGamemode)) {
            return false;
        }
        GlobalPos this$lastDeathPos = this.getLastDeathPos();
        GlobalPos other$lastDeathPos = other.getLastDeathPos();
        return !(this$lastDeathPos == null ? other$lastDeathPos != null : !this$lastDeathPos.equals(other$lastDeathPos));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof PlayerSpawnInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDimension();
        long $hashedSeed = this.getHashedSeed();
        result = result * 59 + (int)($hashedSeed >>> 32 ^ $hashedSeed);
        result = result * 59 + (this.isDebug() ? 79 : 97);
        result = result * 59 + (this.isFlat() ? 79 : 97);
        result = result * 59 + this.getPortalCooldown();
        String $worldName = this.getWorldName();
        result = result * 59 + ($worldName == null ? 43 : $worldName.hashCode());
        GameMode $gameMode = this.getGameMode();
        result = result * 59 + ($gameMode == null ? 43 : $gameMode.hashCode());
        GameMode $previousGamemode = this.getPreviousGamemode();
        result = result * 59 + ($previousGamemode == null ? 43 : $previousGamemode.hashCode());
        GlobalPos $lastDeathPos = this.getLastDeathPos();
        result = result * 59 + ($lastDeathPos == null ? 43 : $lastDeathPos.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "PlayerSpawnInfo(dimension=" + this.getDimension() + ", worldName=" + this.getWorldName() + ", hashedSeed=" + this.getHashedSeed() + ", gameMode=" + this.getGameMode() + ", previousGamemode=" + this.getPreviousGamemode() + ", debug=" + this.isDebug() + ", flat=" + this.isFlat() + ", lastDeathPos=" + this.getLastDeathPos() + ", portalCooldown=" + this.getPortalCooldown() + ")";
    }

    public PlayerSpawnInfo(int dimension, @lombok.NonNull String worldName, long hashedSeed, @lombok.NonNull GameMode gameMode, @Nullable GameMode previousGamemode, boolean debug, boolean flat, @Nullable GlobalPos lastDeathPos, int portalCooldown) {
        if (worldName == null) {
            throw new NullPointerException("worldName is marked non-null but is null");
        }
        if (gameMode == null) {
            throw new NullPointerException("gameMode is marked non-null but is null");
        }
        this.dimension = dimension;
        this.worldName = worldName;
        this.hashedSeed = hashedSeed;
        this.gameMode = gameMode;
        this.previousGamemode = previousGamemode;
        this.debug = debug;
        this.flat = flat;
        this.lastDeathPos = lastDeathPos;
        this.portalCooldown = portalCooldown;
    }
}

