/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import java.util.List;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.ModifierOperation;

public class ItemAttributeModifiers {
    private final List<Entry> modifiers;
    private final boolean showInTooltip;

    public List<Entry> getModifiers() {
        return this.modifiers;
    }

    public boolean isShowInTooltip() {
        return this.showInTooltip;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemAttributeModifiers)) {
            return false;
        }
        ItemAttributeModifiers other = (ItemAttributeModifiers)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isShowInTooltip() != other.isShowInTooltip()) {
            return false;
        }
        List<Entry> this$modifiers = this.getModifiers();
        List<Entry> other$modifiers = other.getModifiers();
        return !(this$modifiers == null ? other$modifiers != null : !((Object)this$modifiers).equals(other$modifiers));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ItemAttributeModifiers;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isShowInTooltip() ? 79 : 97);
        List<Entry> $modifiers = this.getModifiers();
        result = result * 59 + ($modifiers == null ? 43 : ((Object)$modifiers).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ItemAttributeModifiers(modifiers=" + this.getModifiers() + ", showInTooltip=" + this.isShowInTooltip() + ")";
    }

    public ItemAttributeModifiers(List<Entry> modifiers, boolean showInTooltip) {
        this.modifiers = modifiers;
        this.showInTooltip = showInTooltip;
    }

    public static enum EquipmentSlotGroup {
        ANY,
        MAIN_HAND,
        OFF_HAND,
        HAND,
        FEET,
        LEGS,
        CHEST,
        HEAD,
        ARMOR,
        BODY;

        private static final EquipmentSlotGroup[] VALUES;

        public static EquipmentSlotGroup from(int id) {
            return VALUES[id];
        }

        static {
            VALUES = EquipmentSlotGroup.values();
        }
    }

    public static class AttributeModifier {
        private final UUID id;
        private final String name;
        private final double amount;
        private final ModifierOperation operation;

        public UUID getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public double getAmount() {
            return this.amount;
        }

        public ModifierOperation getOperation() {
            return this.operation;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AttributeModifier)) {
                return false;
            }
            AttributeModifier other = (AttributeModifier)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getAmount(), other.getAmount()) != 0) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            ModifierOperation this$operation = this.getOperation();
            ModifierOperation other$operation = other.getOperation();
            return !(this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof AttributeModifier;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $amount = Double.doubleToLongBits(this.getAmount());
            result = result * 59 + (int)($amount >>> 32 ^ $amount);
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            ModifierOperation $operation = this.getOperation();
            result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
            return result;
        }

        public @NonNull String toString() {
            return "ItemAttributeModifiers.AttributeModifier(id=" + this.getId() + ", name=" + this.getName() + ", amount=" + this.getAmount() + ", operation=" + this.getOperation() + ")";
        }

        public AttributeModifier(UUID id, String name, double amount, ModifierOperation operation) {
            this.id = id;
            this.name = name;
            this.amount = amount;
            this.operation = operation;
        }
    }

    public static class Entry {
        private final int attribute;
        private final AttributeModifier modifier;
        private final EquipmentSlotGroup slot;

        public int getAttribute() {
            return this.attribute;
        }

        public AttributeModifier getModifier() {
            return this.modifier;
        }

        public EquipmentSlotGroup getSlot() {
            return this.slot;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAttribute() != other.getAttribute()) {
                return false;
            }
            AttributeModifier this$modifier = this.getModifier();
            AttributeModifier other$modifier = other.getModifier();
            if (this$modifier == null ? other$modifier != null : !((Object)this$modifier).equals(other$modifier)) {
                return false;
            }
            EquipmentSlotGroup this$slot = this.getSlot();
            EquipmentSlotGroup other$slot = other.getSlot();
            return !(this$slot == null ? other$slot != null : !((Object)((Object)this$slot)).equals((Object)other$slot));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Entry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAttribute();
            AttributeModifier $modifier = this.getModifier();
            result = result * 59 + ($modifier == null ? 43 : ((Object)$modifier).hashCode());
            EquipmentSlotGroup $slot = this.getSlot();
            result = result * 59 + ($slot == null ? 43 : ((Object)((Object)$slot)).hashCode());
            return result;
        }

        public @NonNull String toString() {
            return "ItemAttributeModifiers.Entry(attribute=" + this.getAttribute() + ", modifier=" + this.getModifier() + ", slot=" + this.getSlot() + ")";
        }

        public Entry(int attribute, AttributeModifier modifier, EquipmentSlotGroup slot) {
            this.attribute = attribute;
            this.modifier = modifier;
            this.slot = slot;
        }
    }
}

