/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.configuration.clientbound;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundUpdateEnabledFeaturesPacket
implements MinecraftPacket {
    private final String[] features;

    public ClientboundUpdateEnabledFeaturesPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.features = new String[helper.readVarInt(in)];
        for (int i = 0; i < this.features.length; ++i) {
            this.features[i] = helper.readString(in);
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.features.length);
        for (String feature : this.features) {
            helper.writeString(out, feature);
        }
    }

    public String[] getFeatures() {
        return this.features;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundUpdateEnabledFeaturesPacket)) {
            return false;
        }
        ClientboundUpdateEnabledFeaturesPacket other = (ClientboundUpdateEnabledFeaturesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getFeatures(), other.getFeatures());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundUpdateEnabledFeaturesPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getFeatures());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundUpdateEnabledFeaturesPacket(features=" + Arrays.deepToString(this.getFeatures()) + ")";
    }

    public @NonNull ClientboundUpdateEnabledFeaturesPacket withFeatures(String[] features) {
        return this.features == features ? this : new ClientboundUpdateEnabledFeaturesPacket(features);
    }

    public ClientboundUpdateEnabledFeaturesPacket(String[] features) {
        this.features = features;
    }
}

