/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.status.clientbound;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundPongResponsePacket
implements MinecraftPacket {
    private final long pingTime;

    public ClientboundPongResponsePacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.pingTime = in.readLong();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeLong(this.pingTime);
    }

    public long getPingTime() {
        return this.pingTime;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundPongResponsePacket)) {
            return false;
        }
        ClientboundPongResponsePacket other = (ClientboundPongResponsePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getPingTime() == other.getPingTime();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundPongResponsePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $pingTime = this.getPingTime();
        result = result * 59 + (int)($pingTime >>> 32 ^ $pingTime);
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundPongResponsePacket(pingTime=" + this.getPingTime() + ")";
    }

    public @NonNull ClientboundPongResponsePacket withPingTime(long pingTime) {
        return this.pingTime == pingTime ? this : new ClientboundPongResponsePacket(pingTime);
    }

    public ClientboundPongResponsePacket(long pingTime) {
        this.pingTime = pingTime;
    }
}

