/*
 * Decompiled with CFR 0.152.
 */
package studio.trc.bukkit.globalmarketplus.merchandise;

import com.pa_project.lib.json.JSONObject;
import studio.trc.bukkit.globalmarketplus.merchandise.MerchandiseParameter;

public class MerchandiseOption {
    private final long merchandiseUID;
    private boolean hiddenMerchantName;
    private boolean hiddenMerchandise;
    private boolean unlimited;
    private boolean neverExpire;

    public MerchandiseOption(long l2) {
        this.merchandiseUID = l2;
        this.hiddenMerchantName = MerchandiseParameter.HIDDEN_MERCHANT_NAME.getBooleanValue();
        this.hiddenMerchandise = MerchandiseParameter.HIDDEN_MERCHANDISE.getBooleanValue();
        this.unlimited = MerchandiseParameter.UNLIMITED.getBooleanValue();
        this.neverExpire = MerchandiseParameter.NEVER_EXPIRE.getBooleanValue();
    }

    public void setOptionValue(MerchandiseParameter merchandiseParameter, Object object) {
        switch (merchandiseParameter) {
            case HIDDEN_MERCHANDISE: {
                this.hiddenMerchandise = Boolean.valueOf(object.toString());
                break;
            }
            case HIDDEN_MERCHANT_NAME: {
                this.hiddenMerchantName = Boolean.valueOf(object.toString());
                break;
            }
            case UNLIMITED: {
                this.unlimited = Boolean.valueOf(object.toString());
                break;
            }
            case NEVER_EXPIRE: {
                this.neverExpire = Boolean.valueOf(object.toString());
            }
        }
    }

    public Object getOptionValue(MerchandiseParameter merchandiseParameter) {
        switch (merchandiseParameter) {
            case HIDDEN_MERCHANDISE: {
                return this.hiddenMerchandise;
            }
            case HIDDEN_MERCHANT_NAME: {
                return this.hiddenMerchantName;
            }
            case UNLIMITED: {
                return this.unlimited;
            }
            case NEVER_EXPIRE: {
                return this.neverExpire;
            }
        }
        return false;
    }

    public JSONObject serialize() {
        return MerchandiseOption.serialize(this);
    }

    public String toString() {
        return this.serialize().toJSONString();
    }

    public static JSONObject serialize(MerchandiseOption merchandiseOption) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("MerchandiseUID", merchandiseOption.merchandiseUID);
        if (merchandiseOption.hiddenMerchandise != MerchandiseParameter.HIDDEN_MERCHANDISE.getBooleanValue()) {
            jSONObject.put("HiddenMerchandise", merchandiseOption.isHiddenMerchandise());
        }
        if (merchandiseOption.hiddenMerchantName != MerchandiseParameter.HIDDEN_MERCHANT_NAME.getBooleanValue()) {
            jSONObject.put("HiddenMerchantName", merchandiseOption.isHiddenMerchantName());
        }
        if (merchandiseOption.unlimited != MerchandiseParameter.UNLIMITED.getBooleanValue()) {
            jSONObject.put("Unlimited", merchandiseOption.isUnlimited());
        }
        if (merchandiseOption.neverExpire != MerchandiseParameter.NEVER_EXPIRE.getBooleanValue()) {
            jSONObject.put("NeverExpire", merchandiseOption.isNeverExpire());
        }
        return jSONObject;
    }

    public static MerchandiseOption deserialize(JSONObject jSONObject) {
        MerchandiseOption merchandiseOption = new MerchandiseOption(jSONObject.getLong("MerchandiseUID"));
        if (jSONObject.containsKey("HiddenMerchandise")) {
            merchandiseOption.setHiddenMerchandise(jSONObject.getBoolean("HiddenMerchandise"));
        }
        if (jSONObject.containsKey("HiddenMerchantName")) {
            merchandiseOption.setHiddenMerchantName(jSONObject.getBoolean("HiddenMerchantName"));
        }
        if (jSONObject.containsKey("Unlimited")) {
            merchandiseOption.setUnlimited(jSONObject.getBoolean("Unlimited"));
        }
        if (jSONObject.containsKey("NeverExpire")) {
            merchandiseOption.setNeverExpire(jSONObject.getBoolean("NeverExpire"));
        }
        return merchandiseOption;
    }

    public long getMerchandiseUID() {
        return this.merchandiseUID;
    }

    public boolean isHiddenMerchantName() {
        return this.hiddenMerchantName;
    }

    public void setHiddenMerchantName(boolean bl) {
        this.hiddenMerchantName = bl;
    }

    public boolean isHiddenMerchandise() {
        return this.hiddenMerchandise;
    }

    public void setHiddenMerchandise(boolean bl) {
        this.hiddenMerchandise = bl;
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    public void setUnlimited(boolean bl) {
        this.unlimited = bl;
    }

    public boolean isNeverExpire() {
        return this.neverExpire;
    }

    public void setNeverExpire(boolean bl) {
        this.neverExpire = bl;
    }
}

