/*
 * Decompiled with CFR 0.152.
 */
package studio.trc.bukkit.globalmarketplus.merchant;

import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import studio.trc.bukkit.globalmarketplus.api.Merchant;
import studio.trc.bukkit.globalmarketplus.b.a;
import studio.trc.bukkit.globalmarketplus.b.b;
import studio.trc.bukkit.globalmarketplus.n.c;
import studio.trc.bukkit.globalmarketplus.n.d;

public class MerchantGroup {
    private static final Map cacheGroups = new LinkedHashMap();
    private final String groupName;
    private final boolean defaultGroups;
    private final String permission;
    private final int maximumOfMerchandises_Selling;
    private final int maximumOfMerchandises_Purchasing;
    private final int maximumOfMerchandises_Bidding;
    private final double taxRate_Selling;
    private final double taxRate_Purchasing;
    private final double taxRate_Bidding;
    private final double lowestPrice_Selling;
    private final double lowestPrice_Purchasing;
    private final double lowestPrice_Bidding;
    private final double highestPrice_Selling;
    private final double highestPrice_Purchasing;
    private final double highestPrice_Bidding;
    private final String expirationDate_Mail;
    private final String expirationDate_Selling;
    private final String expirationDate_Purchasing;
    private final String expirationDate_Bidding;

    public MerchantGroup(String string, boolean bl, String string2, int n2, int n3, int n4, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, String string3, String string4, String string5, String string6) {
        this.groupName = string;
        this.defaultGroups = bl;
        this.permission = string2;
        this.maximumOfMerchandises_Selling = n2 >= 0 ? n2 : 0;
        this.maximumOfMerchandises_Purchasing = n3 >= 0 ? n3 : 0;
        this.maximumOfMerchandises_Bidding = n4 >= 0 ? n4 : 0;
        this.taxRate_Selling = d2 >= 0.0 ? d2 : 0.0;
        this.taxRate_Purchasing = d3 >= 0.0 ? d3 : 0.0;
        this.taxRate_Bidding = d4 >= 0.0 ? d4 : 0.0;
        this.lowestPrice_Selling = d5 >= 0.0 ? d5 : 0.0;
        this.lowestPrice_Purchasing = d6 >= 0.0 ? d6 : 0.0;
        this.lowestPrice_Bidding = d7 >= 0.0 ? d7 : 0.0;
        this.highestPrice_Selling = d8 >= 0.0 ? d8 : 0.0;
        this.highestPrice_Purchasing = d9 >= 0.0 ? d9 : 0.0;
        this.highestPrice_Bidding = d10 >= 0.0 ? d10 : 0.0;
        this.expirationDate_Mail = string3;
        this.expirationDate_Selling = string4;
        this.expirationDate_Purchasing = string5;
        this.expirationDate_Bidding = string6;
    }

    public long getExpirationTimeOfSelling() {
        return d.a(this.expirationDate_Selling);
    }

    public long getExpirationTimeOfPurchasing() {
        return d.a(this.expirationDate_Purchasing);
    }

    public long getExpirationTimeOfBidding() {
        return d.a(this.expirationDate_Bidding);
    }

    public long getExpirationTimeOfMail() {
        return d.a(this.expirationDate_Mail);
    }

    public static Map reloadMerchantGroups() {
        cacheGroups.clear();
        a a2 = b.GROUPS.getProtectedConfig();
        a2.i("Priority").stream().filter(string -> a2.b("Groups." + string) != null).forEach(string -> {
            try {
                ConfigurationSection configurationSection = a2.l("Groups." + string);
                cacheGroups.put(string, new MerchantGroup((String)string, configurationSection.getBoolean("Default"), configurationSection.getString("Permission"), configurationSection.getInt("Maximum-Of-Merchandises:Selling", Integer.MAX_VALUE), configurationSection.getInt("Maximum-Of-Merchandises:Purchasing", Integer.MAX_VALUE), configurationSection.getInt("Maximum-Of-Merchandises:Bidding", Integer.MAX_VALUE), configurationSection.getDouble("Tax-Rate:Selling", 0.0), configurationSection.getDouble("Tax-Rate:Purchasing", 0.0), configurationSection.getDouble("Tax-Rate:Bidding", 0.0), configurationSection.getDouble("Lowest-Price:Selling", 0.0), configurationSection.getDouble("Lowest-Price:Purchasing", 0.0), configurationSection.getDouble("Lowest-Price:Bidding", 0.0), configurationSection.getDouble("Highest-Price:Selling", Double.MAX_VALUE), configurationSection.getDouble("Highest-Price:Purchasing", Double.MAX_VALUE), configurationSection.getDouble("Highest-Price:Bidding", Double.MAX_VALUE), configurationSection.getString("Expiration-Date:Mail", null), configurationSection.getString("Expiration-Date:Selling", null), configurationSection.getString("Expiration-Date:Purchasing", null), configurationSection.getString("Expiration-Date:Bidding", null)));
            }
            catch (Exception exception) {
                Map map = studio.trc.bukkit.globalmarketplus.g.c.e();
                map.put("{exception}", exception.getLocalizedMessage() != null ? exception.getLocalizedMessage() : "null");
                c.a("LoadingGroupFailed", map);
            }
        });
        Map map = studio.trc.bukkit.globalmarketplus.g.c.e();
        map.put("{groupAmount}", String.valueOf(cacheGroups.size()));
        return map;
    }

    public static MerchantGroup getGroup(String string) {
        return (MerchantGroup)cacheGroups.get(string);
    }

    public static MerchantGroup getDefaultGroup() {
        return cacheGroups.values().stream().filter(merchantGroup -> merchantGroup.defaultGroups).findFirst().orElse(null);
    }

    public static MerchantGroup getMerchantGroup(Merchant merchant) {
        Player player = merchant.getPlayer();
        if (player == null) {
            MerchantGroup merchantGroup2 = MerchantGroup.getGroup(merchant.getProfile().getGroupName());
            return merchantGroup2 != null ? merchantGroup2 : MerchantGroup.getDefaultGroup();
        }
        return cacheGroups.values().stream().filter(merchantGroup -> merchantGroup.defaultGroups || player.hasPermission(merchantGroup.getPermission())).findFirst().orElse(MerchantGroup.getDefaultGroup());
    }

    public static Map getCacheGroups() {
        return cacheGroups;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean isDefaultGroups() {
        return this.defaultGroups;
    }

    public String getPermission() {
        return this.permission;
    }

    public int getMaximumOfMerchandises_Selling() {
        return this.maximumOfMerchandises_Selling;
    }

    public int getMaximumOfMerchandises_Purchasing() {
        return this.maximumOfMerchandises_Purchasing;
    }

    public int getMaximumOfMerchandises_Bidding() {
        return this.maximumOfMerchandises_Bidding;
    }

    public double getTaxRate_Selling() {
        return this.taxRate_Selling;
    }

    public double getTaxRate_Purchasing() {
        return this.taxRate_Purchasing;
    }

    public double getTaxRate_Bidding() {
        return this.taxRate_Bidding;
    }

    public double getLowestPrice_Selling() {
        return this.lowestPrice_Selling;
    }

    public double getLowestPrice_Purchasing() {
        return this.lowestPrice_Purchasing;
    }

    public double getLowestPrice_Bidding() {
        return this.lowestPrice_Bidding;
    }

    public double getHighestPrice_Selling() {
        return this.highestPrice_Selling;
    }

    public double getHighestPrice_Purchasing() {
        return this.highestPrice_Purchasing;
    }

    public double getHighestPrice_Bidding() {
        return this.highestPrice_Bidding;
    }

    public String getExpirationDate_Mail() {
        return this.expirationDate_Mail;
    }

    public String getExpirationDate_Selling() {
        return this.expirationDate_Selling;
    }

    public String getExpirationDate_Purchasing() {
        return this.expirationDate_Purchasing;
    }

    public String getExpirationDate_Bidding() {
        return this.expirationDate_Bidding;
    }
}

