/*
 * Decompiled with CFR 0.152.
 */
package studio.trc.bukkit.globalmarketplus.merchant;

import com.pa_project.lib.json.JSONArray;
import com.pa_project.lib.json.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import studio.trc.bukkit.globalmarketplus.Main;
import studio.trc.bukkit.globalmarketplus.api.GlobalMarket;
import studio.trc.bukkit.globalmarketplus.api.Merchant;
import studio.trc.bukkit.globalmarketplus.api.event.ProcessMerchantNoticesEvent;
import studio.trc.bukkit.globalmarketplus.api.event.ProcessMerchantTasksEvent;
import studio.trc.bukkit.globalmarketplus.f.a;
import studio.trc.bukkit.globalmarketplus.m.b;
import studio.trc.bukkit.globalmarketplus.mailbox.ItemMail;
import studio.trc.bukkit.globalmarketplus.mailbox.ItemMailSort;
import studio.trc.bukkit.globalmarketplus.merchandise.MerchandiseSort;
import studio.trc.bukkit.globalmarketplus.merchant.MerchantParameter;
import studio.trc.bukkit.globalmarketplus.n.c;
import studio.trc.bukkit.globalmarketplus.n.d;
import studio.trc.bukkit.globalmarketplus.n.f;

public final class MerchantProfile {
    private final UUID ownerUUID;
    private final Merchant merchant;
    private boolean hiddenMerchantName = false;
    private boolean hiddenMerchandises = false;
    private boolean mailboxLocked = false;
    private b category = null;
    private MerchandiseSort merchandiseSort = null;
    private ItemMailSort itemMailSort = null;
    private ItemStack head = null;
    private String groupName = null;
    private final JSONArray notices = new JSONArray();
    private final JSONArray tasks = new JSONArray();

    public MerchantProfile(UUID uUID, Merchant merchant, boolean bl) {
        this.ownerUUID = uUID;
        this.merchant = merchant;
        if (bl) {
            this.head = d.p();
            this.mailboxLocked = MerchantParameter.MAILBOX_LOCKED.getBoolean();
            this.hiddenMerchantName = MerchantParameter.HIDDEN_MERCHANT_NAME.getBoolean();
            this.hiddenMerchandises = MerchantParameter.HIDDEN_MERCHANDISES.getBoolean();
        }
    }

    public void setOptionValue(MerchantParameter merchantParameter, Object object, boolean bl) {
        switch (merchantParameter) {
            case HIDDEN_MERCHANDISES: {
                boolean bl2 = Boolean.valueOf(object.toString());
                if (bl) {
                    GlobalMarket globalMarket = GlobalMarket.getGlobalMarket();
                    d.a(globalMarket, true);
                    globalMarket.getMerchandises().stream().filter(merchandise -> merchandise.getOwnerUUID().equals(this.ownerUUID)).forEach(merchandise -> {
                        merchandise.getMerchandiseOption().setHiddenMerchandise(bl2);
                        if (!globalMarket.saveMerchandise(merchandise.getMerchandiseUID(), UUID.randomUUID().toString())) {
                            globalMarket.reloadMarket();
                        }
                    });
                }
                this.hiddenMerchandises = bl2;
                break;
            }
            case HIDDEN_MERCHANT_NAME: {
                boolean bl3 = Boolean.valueOf(object.toString());
                if (bl) {
                    GlobalMarket globalMarket = GlobalMarket.getGlobalMarket();
                    d.a(globalMarket, true);
                    globalMarket.getMerchandises().stream().filter(merchandise -> merchandise.getOwnerUUID().equals(this.ownerUUID)).forEach(merchandise -> {
                        merchandise.getMerchandiseOption().setHiddenMerchantName(bl3);
                        if (!globalMarket.saveMerchandise(merchandise.getMerchandiseUID(), UUID.randomUUID().toString())) {
                            globalMarket.reloadMarket();
                        }
                    });
                }
                this.hiddenMerchantName = bl3;
                break;
            }
            case MAILBOX_LOCKED: {
                this.mailboxLocked = Boolean.valueOf(object.toString());
                break;
            }
            case MERCHANDISE_SORT: {
                this.merchandiseSort = MerchandiseSort.getSort(object.toString());
            }
            case ITEM_MAIL_SORT: {
                this.itemMailSort = ItemMailSort.getSort(object.toString());
            }
        }
    }

    public void executeTasks(boolean bl) {
        Bukkit.getScheduler().runTask((Plugin)Main.b(), () -> {
            Event event;
            boolean bl2 = false;
            if (studio.trc.bukkit.globalmarketplus.b.b.MERCHANT.getProtectedConfig().g("Automatic-Processing-of-Offline-Tasks.Notices") || !bl) {
                event = new ProcessMerchantNoticesEvent(this.merchant);
                Bukkit.getPluginManager().callEvent(event);
                if (!event.isCancelled() && !this.notices.isEmpty() && this.merchant.getPlayer() != null) {
                    this.notices.stream().forEach(jSONObject -> {
                        try {
                            switch (jSONObject.getString("Type")) {
                                case "NewMail": {
                                    d.a(this.ownerUUID, ItemMail.deserialize(jSONObject.getJSONObject("ItemMail")));
                                    break;
                                }
                                case "DepositRefund-Retail": {
                                    d.b(this.ownerUUID, d.l(jSONObject.getString("ItemStack")), jSONObject.getDouble("BackMoney"));
                                    break;
                                }
                                case "DepositRefund-Wholesale": {
                                    d.a(this.ownerUUID, d.l(jSONObject.getString("ItemStack")), (double)jSONObject.getDouble("BackRetailMoney"));
                                    break;
                                }
                                case "MailExpired": {
                                    d.b(this.ownerUUID, ItemMail.deserialize(jSONObject.getJSONObject("ItemMail")));
                                    break;
                                }
                                case "BiddingOverride_Merchant": {
                                    d.a(this.ownerUUID, jSONObject.getLong("UID"), jSONObject.getString("TopBidder"), jSONObject.getDouble("Price"), jSONObject.getDouble("BiddingPrice"), d.l(jSONObject.getString("ItemStack")));
                                    break;
                                }
                                case "BiddingOverride_OriginalBidder": {
                                    d.b(this.ownerUUID, jSONObject.getLong("UID"), jSONObject.getString("TopBidder"), jSONObject.getDouble("Price"), jSONObject.getDouble("BiddingPrice"), d.l(jSONObject.getString("ItemStack")));
                                    break;
                                }
                                case "AuctionConfirm_Merchant": {
                                    d.a(this.ownerUUID, d.l(jSONObject.getString("ItemStack")), jSONObject.getString("TopBidder"), (double)jSONObject.getDouble("Price"), (double)jSONObject.getDouble("Taxed"));
                                    break;
                                }
                                case "AuctionConfirm_TopBidder": {
                                    d.b(this.ownerUUID, d.l(jSONObject.getString("ItemStack")), jSONObject.getString("TopBidder"), jSONObject.getDouble("Price"), jSONObject.getDouble("Taxed"));
                                    break;
                                }
                                case "AuctionConfirm_Participants": {
                                    d.c(this.ownerUUID, d.l(jSONObject.getString("ItemStack")), jSONObject.getString("TopBidder"), jSONObject.getDouble("Price"), jSONObject.getDouble("Taxed"));
                                    break;
                                }
                                case "MerchandiseExpired_Selling": {
                                    d.c(this.ownerUUID, ItemMail.deserialize(jSONObject.getJSONObject("ItemMail")));
                                    break;
                                }
                                case "MerchandiseExpired_Purchasing": {
                                    d.a(this.ownerUUID, d.l(jSONObject.getString("ItemStack")), (double)jSONObject.getDouble("BackMoney"), (double)jSONObject.getDouble("BackRetailMoney"));
                                    break;
                                }
                                case "MerchandiseExpired_Bidding": {
                                    d.d(this.ownerUUID, ItemMail.deserialize(jSONObject.getJSONObject("ItemMail")));
                                    break;
                                }
                                case "MerchandiseTransactionNormal_Selling": {
                                    d.a(jSONObject.getString("Trader"), this.ownerUUID, d.l(jSONObject.getString("ItemStack")), (double)jSONObject.getDouble("Money"));
                                    break;
                                }
                                case "MerchandiseTransactionNormal_Purchasing": {
                                    d.a(jSONObject.getString("Trader"), this.ownerUUID, ItemMail.deserialize(jSONObject.getJSONObject("ItemMail")), (double)jSONObject.getDouble("Money"));
                                    break;
                                }
                                case "MerchandiseTransactionRetail_Selling": {
                                    d.a(jSONObject.getString("Trader"), this.ownerUUID, d.l(jSONObject.getString("ItemStack")), (double)jSONObject.getDouble("Money"), jSONObject.getInt("Amount"));
                                    break;
                                }
                                case "MerchandiseTransactionRetail_Purchasing": {
                                    d.a(jSONObject.getString("Trader"), this.ownerUUID, ItemMail.deserialize(jSONObject.getJSONObject("ItemMail")), (double)jSONObject.getDouble("Money"), jSONObject.getInt("Amount"));
                                    break;
                                }
                                case "MerchandiseRemoved_Selling": {
                                    d.a(jSONObject.getString("OperatorName"), this.ownerUUID, ItemMail.deserialize(jSONObject.getJSONObject("ItemMail")));
                                    break;
                                }
                                case "MerchandiseRemoved_Purchasing": {
                                    d.a(jSONObject.getString("OperatorName"), this.ownerUUID, d.l(jSONObject.getString("ItemStack")), (double)jSONObject.getDouble("BackMoney"), (double)jSONObject.getDouble("BackRetailMoney"));
                                    break;
                                }
                                case "MerchandiseRemoved_Bidding": {
                                    d.b(jSONObject.getString("OperatorName"), this.ownerUUID, ItemMail.deserialize(jSONObject.getJSONObject("ItemMail")));
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    });
                    this.notices.clear();
                    bl2 = true;
                }
            }
            if (studio.trc.bukkit.globalmarketplus.b.b.MERCHANT.getProtectedConfig().g("Automatic-Processing-of-Offline-Tasks.Change-Balance") || !bl) {
                event = new ProcessMerchantTasksEvent(this.merchant);
                Bukkit.getPluginManager().callEvent(event);
                if (!event.isCancelled() && !this.tasks.isEmpty() && this.merchant.getPlayer() != null) {
                    HashMap hashMap = new HashMap();
                    new ArrayList(this.tasks).stream().forEach(jSONObject -> {
                        try {
                            switch (jSONObject.getString("Type")) {
                                case "AddBalance": {
                                    a a2;
                                    a a3 = a2 = a.useMultipleCurrency() ? a.valueOf(jSONObject.getString("Currency")) : a.getSystemCurrency();
                                    if (this.merchant.setBalance(a2, this.merchant.getBalance(a2) + jSONObject.getDouble("Amount"))) {
                                        if (!bl) {
                                            if (hashMap.get((Object)a2) != null) {
                                                hashMap.put(a2, (Double)hashMap.get((Object)a2) + jSONObject.getDouble("Amount"));
                                            } else {
                                                hashMap.put(a2, jSONObject.getDouble("Amount"));
                                            }
                                        }
                                        this.tasks.remove(jSONObject);
                                        break;
                                    }
                                    Map map2 = studio.trc.bukkit.globalmarketplus.g.c.e();
                                    map2.put("{player}", this.merchant.getPlayerName());
                                    c.a("SetBalanceFailed", map2);
                                    break;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    });
                    hashMap.keySet().stream().forEach(a2 -> {
                        Map map2 = studio.trc.bukkit.globalmarketplus.g.c.e();
                        map2.put("{currency}", d.a(a2));
                        map2.put("{balance}", String.valueOf(this.merchant.getBalance((a)((Object)((Object)a2)))));
                        map2.put("{changed}", "+" + hashMap.get(a2));
                        studio.trc.bukkit.globalmarketplus.g.c.b((CommandSender)this.merchant.getPlayer(), "Profile.Tasks.Balance-Information", map2);
                    });
                    bl2 = true;
                }
            }
            if (bl2) {
                this.merchant.saveData(UUID.randomUUID().toString());
            }
        });
    }

    public Object getOptionValue(MerchantParameter merchantParameter) {
        switch (merchantParameter) {
            case HIDDEN_MERCHANDISES: {
                return this.hiddenMerchandises;
            }
            case HIDDEN_MERCHANT_NAME: {
                return this.hiddenMerchantName;
            }
            case MERCHANDISE_SORT: {
                return this.merchandiseSort;
            }
            case ITEM_MAIL_SORT: {
                return this.itemMailSort;
            }
            case MAILBOX_LOCKED: {
                return this.mailboxLocked;
            }
        }
        return null;
    }

    public b getCategory() {
        return this.category != null ? this.category : b.a();
    }

    public MerchandiseSort getMerchandiseSort() {
        if (this.merchandiseSort != null) {
            return this.merchandiseSort;
        }
        MerchandiseSort merchandiseSort = MerchandiseSort.getDefaultSort();
        if (merchandiseSort != null) {
            return merchandiseSort;
        }
        c.a("InvalidMerchandiseSort", studio.trc.bukkit.globalmarketplus.g.c.e());
        return MerchandiseSort.ACCORDING_TO_UPLOAD_TIME;
    }

    public ItemMailSort getItemMailSort() {
        if (this.itemMailSort != null) {
            return this.itemMailSort;
        }
        ItemMailSort itemMailSort = ItemMailSort.getDefaultSort();
        if (itemMailSort != null) {
            return itemMailSort;
        }
        c.a("InvalidItemMailSort", studio.trc.bukkit.globalmarketplus.g.c.e());
        return ItemMailSort.ACCORDING_TO_THE_STATE;
    }

    public MerchantProfile refreshHead() {
        if (f.a == null || f.a.startsWith("v1_7") || this.head == null) {
            return this;
        }
        try {
            SkullMeta skullMeta = (SkullMeta)this.head.getItemMeta();
            if (!(f.a.startsWith("v1_8") || f.a.startsWith("v1_9") || f.a.startsWith("v1_10") || f.a.startsWith("v1_11"))) {
                skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)this.ownerUUID));
            } else {
                skullMeta.setOwner(Bukkit.getOfflinePlayer((UUID)this.ownerUUID).getName());
            }
            this.head.setItemMeta((ItemMeta)skullMeta);
        }
        catch (Exception exception) {
            Map map = studio.trc.bukkit.globalmarketplus.g.c.e();
            map.put("{exception}", exception.getLocalizedMessage() != null ? exception.getLocalizedMessage() : "null");
            c.a("GetPlayerHeadFailed", map);
        }
        return this;
    }

    public JSONObject serialize() {
        return MerchantProfile.serialize(this);
    }

    public static JSONObject serialize(MerchantProfile merchantProfile) {
        String string;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("OwnerUUID", merchantProfile.getOwnerUUID().toString());
        if (merchantProfile.head != null && (string = d.a(merchantProfile.head)) != null) {
            jSONObject.put("Head", string);
        }
        if (merchantProfile.groupName != null) {
            jSONObject.put("GroupName", merchantProfile.groupName);
        }
        if (merchantProfile.category != null) {
            jSONObject.put("Category", merchantProfile.category.d());
        }
        if (merchantProfile.merchandiseSort != null) {
            jSONObject.put("MerchandiseSort", merchantProfile.merchandiseSort.getName());
        }
        if (merchantProfile.itemMailSort != null) {
            jSONObject.put("ItemMailSort", merchantProfile.itemMailSort.getName());
        }
        if (merchantProfile.mailboxLocked != MerchantParameter.MAILBOX_LOCKED.getBoolean()) {
            jSONObject.put("MailboxLocked", merchantProfile.mailboxLocked);
        }
        if (merchantProfile.hiddenMerchantName != MerchantParameter.HIDDEN_MERCHANT_NAME.getBoolean()) {
            jSONObject.put("HiddenMerchantName", merchantProfile.hiddenMerchantName);
        }
        if (merchantProfile.hiddenMerchandises != MerchantParameter.HIDDEN_MERCHANDISES.getBoolean()) {
            jSONObject.put("HiddenMerchandises", merchantProfile.hiddenMerchandises);
        }
        if (!merchantProfile.notices.isEmpty()) {
            jSONObject.put("Notices", merchantProfile.notices);
        }
        if (!merchantProfile.tasks.isEmpty()) {
            jSONObject.put("Tasks", merchantProfile.tasks);
        }
        return jSONObject;
    }

    public static MerchantProfile deserialize(JSONObject jSONObject, Merchant merchant) {
        MerchantProfile merchantProfile = new MerchantProfile(UUID.fromString(jSONObject.getString("OwnerUUID")), merchant, false);
        if (jSONObject.containsKey("Head")) {
            merchantProfile.setHead(d.k(jSONObject.getString("Head")));
        } else {
            merchantProfile.setHead(d.p());
        }
        if (jSONObject.containsKey("GroupName")) {
            merchantProfile.setGroupName(jSONObject.getString("GroupName"));
        }
        if (jSONObject.containsKey("Category")) {
            merchantProfile.setCategory(b.a(jSONObject.getString("Category")) != null ? b.a(jSONObject.getString("Category")) : b.a());
        }
        if (jSONObject.containsKey("MerchandiseSort")) {
            merchantProfile.setMerchandiseSort(MerchandiseSort.getSort(jSONObject.getString("MerchandiseSort")) != null ? MerchandiseSort.getSort(jSONObject.getString("MerchandiseSort")) : MerchandiseSort.getDefaultSort());
        }
        if (jSONObject.containsKey("ItemMailSort")) {
            merchantProfile.setItemMailSort(ItemMailSort.getSort(jSONObject.getString("ItemMailSort")) != null ? ItemMailSort.getSort(jSONObject.getString("ItemMailSort")) : ItemMailSort.getDefaultSort());
        }
        if (jSONObject.containsKey("HiddenMerchantName")) {
            merchantProfile.setHiddenMerchantName(jSONObject.getBoolean("HiddenMerchantName"));
        }
        if (jSONObject.containsKey("HiddenMerchandises")) {
            merchantProfile.setHiddenMerchandises(jSONObject.getBoolean("HiddenMerchandises"));
        }
        if (jSONObject.containsKey("MailboxLocked")) {
            merchantProfile.setMailboxLocked(jSONObject.getBoolean("MailboxLocked"));
        }
        if (jSONObject.containsKey("Notices")) {
            merchantProfile.notices.addAll(jSONObject.getJSONArray("Notices"));
        }
        if (jSONObject.containsKey("Tasks")) {
            merchantProfile.tasks.addAll(jSONObject.getJSONArray("Tasks"));
        }
        return merchantProfile;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public Merchant getMerchant() {
        return this.merchant;
    }

    public boolean isHiddenMerchantName() {
        return this.hiddenMerchantName;
    }

    public void setHiddenMerchantName(boolean bl) {
        this.hiddenMerchantName = bl;
    }

    public boolean isHiddenMerchandises() {
        return this.hiddenMerchandises;
    }

    public void setHiddenMerchandises(boolean bl) {
        this.hiddenMerchandises = bl;
    }

    public boolean isMailboxLocked() {
        return this.mailboxLocked;
    }

    public void setMailboxLocked(boolean bl) {
        this.mailboxLocked = bl;
    }

    public void setCategory(b b2) {
        this.category = b2;
    }

    public void setMerchandiseSort(MerchandiseSort merchandiseSort) {
        this.merchandiseSort = merchandiseSort;
    }

    public void setItemMailSort(ItemMailSort itemMailSort) {
        this.itemMailSort = itemMailSort;
    }

    public ItemStack getHead() {
        return this.head;
    }

    public void setHead(ItemStack itemStack) {
        this.head = itemStack;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public JSONArray getNotices() {
        return this.notices;
    }

    public JSONArray getTasks() {
        return this.tasks;
    }
}

