/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries;

import com.cryptomorin.xseries.ReflectionUtils;
import com.cryptomorin.xseries.XMaterial;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Base64;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SkullUtils {
    protected static final MethodHandle CRAFT_META_SKULL_PROFILE_GETTER;
    protected static final MethodHandle CRAFT_META_SKULL_PROFILE_SETTER;
    protected static final MethodHandle CRAFT_META_SKULL_BLOCK_SETTER;
    private static final String VALUE_PROPERTY = "{\"textures\":{\"SKIN\":{\"url\":\"";
    private static final boolean SUPPORTS_UUID;
    private static final String INVALID_BASE64 = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzEwNTkxZTY5MDllNmEyODFiMzcxODM2ZTQ2MmQ2N2EyYzc4ZmEwOTUyZTkxMGYzMmI0MWEyNmM0OGMxNzU3YyJ9fX0=";
    private static final Pattern MOJANG_SHA256_APPROX;
    private static final String TEXTURES = "https://textures.minecraft.net/texture/";

    @Nonnull
    public static ItemStack getSkull(@Nonnull UUID uUID) {
        ItemStack itemStack = XMaterial.PLAYER_HEAD.parseItem();
        SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
        if (SUPPORTS_UUID) {
            skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)uUID));
        } else {
            skullMeta.setOwner(Bukkit.getOfflinePlayer((UUID)uUID).getName());
        }
        itemStack.setItemMeta((ItemMeta)skullMeta);
        return itemStack;
    }

    @Nonnull
    public static SkullMeta applySkin(@Nonnull ItemMeta itemMeta, @Nonnull OfflinePlayer offlinePlayer) {
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        if (SUPPORTS_UUID) {
            skullMeta.setOwningPlayer(offlinePlayer);
        } else {
            skullMeta.setOwner(offlinePlayer.getName());
        }
        return skullMeta;
    }

    @Nonnull
    public static SkullMeta applySkin(@Nonnull ItemMeta itemMeta, @Nonnull UUID uUID) {
        return SkullUtils.applySkin(itemMeta, Bukkit.getOfflinePlayer((UUID)uUID));
    }

    @Nonnull
    public static SkullMeta applySkin(@Nonnull ItemMeta itemMeta, @Nonnull String string) {
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        switch (SkullUtils.detectSkullValueType(string)) {
            case UUID: {
                return SkullUtils.applySkin(itemMeta, Bukkit.getOfflinePlayer((UUID)UUID.fromString(string)));
            }
            case NAME: {
                return SkullUtils.applySkin(itemMeta, Bukkit.getOfflinePlayer((String)string));
            }
            case BASE64: {
                return SkullUtils.setSkullBase64(skullMeta, string);
            }
            case TEXTURE_URL: {
                return SkullUtils.setSkullBase64(skullMeta, SkullUtils.encodeTexturesURL(string));
            }
            case TEXTURE_HASH: {
                return SkullUtils.setSkullBase64(skullMeta, SkullUtils.encodeTexturesURL(TEXTURES + string));
            }
            case UNKNOWN: {
                return SkullUtils.setSkullBase64(skullMeta, INVALID_BASE64);
            }
        }
        throw new AssertionError((Object)"Unknown skull value");
    }

    @Nonnull
    protected static SkullMeta setSkullBase64(@Nonnull SkullMeta skullMeta, @Nonnull String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Skull value cannot be null or empty");
        }
        GameProfile gameProfile = SkullUtils.profileFromBase64(string);
        try {
            CRAFT_META_SKULL_PROFILE_SETTER.invoke(skullMeta, gameProfile);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return skullMeta;
    }

    @Nonnull
    public static GameProfile profileFromBase64(String string) {
        GameProfile gameProfile = new GameProfile(UUID.randomUUID(), null);
        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", string));
        return gameProfile;
    }

    @Nonnull
    public static GameProfile profileFromPlayer(OfflinePlayer offlinePlayer) {
        return new GameProfile(offlinePlayer.getUniqueId(), offlinePlayer.getName());
    }

    @Nonnull
    public static GameProfile detectProfileFromString(String string) {
        switch (SkullUtils.detectSkullValueType(string)) {
            case UUID: {
                return new GameProfile(UUID.fromString(string), null);
            }
            case NAME: {
                return new GameProfile(null, string);
            }
            case BASE64: {
                return SkullUtils.profileFromBase64(string);
            }
            case TEXTURE_URL: {
                return SkullUtils.profileFromBase64(SkullUtils.encodeTexturesURL(string));
            }
            case TEXTURE_HASH: {
                return SkullUtils.profileFromBase64(SkullUtils.encodeTexturesURL(TEXTURES + string));
            }
            case UNKNOWN: {
                return SkullUtils.profileFromBase64(INVALID_BASE64);
            }
        }
        throw new AssertionError((Object)"Unknown skull value");
    }

    public static ValueType detectSkullValueType(String string) {
        try {
            UUID.fromString(string);
            return ValueType.UUID;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (SkullUtils.isUsername(string)) {
                return ValueType.NAME;
            }
            if (string.contains("textures.minecraft.net")) {
                return ValueType.TEXTURE_URL;
            }
            if (string.length() > 100 && SkullUtils.isBase64(string)) {
                return ValueType.BASE64;
            }
            if (MOJANG_SHA256_APPROX.matcher(string).matches()) {
                return ValueType.TEXTURE_HASH;
            }
            return ValueType.UNKNOWN;
        }
    }

    public static void setSkin(@Nonnull Block block, @Nonnull String string) {
        Objects.requireNonNull(block, "Can't set skin of null block");
        BlockState blockState = block.getState();
        if (!(blockState instanceof Skull)) {
            return;
        }
        Skull skull = (Skull)blockState;
        GameProfile gameProfile = SkullUtils.detectProfileFromString(string);
        try {
            CRAFT_META_SKULL_BLOCK_SETTER.invoke(skull, gameProfile);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Error while setting block skin with value: " + string, throwable);
        }
        skull.update(true);
    }

    public static String encodeTexturesURL(String string) {
        return SkullUtils.encodeBase64(VALUE_PROPERTY + string + "\"}}}");
    }

    @Nonnull
    private static String encodeBase64(@Nonnull String string) {
        return Base64.getEncoder().encodeToString(string.getBytes());
    }

    private static boolean isBase64(@Nonnull String string) {
        try {
            Base64.getDecoder().decode(string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Nullable
    public static String getSkinValue(@Nonnull ItemMeta itemMeta) {
        Objects.requireNonNull(itemMeta, "Skull ItemStack cannot be null");
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        GameProfile gameProfile = null;
        try {
            gameProfile = CRAFT_META_SKULL_PROFILE_GETTER.invoke(skullMeta);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (gameProfile != null && !gameProfile.getProperties().get((Object)"textures").isEmpty()) {
            for (Property property : gameProfile.getProperties().get((Object)"textures")) {
                if (property.getValue().isEmpty()) continue;
                return property.getValue();
            }
        }
        return null;
    }

    private static boolean isUsername(@Nonnull String string) {
        int n = string.length();
        if (n > 16) {
            return false;
        }
        UnmodifiableIterator unmodifiableIterator = Lists.charactersOf((String)string).iterator();
        while (unmodifiableIterator.hasNext()) {
            char c = ((Character)unmodifiableIterator.next()).charValue();
            if (c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    static {
        Field field;
        Class<?> clazz;
        SUPPORTS_UUID = ReflectionUtils.supports(12);
        MOJANG_SHA256_APPROX = Pattern.compile("[0-9a-z]{60,70}");
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle methodHandle = null;
        MethodHandle methodHandle2 = null;
        MethodHandle methodHandle3 = null;
        try {
            clazz = ReflectionUtils.getCraftClass("inventory.CraftMetaSkull");
            field = clazz.getDeclaredField("profile");
            field.setAccessible(true);
            methodHandle2 = lookup.unreflectGetter(field);
            try {
                Method method = clazz.getDeclaredMethod("setProfile", GameProfile.class);
                method.setAccessible(true);
                methodHandle = lookup.unreflect(method);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                methodHandle = lookup.unreflectSetter(field);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
        }
        try {
            clazz = ReflectionUtils.getCraftClass("block.CraftSkull");
            field = clazz.getDeclaredField("profile");
            field.setAccessible(true);
            methodHandle3 = lookup.unreflectSetter(field);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        CRAFT_META_SKULL_PROFILE_SETTER = methodHandle;
        CRAFT_META_SKULL_PROFILE_GETTER = methodHandle2;
        CRAFT_META_SKULL_BLOCK_SETTER = methodHandle3;
    }

    public static enum ValueType {
        NAME,
        UUID,
        BASE64,
        TEXTURE_URL,
        TEXTURE_HASH,
        UNKNOWN;

    }
}

