/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.geantyref;

import io.leangen.geantyref.AnnotatedArrayTypeImpl;
import io.leangen.geantyref.AnnotatedCaptureType;
import io.leangen.geantyref.AnnotatedCaptureTypeImpl;
import io.leangen.geantyref.AnnotatedParameterizedTypeImpl;
import io.leangen.geantyref.AnnotatedTypeImpl;
import io.leangen.geantyref.AnnotatedTypeVariableImpl;
import io.leangen.geantyref.AnnotatedWildcardTypeImpl;
import io.leangen.geantyref.CaptureType;
import io.leangen.geantyref.GenericArrayTypeImpl;
import io.leangen.geantyref.ParameterizedTypeImpl;
import io.leangen.geantyref.TypeFactory;
import io.leangen.geantyref.TypeVisitor;
import io.leangen.geantyref.UnresolvedTypeVariableException;
import io.leangen.geantyref.VarMap;
import io.leangen.geantyref.WildcardTypeImpl;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class GenericTypeReflector {
    private static final WildcardType UNBOUND_WILDCARD = new WildcardTypeImpl(new Type[]{Object.class}, new Type[0]);
    private static final Map<Class<?>, Class<?>> BOX_TYPES;

    public static Class<?> erase(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            if (typeVariable.getBounds().length == 0) {
                return Object.class;
            }
            return GenericTypeReflector.erase(typeVariable.getBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return GenericArrayTypeImpl.createArrayType(GenericTypeReflector.erase(genericArrayType.getGenericComponentType()));
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] typeArray = wildcardType.getLowerBounds();
            return GenericTypeReflector.erase(typeArray.length > 0 ? typeArray[0] : wildcardType.getUpperBounds()[0]);
        }
        throw new RuntimeException("not supported: " + type.getClass());
    }

    public static Type box(Type type) {
        Class<?> clazz = BOX_TYPES.get(type);
        return clazz != null ? clazz : type;
    }

    public static boolean isFullyBound(Type type) {
        if (type instanceof Class) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return Arrays.stream(((ParameterizedType)type).getActualTypeArguments()).allMatch(GenericTypeReflector::isFullyBound);
        }
        if (type instanceof GenericArrayType) {
            return GenericTypeReflector.isFullyBound(((GenericArrayType)type).getGenericComponentType());
        }
        return false;
    }

    private static AnnotatedType mapTypeParameters(AnnotatedType annotatedType, AnnotatedType annotatedType2) {
        return GenericTypeReflector.mapTypeParameters(annotatedType, annotatedType2, VarMap.MappingMode.EXACT);
    }

    private static AnnotatedType mapTypeParameters(AnnotatedType annotatedType, AnnotatedType annotatedType2, VarMap.MappingMode mappingMode) {
        if (GenericTypeReflector.isMissingTypeParameters(annotatedType2.getType())) {
            return new AnnotatedTypeImpl(GenericTypeReflector.erase(annotatedType.getType()), annotatedType.getAnnotations());
        }
        VarMap varMap = new VarMap();
        AnnotatedType annotatedType3 = annotatedType2;
        while (annotatedType3 instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType annotatedParameterizedType = (AnnotatedParameterizedType)annotatedType3;
            Class clazz = (Class)((ParameterizedType)annotatedParameterizedType.getType()).getRawType();
            TypeVariable[] typeVariableArray = clazz.getTypeParameters();
            varMap.addAll(typeVariableArray, annotatedParameterizedType.getAnnotatedActualTypeArguments());
            Type type = ((ParameterizedType)annotatedParameterizedType.getType()).getOwnerType();
            annotatedType3 = type == null ? null : GenericTypeReflector.annotate(type);
        }
        return varMap.map(annotatedType, mappingMode);
    }

    public static AnnotatedType resolveExactType(AnnotatedType annotatedType, AnnotatedType annotatedType2) {
        return GenericTypeReflector.resolveType(annotatedType, GenericTypeReflector.expandGenerics(annotatedType2), VarMap.MappingMode.EXACT);
    }

    public static Type resolveExactType(Type type, Type type2) {
        return GenericTypeReflector.resolveType(GenericTypeReflector.annotate(type), GenericTypeReflector.annotate(type2, true), VarMap.MappingMode.EXACT).getType();
    }

    public static AnnotatedType resolveType(AnnotatedType annotatedType, AnnotatedType annotatedType2) {
        return GenericTypeReflector.resolveType(annotatedType, GenericTypeReflector.expandGenerics(annotatedType2), VarMap.MappingMode.ALLOW_INCOMPLETE);
    }

    public static Type resolveType(Type type, Type type2) {
        return GenericTypeReflector.resolveType(GenericTypeReflector.annotate(type), GenericTypeReflector.annotate(type2, true), VarMap.MappingMode.ALLOW_INCOMPLETE).getType();
    }

    private static AnnotatedType resolveType(AnnotatedType annotatedType, AnnotatedType annotatedType3, VarMap.MappingMode mappingMode) {
        if (annotatedType instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType annotatedParameterizedType = (AnnotatedParameterizedType)annotatedType;
            AnnotatedType[] annotatedTypeArray = (AnnotatedType[])Arrays.stream(annotatedParameterizedType.getAnnotatedActualTypeArguments()).map(annotatedType2 -> GenericTypeReflector.resolveType(annotatedType2, annotatedType3, mappingMode)).toArray(AnnotatedType[]::new);
            return GenericTypeReflector.replaceParameters(annotatedParameterizedType, annotatedTypeArray);
        }
        if (annotatedType instanceof AnnotatedWildcardType) {
            AnnotatedType[] annotatedTypeArray = (AnnotatedType[])Arrays.stream(((AnnotatedWildcardType)annotatedType).getAnnotatedLowerBounds()).map(annotatedType2 -> GenericTypeReflector.resolveType(annotatedType2, annotatedType3, mappingMode)).toArray(AnnotatedType[]::new);
            AnnotatedType[] annotatedTypeArray2 = (AnnotatedType[])Arrays.stream(((AnnotatedWildcardType)annotatedType).getAnnotatedUpperBounds()).map(annotatedType2 -> GenericTypeReflector.resolveType(annotatedType2, annotatedType3, mappingMode)).toArray(AnnotatedType[]::new);
            return new AnnotatedWildcardTypeImpl((WildcardType)annotatedType.getType(), annotatedType.getAnnotations(), annotatedTypeArray, annotatedTypeArray2);
        }
        if (annotatedType instanceof AnnotatedTypeVariable) {
            AnnotatedType annotatedType4;
            TypeVariable typeVariable = (TypeVariable)annotatedType.getType();
            if (typeVariable.getGenericDeclaration() instanceof Class && (annotatedType4 = GenericTypeReflector.getTypeParameter(annotatedType3, typeVariable)) != null) {
                return GenericTypeReflector.updateAnnotations(annotatedType4, annotatedType.getAnnotations());
            }
            if (mappingMode.equals((Object)VarMap.MappingMode.ALLOW_INCOMPLETE)) {
                return annotatedType;
            }
            throw new IllegalArgumentException("Variable " + typeVariable.getName() + " is not declared by the given type " + annotatedType3.getType().getTypeName() + " or its super types");
        }
        if (annotatedType instanceof AnnotatedArrayType) {
            AnnotatedType annotatedType5 = GenericTypeReflector.resolveType(((AnnotatedArrayType)annotatedType).getAnnotatedGenericComponentType(), annotatedType3, mappingMode);
            return new AnnotatedArrayTypeImpl(TypeFactory.arrayOf(annotatedType5.getType()), annotatedType.getAnnotations(), annotatedType5);
        }
        return annotatedType;
    }

    public static boolean isMissingTypeParameters(Type type) {
        if (type instanceof Class) {
            Class<?> clazz = (Class<?>)type;
            if (Modifier.isStatic(clazz.getModifiers())) {
                return clazz.getTypeParameters().length != 0;
            }
            for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getEnclosingClass()) {
                if (clazz2.getTypeParameters().length == 0) continue;
                return true;
            }
            return false;
        }
        if (type instanceof ParameterizedType) {
            return false;
        }
        throw new AssertionError((Object)("Unexpected type " + type.getClass()));
    }

    public static Type addWildcardParameters(Class<?> clazz) {
        if (clazz.isArray()) {
            return GenericArrayTypeImpl.createArrayType(GenericTypeReflector.addWildcardParameters(clazz.getComponentType()));
        }
        if (GenericTypeReflector.isMissingTypeParameters(clazz)) {
            TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
            Object[] objectArray = new Type[typeVariableArray.length];
            Arrays.fill(objectArray, UNBOUND_WILDCARD);
            Type type = clazz.getDeclaringClass() == null ? null : GenericTypeReflector.addWildcardParameters(clazz.getDeclaringClass());
            return new ParameterizedTypeImpl(clazz, (Type[])objectArray, type);
        }
        return clazz;
    }

    public static AnnotatedType getExactSuperType(AnnotatedType annotatedType, Class<?> clazz) {
        if (annotatedType instanceof AnnotatedParameterizedType || annotatedType.getType() instanceof Class || annotatedType instanceof AnnotatedArrayType) {
            AnnotatedType[] annotatedTypeArray = GenericTypeReflector.erase(annotatedType.getType());
            if (clazz == annotatedTypeArray) {
                return annotatedType;
            }
            if (!clazz.isAssignableFrom((Class<?>)annotatedTypeArray)) {
                return null;
            }
        }
        for (AnnotatedType annotatedType2 : GenericTypeReflector.getExactDirectSuperTypes(annotatedType)) {
            AnnotatedType annotatedType3 = GenericTypeReflector.getExactSuperType(annotatedType2, clazz);
            if (annotatedType3 == null) continue;
            return annotatedType3;
        }
        return null;
    }

    public static Type getExactSuperType(Type type, Class<?> clazz) {
        AnnotatedType annotatedType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.annotate(type), clazz);
        return annotatedType == null ? null : annotatedType.getType();
    }

    public static AnnotatedType getExactSubType(AnnotatedType annotatedType, Class<?> clazz) {
        Type type = clazz;
        if (clazz.getTypeParameters().length > 0) {
            type = TypeFactory.parameterizedClass(clazz, clazz.getTypeParameters());
        }
        AnnotatedType annotatedType2 = GenericTypeReflector.annotate(type);
        Class<?> clazz2 = GenericTypeReflector.erase(annotatedType.getType());
        if (clazz.isArray() && annotatedType instanceof AnnotatedArrayType) {
            if (clazz2.isAssignableFrom(clazz)) {
                return AnnotatedArrayTypeImpl.createArrayType(GenericTypeReflector.getExactSubType(((AnnotatedArrayType)annotatedType).getAnnotatedGenericComponentType(), clazz.getComponentType()), new Annotation[0]);
            }
            return null;
        }
        if (clazz.getTypeParameters().length == 0) {
            return annotatedType2;
        }
        if (!(annotatedType instanceof AnnotatedParameterizedType)) {
            return GenericTypeReflector.annotate(clazz);
        }
        AnnotatedParameterizedType annotatedParameterizedType = (AnnotatedParameterizedType)annotatedType;
        AnnotatedParameterizedType annotatedParameterizedType2 = (AnnotatedParameterizedType)GenericTypeReflector.getExactSuperType(annotatedType2, clazz2);
        if (annotatedParameterizedType2 == null) {
            return null;
        }
        VarMap varMap = new VarMap();
        for (int i = 0; i < annotatedParameterizedType.getAnnotatedActualTypeArguments().length; ++i) {
            Type type2 = annotatedParameterizedType2.getAnnotatedActualTypeArguments()[i].getType();
            if (!(type2 instanceof TypeVariable) || ((TypeVariable)type2).getGenericDeclaration() != clazz) continue;
            varMap.add((TypeVariable)type2, annotatedParameterizedType.getAnnotatedActualTypeArguments()[i]);
        }
        try {
            return varMap.map(annotatedType2);
        }
        catch (UnresolvedTypeVariableException unresolvedTypeVariableException) {
            return GenericTypeReflector.annotate(clazz);
        }
    }

    public static Type getExactSubType(Type type, Class<?> clazz) {
        AnnotatedType annotatedType = GenericTypeReflector.getExactSubType(GenericTypeReflector.annotate(type), clazz);
        return annotatedType == null ? null : annotatedType.getType();
    }

    public static AnnotatedType getTypeParameter(AnnotatedType annotatedType, TypeVariable<? extends Class<?>> typeVariable) {
        Class<?> clazz = typeVariable.getGenericDeclaration();
        AnnotatedType annotatedType2 = GenericTypeReflector.getExactSuperType(annotatedType, clazz);
        if (annotatedType2 instanceof AnnotatedParameterizedType) {
            int n = Arrays.asList(clazz.getTypeParameters()).indexOf(typeVariable);
            AnnotatedType annotatedType3 = ((AnnotatedParameterizedType)annotatedType2).getAnnotatedActualTypeArguments()[n];
            return GenericTypeReflector.updateAnnotations(annotatedType3, typeVariable.getAnnotations());
        }
        return null;
    }

    public static Type getTypeParameter(Type type, TypeVariable<? extends Class<?>> typeVariable) {
        AnnotatedType annotatedType = GenericTypeReflector.getTypeParameter(GenericTypeReflector.annotate(type), typeVariable);
        return annotatedType == null ? null : annotatedType.getType();
    }

    public static boolean isSuperType(Type type, Type type2) {
        if (type instanceof ParameterizedType || type instanceof Class || type instanceof GenericArrayType) {
            Type type3;
            Class<?> clazz = GenericTypeReflector.erase(type);
            AnnotatedType annotatedType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(GenericTypeReflector.annotate(type2)), clazz);
            Type type4 = type3 = annotatedType == null ? null : annotatedType.getType();
            if (type3 == null) {
                return false;
            }
            if (type instanceof Class) {
                return true;
            }
            if (type3 instanceof Class) {
                return true;
            }
            if (type3 instanceof GenericArrayType) {
                Type type5 = GenericTypeReflector.getArrayComponentType(type);
                assert (type5 != null);
                Type type6 = GenericTypeReflector.getArrayComponentType(type3);
                assert (type6 != null);
                return GenericTypeReflector.isSuperType(type5, type6);
            }
            assert (type3 instanceof ParameterizedType);
            assert (type instanceof ParameterizedType);
            ParameterizedType parameterizedType = (ParameterizedType)type3;
            assert (parameterizedType.getRawType() == clazz);
            ParameterizedType parameterizedType2 = (ParameterizedType)type;
            Type[] typeArray = parameterizedType2.getActualTypeArguments();
            Type[] typeArray2 = parameterizedType.getActualTypeArguments();
            assert (typeArray.length == typeArray2.length);
            for (int i = 0; i < typeArray.length; ++i) {
                if (GenericTypeReflector.contains(typeArray[i], typeArray2[i])) continue;
                return false;
            }
            return parameterizedType2.getOwnerType() == null || GenericTypeReflector.isSuperType(parameterizedType2.getOwnerType(), parameterizedType.getOwnerType());
        }
        if (type instanceof CaptureType) {
            if (type.equals(type2)) {
                return true;
            }
            for (Type type7 : ((CaptureType)type).getLowerBounds()) {
                if (!GenericTypeReflector.isSuperType(type7, type2)) continue;
                return true;
            }
            return false;
        }
        throw new RuntimeException("Type not supported: " + type.getClass());
    }

    private static boolean isArraySupertype(Type type, Type type2) {
        Type type3 = GenericTypeReflector.getArrayComponentType(type);
        assert (type3 != null);
        Type type4 = GenericTypeReflector.getArrayComponentType(type2);
        if (type4 == null) {
            return false;
        }
        return GenericTypeReflector.isSuperType(type3, type4);
    }

    public static AnnotatedType getArrayComponentType(AnnotatedType annotatedType) {
        if (annotatedType.getType() instanceof Class) {
            Class clazz = (Class)annotatedType.getType();
            return new AnnotatedTypeImpl(clazz.getComponentType(), clazz.getAnnotations());
        }
        if (annotatedType instanceof AnnotatedArrayType) {
            AnnotatedArrayType annotatedArrayType = (AnnotatedArrayType)annotatedType;
            return annotatedArrayType.getAnnotatedGenericComponentType();
        }
        return null;
    }

    public static Type getArrayComponentType(Type type) {
        AnnotatedType annotatedType = GenericTypeReflector.getArrayComponentType(GenericTypeReflector.annotate(type));
        return annotatedType == null ? null : annotatedType.getType();
    }

    private static boolean contains(Type type, Type type2) {
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            for (Type type3 : wildcardType.getUpperBounds()) {
                if (GenericTypeReflector.isSuperType(type3, type2)) continue;
                return false;
            }
            for (Type type3 : wildcardType.getLowerBounds()) {
                if (GenericTypeReflector.isSuperType(type2, type3)) continue;
                return false;
            }
            return true;
        }
        return type.equals(type2);
    }

    private static AnnotatedType[] getExactDirectSuperTypes(AnnotatedType annotatedType) {
        if (annotatedType instanceof AnnotatedParameterizedType || annotatedType != null && annotatedType.getType() instanceof Class) {
            int n;
            AnnotatedType[] annotatedTypeArray;
            Class clazz;
            if (annotatedType instanceof AnnotatedParameterizedType) {
                clazz = (Class)((ParameterizedType)annotatedType.getType()).getRawType();
            } else {
                clazz = (Class)annotatedType.getType();
                if (clazz.isArray()) {
                    return GenericTypeReflector.getArrayExactDirectSuperTypes(GenericTypeReflector.annotate(clazz));
                }
            }
            AnnotatedType[] annotatedTypeArray2 = clazz.getAnnotatedInterfaces();
            AnnotatedType annotatedType2 = clazz.getAnnotatedSuperclass();
            if (annotatedType2 == null && annotatedTypeArray2.length == 0 && clazz.isInterface()) {
                return new AnnotatedType[]{new AnnotatedTypeImpl((Type)((Object)Object.class))};
            }
            if (annotatedType2 == null) {
                annotatedTypeArray = new AnnotatedType[annotatedTypeArray2.length];
                n = 0;
            } else {
                annotatedTypeArray = new AnnotatedType[annotatedTypeArray2.length + 1];
                n = 1;
                annotatedTypeArray[0] = GenericTypeReflector.mapTypeParameters(annotatedType2, annotatedType);
            }
            for (AnnotatedType annotatedType3 : annotatedTypeArray2) {
                annotatedTypeArray[n++] = GenericTypeReflector.mapTypeParameters(annotatedType3, annotatedType);
            }
            return annotatedTypeArray;
        }
        if (annotatedType instanceof AnnotatedTypeVariable) {
            AnnotatedTypeVariable annotatedTypeVariable = (AnnotatedTypeVariable)annotatedType;
            return annotatedTypeVariable.getAnnotatedBounds();
        }
        if (annotatedType instanceof AnnotatedWildcardType) {
            return ((AnnotatedWildcardType)annotatedType).getAnnotatedUpperBounds();
        }
        if (annotatedType instanceof AnnotatedCaptureTypeImpl) {
            return ((AnnotatedCaptureTypeImpl)annotatedType).getAnnotatedUpperBounds();
        }
        if (annotatedType instanceof AnnotatedArrayType) {
            return GenericTypeReflector.getArrayExactDirectSuperTypes(annotatedType);
        }
        if (annotatedType == null) {
            throw new NullPointerException();
        }
        throw new RuntimeException("not implemented type: " + annotatedType);
    }

    private static AnnotatedType[] getArrayExactDirectSuperTypes(AnnotatedType annotatedType) {
        AnnotatedType[] annotatedTypeArray;
        int n;
        AnnotatedType annotatedType2 = GenericTypeReflector.getArrayComponentType(annotatedType);
        if (annotatedType2 != null && annotatedType2.getType() instanceof Class && ((Class)annotatedType2.getType()).isPrimitive()) {
            n = 0;
            annotatedTypeArray = new AnnotatedType[3];
        } else {
            AnnotatedType[] annotatedTypeArray2 = GenericTypeReflector.getExactDirectSuperTypes(annotatedType2);
            annotatedTypeArray = new AnnotatedType[annotatedTypeArray2.length + 3];
            for (n = 0; n < annotatedTypeArray2.length; ++n) {
                annotatedTypeArray[n] = AnnotatedArrayTypeImpl.createArrayType(annotatedTypeArray2[n], new Annotation[0]);
            }
        }
        annotatedTypeArray[n++] = new AnnotatedTypeImpl((Type)((Object)Object.class));
        annotatedTypeArray[n++] = new AnnotatedTypeImpl((Type)((Object)Cloneable.class));
        annotatedTypeArray[n++] = new AnnotatedTypeImpl((Type)((Object)Serializable.class));
        return annotatedTypeArray;
    }

    public static AnnotatedType getExactReturnType(Method method, AnnotatedType annotatedType) {
        return GenericTypeReflector.getReturnType(method, annotatedType, VarMap.MappingMode.EXACT);
    }

    public static Type getExactReturnType(Method method, Type type) {
        return GenericTypeReflector.getExactReturnType(method, GenericTypeReflector.annotate(type)).getType();
    }

    public static AnnotatedType getReturnType(Method method, AnnotatedType annotatedType) {
        return GenericTypeReflector.getReturnType(method, annotatedType, VarMap.MappingMode.ALLOW_INCOMPLETE);
    }

    public static Type getReturnType(Method method, Type type) {
        return GenericTypeReflector.getReturnType(method, GenericTypeReflector.annotate(type)).getType();
    }

    private static AnnotatedType getReturnType(Method method, AnnotatedType annotatedType, VarMap.MappingMode mappingMode) {
        AnnotatedType annotatedType2 = method.getAnnotatedReturnType();
        AnnotatedType annotatedType3 = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(annotatedType), method.getDeclaringClass());
        if (annotatedType3 == null) {
            throw new IllegalArgumentException("The method " + method + " is not a member of type " + annotatedType);
        }
        return GenericTypeReflector.mapTypeParameters(annotatedType2, annotatedType3, mappingMode);
    }

    public static AnnotatedType getExactFieldType(Field field, AnnotatedType annotatedType) {
        return GenericTypeReflector.getFieldType(field, annotatedType, VarMap.MappingMode.EXACT);
    }

    public static Type getExactFieldType(Field field, Type type) {
        return GenericTypeReflector.getExactFieldType(field, GenericTypeReflector.annotate(type)).getType();
    }

    public static AnnotatedType getFieldType(Field field, AnnotatedType annotatedType) {
        return GenericTypeReflector.getFieldType(field, annotatedType, VarMap.MappingMode.ALLOW_INCOMPLETE);
    }

    public static Type getFieldType(Field field, Type type) {
        return GenericTypeReflector.getFieldType(field, GenericTypeReflector.annotate(type)).getType();
    }

    private static AnnotatedType getFieldType(Field field, AnnotatedType annotatedType, VarMap.MappingMode mappingMode) {
        AnnotatedType annotatedType2 = field.getAnnotatedType();
        AnnotatedType annotatedType3 = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(annotatedType), field.getDeclaringClass());
        if (annotatedType3 == null) {
            throw new IllegalArgumentException("The field " + field + " is not a member of type " + annotatedType);
        }
        return GenericTypeReflector.mapTypeParameters(annotatedType2, annotatedType3, mappingMode);
    }

    public static AnnotatedType[] getExactParameterTypes(Executable executable, AnnotatedType annotatedType) {
        return GenericTypeReflector.getParameterTypes(executable, annotatedType, VarMap.MappingMode.EXACT);
    }

    public static Type[] getExactParameterTypes(Executable executable, Type type) {
        return (Type[])Arrays.stream(GenericTypeReflector.getExactParameterTypes(executable, GenericTypeReflector.annotate(type))).map(AnnotatedType::getType).toArray(Type[]::new);
    }

    public static AnnotatedType[] getParameterTypes(Executable executable, AnnotatedType annotatedType) {
        return GenericTypeReflector.getParameterTypes(executable, annotatedType, VarMap.MappingMode.ALLOW_INCOMPLETE);
    }

    public static Type[] getParameterTypes(Executable executable, Type type) {
        return (Type[])Arrays.stream(GenericTypeReflector.getParameterTypes(executable, GenericTypeReflector.annotate(type))).map(AnnotatedType::getType).toArray(Type[]::new);
    }

    private static AnnotatedType[] getParameterTypes(Executable executable, AnnotatedType annotatedType, VarMap.MappingMode mappingMode) {
        AnnotatedType[] annotatedTypeArray = executable.getAnnotatedParameterTypes();
        AnnotatedType annotatedType2 = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(annotatedType), executable.getDeclaringClass());
        if (annotatedType2 == null) {
            throw new IllegalArgumentException("The method/constructor " + executable + " is not a member of type " + annotatedType);
        }
        AnnotatedType[] annotatedTypeArray2 = new AnnotatedType[annotatedTypeArray.length];
        for (int i = 0; i < annotatedTypeArray.length; ++i) {
            annotatedTypeArray2[i] = GenericTypeReflector.mapTypeParameters(annotatedTypeArray[i], annotatedType2, mappingMode);
        }
        return annotatedTypeArray2;
    }

    public static AnnotatedType capture(AnnotatedType annotatedType) {
        if (annotatedType instanceof AnnotatedParameterizedType) {
            return GenericTypeReflector.capture((AnnotatedParameterizedType)annotatedType);
        }
        return annotatedType;
    }

    /*
     * WARNING - void declaration
     */
    public static AnnotatedParameterizedType capture(AnnotatedParameterizedType annotatedParameterizedType) {
        Type[] typeArray;
        VarMap varMap = new VarMap();
        ArrayList<Type[]> arrayList = new ArrayList<Type[]>();
        Class clazz = (Class)((ParameterizedType)annotatedParameterizedType.getType()).getRawType();
        AnnotatedType[] annotatedTypeArray = annotatedParameterizedType.getAnnotatedActualTypeArguments();
        TypeVariable<Class<T>>[] typeVariableArray = clazz.getTypeParameters();
        AnnotatedType[] annotatedTypeArray2 = new AnnotatedType[annotatedTypeArray.length];
        assert (annotatedTypeArray.length == typeVariableArray.length);
        for (int i = 0; i < annotatedTypeArray.length; ++i) {
            void annotatedType2;
            AnnotatedType annotatedType = annotatedTypeArray[i];
            if (annotatedType instanceof AnnotatedWildcardType) {
                Type[] typeArray2 = typeArray = new AnnotatedCaptureTypeImpl((AnnotatedWildcardType)annotatedType, new AnnotatedTypeVariableImpl(typeVariableArray[i]));
                arrayList.add(typeArray);
            }
            annotatedTypeArray2[i] = annotatedType2;
            varMap.add(typeVariableArray[i], (AnnotatedType)annotatedType2);
        }
        for (AnnotatedCaptureTypeImpl annotatedCaptureTypeImpl : arrayList) {
            annotatedCaptureTypeImpl.init(varMap);
        }
        ParameterizedType parameterizedType = (ParameterizedType)annotatedParameterizedType.getType();
        AnnotatedType annotatedType = parameterizedType.getOwnerType() == null ? null : GenericTypeReflector.capture(GenericTypeReflector.annotate(parameterizedType.getOwnerType()));
        typeArray = (Type[])Arrays.stream(annotatedTypeArray2).map(AnnotatedType::getType).toArray(Type[]::new);
        ParameterizedTypeImpl parameterizedTypeImpl = new ParameterizedTypeImpl(clazz, typeArray, annotatedType == null ? null : annotatedType.getType());
        return new AnnotatedParameterizedTypeImpl(parameterizedTypeImpl, annotatedParameterizedType.getAnnotations(), annotatedTypeArray2);
    }

    public static String getTypeName(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.isArray() ? GenericTypeReflector.getTypeName(clazz.getComponentType()) + "[]" : clazz.getName();
        }
        return type.toString();
    }

    public static List<Class<?>> getUpperBoundClassAndInterfaces(Type type) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        GenericTypeReflector.buildUpperBoundClassAndInterfaces(type, linkedHashSet);
        return new ArrayList(linkedHashSet);
    }

    private static AnnotatedType annotate(Type type, boolean bl) {
        return GenericTypeReflector.annotate(type, bl, new HashMap<CaptureCacheKey, AnnotatedType>());
    }

    public static AnnotatedType annotate(Type type) {
        return GenericTypeReflector.annotate(type, false);
    }

    public static AnnotatedType annotate(Type type, Annotation[] annotationArray) {
        return GenericTypeReflector.updateAnnotations(GenericTypeReflector.annotate(type), annotationArray);
    }

    private static AnnotatedType annotate(Type type2, boolean bl, Map<CaptureCacheKey, AnnotatedType> map) {
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            AnnotatedType[] annotatedTypeArray = new AnnotatedType[parameterizedType.getActualTypeArguments().length];
            for (int i = 0; i < annotatedTypeArray.length; ++i) {
                AnnotatedType annotatedType = GenericTypeReflector.annotate(parameterizedType.getActualTypeArguments()[i], bl, map);
                annotatedTypeArray[i] = GenericTypeReflector.updateAnnotations(annotatedType, GenericTypeReflector.erase(type2).getTypeParameters()[i].getAnnotations());
            }
            return new AnnotatedParameterizedTypeImpl(parameterizedType, GenericTypeReflector.erase(type2).getAnnotations(), annotatedTypeArray);
        }
        if (type2 instanceof CaptureType) {
            CaptureCacheKey captureCacheKey = new CaptureCacheKey((CaptureType)type2);
            if (map.containsKey(captureCacheKey)) {
                return map.get(captureCacheKey);
            }
            CaptureType captureType = (CaptureType)type2;
            AnnotatedCaptureTypeImpl annotatedCaptureTypeImpl = new AnnotatedCaptureTypeImpl(captureType, (AnnotatedWildcardType)GenericTypeReflector.annotate(captureType.getWildcardType(), bl, map), (AnnotatedTypeVariable)GenericTypeReflector.annotate(captureType.getTypeVariable(), bl, map));
            map.put(new CaptureCacheKey(captureType), annotatedCaptureTypeImpl);
            AnnotatedType[] annotatedTypeArray = (AnnotatedType[])Arrays.stream(captureType.getUpperBounds()).map(type -> GenericTypeReflector.annotate(type, bl, map)).toArray(AnnotatedType[]::new);
            annotatedCaptureTypeImpl.setAnnotatedUpperBounds(annotatedTypeArray);
            return annotatedCaptureTypeImpl;
        }
        if (type2 instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type2;
            AnnotatedType[] annotatedTypeArray = (AnnotatedType[])Arrays.stream(wildcardType.getLowerBounds()).map(type -> GenericTypeReflector.annotate(type, bl, map)).toArray(AnnotatedType[]::new);
            AnnotatedType[] annotatedTypeArray2 = (AnnotatedType[])Arrays.stream(wildcardType.getUpperBounds()).map(type -> GenericTypeReflector.annotate(type, bl, map)).toArray(AnnotatedType[]::new);
            return new AnnotatedWildcardTypeImpl(wildcardType, GenericTypeReflector.erase(type2).getAnnotations(), annotatedTypeArray, annotatedTypeArray2);
        }
        if (type2 instanceof TypeVariable) {
            return new AnnotatedTypeVariableImpl((TypeVariable)type2);
        }
        if (type2 instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type2;
            return new AnnotatedArrayTypeImpl(genericArrayType, new Annotation[0], GenericTypeReflector.annotate(genericArrayType.getGenericComponentType(), bl, map));
        }
        if (type2 instanceof Class) {
            Class clazz = (Class)type2;
            if (clazz.isArray()) {
                Class<?> clazz2 = clazz.getComponentType();
                return AnnotatedArrayTypeImpl.createArrayType(new AnnotatedTypeImpl(clazz2, clazz2.getAnnotations()), new Annotation[0]);
            }
            if (clazz.getTypeParameters().length > 0 && bl) {
                return GenericTypeReflector.expandClassGenerics(clazz);
            }
            return new AnnotatedTypeImpl(clazz, clazz.getAnnotations());
        }
        throw new IllegalArgumentException("Unrecognized type: " + type2.getTypeName());
    }

    public static <T extends AnnotatedType> T replaceAnnotations(T t, Annotation[] annotationArray) {
        if (t instanceof AnnotatedParameterizedType) {
            return (T)new AnnotatedParameterizedTypeImpl((ParameterizedType)t.getType(), annotationArray, ((AnnotatedParameterizedType)t).getAnnotatedActualTypeArguments());
        }
        if (t instanceof AnnotatedCaptureType) {
            AnnotatedCaptureType annotatedCaptureType = (AnnotatedCaptureType)t;
            return (T)new AnnotatedCaptureTypeImpl((CaptureType)annotatedCaptureType.getType(), annotatedCaptureType.getAnnotatedWildcardType(), annotatedCaptureType.getAnnotatedTypeVariable(), annotatedCaptureType.getAnnotatedUpperBounds(), annotationArray);
        }
        if (t instanceof AnnotatedWildcardType) {
            return (T)new AnnotatedWildcardTypeImpl((WildcardType)t.getType(), annotationArray, ((AnnotatedWildcardType)t).getAnnotatedLowerBounds(), ((AnnotatedWildcardType)t).getAnnotatedUpperBounds());
        }
        if (t instanceof AnnotatedTypeVariable) {
            return (T)new AnnotatedTypeVariableImpl((TypeVariable)t.getType(), annotationArray);
        }
        if (t instanceof AnnotatedArrayType) {
            return (T)new AnnotatedArrayTypeImpl(t.getType(), annotationArray, ((AnnotatedArrayType)t).getAnnotatedGenericComponentType());
        }
        return (T)new AnnotatedTypeImpl(t.getType(), annotationArray);
    }

    public static <T extends AnnotatedType> T updateAnnotations(T t, Annotation[] annotationArray) {
        if (annotationArray == null || annotationArray.length == 0 || Arrays.equals(t.getAnnotations(), annotationArray)) {
            return t;
        }
        return GenericTypeReflector.replaceAnnotations(t, GenericTypeReflector.merge(t.getAnnotations(), annotationArray));
    }

    public static <T extends AnnotatedType> T mergeAnnotations(T t, T t2) {
        Annotation[] annotationArray = GenericTypeReflector.merge(t.getAnnotations(), t2.getAnnotations());
        if (t instanceof AnnotatedParameterizedType) {
            AnnotatedType[] annotatedTypeArray = ((AnnotatedParameterizedType)t).getAnnotatedActualTypeArguments();
            AnnotatedType[] annotatedTypeArray2 = ((AnnotatedParameterizedType)t2).getAnnotatedActualTypeArguments();
            AnnotatedType[] annotatedTypeArray3 = new AnnotatedType[annotatedTypeArray.length];
            for (int i = 0; i < annotatedTypeArray.length; ++i) {
                annotatedTypeArray3[i] = GenericTypeReflector.mergeAnnotations(annotatedTypeArray[i], annotatedTypeArray2[i]);
            }
            return (T)new AnnotatedParameterizedTypeImpl((ParameterizedType)t.getType(), annotationArray, annotatedTypeArray3);
        }
        if (t instanceof AnnotatedWildcardType) {
            AnnotatedType[] annotatedTypeArray = ((AnnotatedWildcardType)t).getAnnotatedLowerBounds();
            AnnotatedType[] annotatedTypeArray4 = ((AnnotatedWildcardType)t2).getAnnotatedLowerBounds();
            AnnotatedType[] annotatedTypeArray5 = new AnnotatedType[annotatedTypeArray.length];
            for (int i = 0; i < annotatedTypeArray.length; ++i) {
                annotatedTypeArray5[i] = GenericTypeReflector.mergeAnnotations(annotatedTypeArray[i], annotatedTypeArray4[i]);
            }
            AnnotatedType[] annotatedTypeArray6 = ((AnnotatedWildcardType)t).getAnnotatedUpperBounds();
            AnnotatedType[] annotatedTypeArray7 = ((AnnotatedWildcardType)t2).getAnnotatedUpperBounds();
            AnnotatedType[] annotatedTypeArray8 = new AnnotatedType[annotatedTypeArray6.length];
            for (int i = 0; i < annotatedTypeArray6.length; ++i) {
                annotatedTypeArray8[i] = GenericTypeReflector.mergeAnnotations(annotatedTypeArray6[i], annotatedTypeArray7[i]);
            }
            return (T)new AnnotatedWildcardTypeImpl((WildcardType)t.getType(), annotationArray, annotatedTypeArray5, annotatedTypeArray8);
        }
        if (t instanceof AnnotatedTypeVariable) {
            return (T)new AnnotatedTypeVariableImpl((TypeVariable)t.getType(), annotationArray);
        }
        if (t instanceof AnnotatedArrayType) {
            AnnotatedType annotatedType = GenericTypeReflector.mergeAnnotations(((AnnotatedArrayType)t).getAnnotatedGenericComponentType(), ((AnnotatedArrayType)t2).getAnnotatedGenericComponentType());
            return (T)new AnnotatedArrayTypeImpl(t.getType(), annotationArray, annotatedType);
        }
        return (T)new AnnotatedTypeImpl(t.getType(), annotationArray);
    }

    public static AnnotatedParameterizedType replaceParameters(AnnotatedParameterizedType annotatedParameterizedType, AnnotatedType[] annotatedTypeArray) {
        Type[] typeArray = (Type[])Arrays.stream(annotatedTypeArray).map(AnnotatedType::getType).toArray(Type[]::new);
        ParameterizedType parameterizedType = (ParameterizedType)annotatedParameterizedType.getType();
        ParameterizedType parameterizedType2 = (ParameterizedType)TypeFactory.parameterizedInnerClass(parameterizedType.getOwnerType(), GenericTypeReflector.erase(parameterizedType), typeArray);
        return new AnnotatedParameterizedTypeImpl(parameterizedType2, annotatedParameterizedType.getAnnotations(), annotatedTypeArray);
    }

    public static <T extends AnnotatedType> T toCanonical(T t) {
        return GenericTypeReflector.toCanonical(t, Function.identity(), new HashMap<AnnotatedCaptureCacheKey, AnnotatedType>());
    }

    public static <T extends AnnotatedType> T toCanonicalBoxed(T t) {
        return GenericTypeReflector.toCanonical(t, GenericTypeReflector::box, new HashMap<AnnotatedCaptureCacheKey, AnnotatedType>());
    }

    private static <T extends AnnotatedType> T toCanonical(T t, final Function<Type, Type> function, Map<AnnotatedCaptureCacheKey, AnnotatedType> map) {
        return (T)GenericTypeReflector.transform(t, new TypeVisitor(){

            @Override
            protected AnnotatedType visitClass(AnnotatedType annotatedType) {
                return new AnnotatedTypeImpl((Type)function.apply(annotatedType.getType()), annotatedType.getAnnotations());
            }

            @Override
            protected AnnotatedType visitArray(AnnotatedArrayType annotatedArrayType) {
                return new AnnotatedArrayTypeImpl((Type)function.apply(annotatedArrayType.getType()), annotatedArrayType.getAnnotations(), GenericTypeReflector.transform(annotatedArrayType.getAnnotatedGenericComponentType(), this));
            }
        });
    }

    private static AnnotatedType expandGenerics(AnnotatedType annotatedType) {
        return GenericTypeReflector.transform(annotatedType, new TypeVisitor(){

            @Override
            public AnnotatedType visitClass(AnnotatedType annotatedType) {
                Class clazz = (Class)annotatedType.getType();
                if (clazz.getTypeParameters().length > 0) {
                    return GenericTypeReflector.expandClassGenerics(clazz);
                }
                return annotatedType;
            }
        });
    }

    public static AnnotatedType transform(AnnotatedType annotatedType, TypeVisitor typeVisitor) {
        if (annotatedType instanceof AnnotatedParameterizedType) {
            return typeVisitor.visitParameterizedType((AnnotatedParameterizedType)annotatedType);
        }
        if (annotatedType instanceof AnnotatedWildcardType) {
            return typeVisitor.visitWildcardType((AnnotatedWildcardType)annotatedType);
        }
        if (annotatedType instanceof AnnotatedTypeVariable) {
            return typeVisitor.visitVariable((AnnotatedTypeVariable)annotatedType);
        }
        if (annotatedType instanceof AnnotatedArrayType) {
            return typeVisitor.visitArray((AnnotatedArrayType)annotatedType);
        }
        if (annotatedType instanceof AnnotatedCaptureType) {
            return typeVisitor.visitCaptureType((AnnotatedCaptureType)annotatedType);
        }
        if (annotatedType.getType() instanceof Class) {
            return typeVisitor.visitClass(annotatedType);
        }
        return typeVisitor.visitUnmatched(annotatedType);
    }

    private static AnnotatedParameterizedType expandClassGenerics(Class<?> clazz) {
        ParameterizedTypeImpl parameterizedTypeImpl = new ParameterizedTypeImpl(clazz, clazz.getTypeParameters(), clazz.getDeclaringClass());
        AnnotatedType[] annotatedTypeArray = (AnnotatedType[])Arrays.stream(clazz.getTypeParameters()).map(GenericTypeReflector::annotate).toArray(AnnotatedType[]::new);
        return new AnnotatedParameterizedTypeImpl(parameterizedTypeImpl, clazz.getAnnotations(), annotatedTypeArray);
    }

    public static Annotation[] merge(Annotation[] ... annotationArray3) {
        return Arrays.stream(annotationArray3).reduce((annotationArray, annotationArray2) -> (Annotation[])Stream.concat(Arrays.stream(annotationArray), Arrays.stream(annotationArray2)).distinct().toArray(Annotation[]::new)).orElse(new Annotation[0]);
    }

    static boolean typeArraysEqual(AnnotatedType[] annotatedTypeArray, AnnotatedType[] annotatedTypeArray2) {
        if (annotatedTypeArray == annotatedTypeArray2) {
            return true;
        }
        if (annotatedTypeArray == null) {
            return false;
        }
        if (annotatedTypeArray2 == null) {
            return false;
        }
        if (annotatedTypeArray.length != annotatedTypeArray2.length) {
            return false;
        }
        for (int i = 0; i < annotatedTypeArray.length; ++i) {
            if (annotatedTypeArray[i].getType().equals(annotatedTypeArray2[i].getType()) && Arrays.equals(annotatedTypeArray[i].getAnnotations(), annotatedTypeArray2[i].getAnnotations())) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(AnnotatedType ... annotatedTypeArray) {
        int n3 = Arrays.stream(annotatedTypeArray).mapToInt(annotatedType -> annotatedType.getType().hashCode()).reduce(0, (n, n2) -> 127 * n ^ n2);
        int n4 = GenericTypeReflector.hashCode(Arrays.stream(annotatedTypeArray).flatMap(annotatedType -> Arrays.stream(annotatedType.getAnnotations())));
        return 31 * n3 ^ n4;
    }

    static int hashCode(Stream<Annotation> stream) {
        return stream.mapToInt(annotation -> 31 * annotation.annotationType().hashCode() ^ annotation.hashCode()).reduce(0, (n, n2) -> 127 * n ^ n2);
    }

    public static boolean equals(AnnotatedType annotatedType, AnnotatedType annotatedType2) {
        Objects.requireNonNull(annotatedType);
        Objects.requireNonNull(annotatedType2);
        annotatedType = annotatedType instanceof AnnotatedTypeImpl ? annotatedType : GenericTypeReflector.toCanonical(annotatedType);
        annotatedType2 = annotatedType2 instanceof AnnotatedTypeImpl ? annotatedType2 : GenericTypeReflector.toCanonical(annotatedType2);
        return annotatedType.equals(annotatedType2);
    }

    private static void buildUpperBoundClassAndInterfaces(Type type, Set<Class<?>> set) {
        if (type instanceof ParameterizedType || type instanceof Class) {
            set.add(GenericTypeReflector.erase(type));
            return;
        }
        for (AnnotatedType annotatedType : GenericTypeReflector.getExactDirectSuperTypes(GenericTypeReflector.annotate(type))) {
            GenericTypeReflector.buildUpperBoundClassAndInterfaces(annotatedType.getType(), set);
        }
    }

    static {
        HashMap<Class<Object>, Class<Void>> hashMap = new HashMap<Class<Object>, Class<Void>>();
        hashMap.put(Boolean.TYPE, Boolean.class);
        hashMap.put(Byte.TYPE, Byte.class);
        hashMap.put(Character.TYPE, Character.class);
        hashMap.put(Double.TYPE, Double.class);
        hashMap.put(Float.TYPE, Float.class);
        hashMap.put(Integer.TYPE, Integer.class);
        hashMap.put(Long.TYPE, Long.class);
        hashMap.put(Short.TYPE, Short.class);
        hashMap.put(Void.TYPE, Void.class);
        BOX_TYPES = Collections.unmodifiableMap(hashMap);
    }

    private static class AnnotatedCaptureCacheKey {
        AnnotatedCaptureType capture;
        CaptureType raw;

        AnnotatedCaptureCacheKey(AnnotatedCaptureType annotatedCaptureType) {
            this.capture = annotatedCaptureType;
            this.raw = (CaptureType)annotatedCaptureType.getType();
        }

        public int hashCode() {
            return 127 * this.raw.getWildcardType().hashCode() ^ this.raw.getTypeVariable().hashCode() ^ GenericTypeReflector.hashCode(Arrays.stream(this.capture.getAnnotations()));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof AnnotatedCaptureCacheKey)) {
                return false;
            }
            AnnotatedCaptureCacheKey annotatedCaptureCacheKey = (AnnotatedCaptureCacheKey)object;
            return this.capture == annotatedCaptureCacheKey.capture || new CaptureCacheKey(this.raw).equals(new CaptureCacheKey(annotatedCaptureCacheKey.raw)) && Arrays.equals(this.capture.getAnnotations(), annotatedCaptureCacheKey.capture.getAnnotations());
        }
    }

    static class CaptureCacheKey {
        CaptureType capture;

        CaptureCacheKey(CaptureType captureType) {
            this.capture = captureType;
        }

        public int hashCode() {
            return 127 * this.capture.getWildcardType().hashCode() ^ this.capture.getTypeVariable().hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CaptureCacheKey)) {
                return false;
            }
            CaptureType captureType = ((CaptureCacheKey)object).capture;
            return this.capture == captureType || this.capture.getWildcardType().equals(captureType.getWildcardType()) && this.capture.getTypeVariable().equals(captureType.getTypeVariable()) && Arrays.equals(this.capture.getUpperBounds(), captureType.getUpperBounds());
        }
    }
}

