/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.geantyref;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;

class ParameterizedTypeImpl
implements ParameterizedType {
    private final Class<?> rawType;
    private final Type[] actualTypeArguments;
    private final Type ownerType;

    ParameterizedTypeImpl(Class<?> clazz, Type[] typeArray, Type type) {
        this.rawType = clazz;
        this.actualTypeArguments = typeArray;
        this.ownerType = type;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType parameterizedType = (ParameterizedType)object;
        return this == parameterizedType || Objects.equals(this.ownerType, parameterizedType.getOwnerType()) && Objects.equals(this.rawType, parameterizedType.getRawType()) && Arrays.equals(this.actualTypeArguments, parameterizedType.getActualTypeArguments());
    }

    public int hashCode() {
        return Arrays.hashCode(this.actualTypeArguments) ^ Objects.hashCode(this.ownerType) ^ Objects.hashCode(this.rawType);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.rawType.getName();
        if (this.ownerType != null) {
            String string2;
            stringBuilder.append(GenericTypeReflector.getTypeName(this.ownerType)).append('.');
            String string3 = string2 = this.ownerType instanceof ParameterizedType ? ((Class)((ParameterizedType)this.ownerType).getRawType()).getName() + '$' : ((Class)this.ownerType).getName() + '$';
            if (string.startsWith(string2)) {
                string = string.substring(string2.length());
            }
        }
        stringBuilder.append(string);
        if (this.actualTypeArguments.length != 0) {
            stringBuilder.append('<');
            for (int i = 0; i < this.actualTypeArguments.length; ++i) {
                Type type = this.actualTypeArguments[i];
                if (i != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(GenericTypeReflector.getTypeName(type));
            }
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }
}

