/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.acf;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.acf.ACFHandler;
import me.glaremasters.guilds.actions.ActionHandler;
import me.glaremasters.guilds.arena.Arena;
import me.glaremasters.guilds.arena.ArenaHandler;
import me.glaremasters.guilds.challenges.ChallengeHandler;
import me.glaremasters.guilds.configuration.sections.PluginSettings;
import me.glaremasters.guilds.cooldowns.CooldownHandler;
import me.glaremasters.guilds.database.DatabaseAdapter;
import me.glaremasters.guilds.exceptions.ExpectationNotMet;
import me.glaremasters.guilds.exceptions.InvalidPermissionException;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildCode;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.guild.GuildMember;
import me.glaremasters.guilds.libs.commands.BaseCommand;
import me.glaremasters.guilds.libs.commands.BukkitCommandCompletionContext;
import me.glaremasters.guilds.libs.commands.BukkitCommandExecutionContext;
import me.glaremasters.guilds.libs.commands.ConditionContext;
import me.glaremasters.guilds.libs.commands.InvalidCommandArgument;
import me.glaremasters.guilds.libs.commands.PaperCommandManager;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.collections.CollectionsKt;
import me.glaremasters.guilds.libs.kotlin.io.FilesKt;
import me.glaremasters.guilds.libs.kotlin.jvm.functions.Function1;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.SourceDebugExtension;
import me.glaremasters.guilds.libs.kotlin.ranges.RangesKt;
import me.glaremasters.guilds.libs.kotlin.sequences.Sequence;
import me.glaremasters.guilds.libs.kotlin.sequences.SequencesKt;
import me.glaremasters.guilds.libs.kotlin.text.StringsKt;
import me.glaremasters.guilds.libs.locales.MessageKeyProvider;
import me.glaremasters.guilds.messages.Messages;
import me.glaremasters.guilds.scanner.ZISScanner;
import me.glaremasters.guilds.utils.MessageUtils;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0002J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0017\u001a\u00020\rH\u0002J\u0006\u0010\u0018\u001a\u00020\rJ\b\u0010\u0019\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lme/glaremasters/guilds/acf/ACFHandler;", "", "plugin", "Lme/glaremasters/guilds/Guilds;", "commandManager", "Lme/glaremasters/guilds/libs/commands/PaperCommandManager;", "(Lme/glaremasters/guilds/Guilds;Lco/aikar/commands/PaperCommandManager;)V", "languages", "", "", "getLanguages", "()Ljava/util/List;", "load", "", "loadCommands", "loadCompletionCache", "loadCompletions", "guildHandler", "Lme/glaremasters/guilds/guild/GuildHandler;", "arenaHandler", "Lme/glaremasters/guilds/arena/ArenaHandler;", "loadConditions", "loadContexts", "loadDI", "loadLang", "loadSyntaxReplacements", "Guilds"})
@SourceDebugExtension(value={"SMAP\nACFHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ACFHandler.kt\nme/glaremasters/guilds/acf/ACFHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n3792#2:233\n4307#2,2:234\n1855#3,2:236\n1855#3:240\n1855#3,2:241\n1856#3:243\n1603#3,9:244\n1855#3:253\n1856#3:255\n1612#3:256\n1603#3,9:257\n1855#3:266\n1856#3:268\n1612#3:269\n1603#3,9:270\n1855#3:279\n1856#3:281\n1612#3:282\n1603#3,9:283\n1855#3:292\n1856#3:294\n1612#3:295\n1549#3:296\n1620#3,3:297\n1549#3:300\n1620#3,3:301\n1295#4,2:238\n1#5:254\n1#5:267\n1#5:280\n1#5:293\n*S KotlinDebug\n*F\n+ 1 ACFHandler.kt\nme/glaremasters/guilds/acf/ACFHandler\n*L\n94#1:233\n94#1:234,2\n96#1:236,2\n213#1:240\n214#1:241,2\n213#1:243\n167#1:244,9\n167#1:253\n167#1:255\n167#1:256\n171#1:257,9\n171#1:266\n171#1:268\n171#1:269\n178#1:270,9\n178#1:279\n178#1:281\n178#1:282\n185#1:283,9\n185#1:292\n185#1:294\n185#1:295\n192#1:296\n192#1:297,3\n200#1:300\n200#1:301,3\n207#1:238,2\n167#1:254\n171#1:267\n178#1:280\n185#1:293\n*E\n"})
public final class ACFHandler {
    @NotNull
    private final Guilds plugin;
    @NotNull
    private final PaperCommandManager commandManager;
    @NotNull
    private final List<String> languages;

    public ACFHandler(@NotNull Guilds guilds, @NotNull PaperCommandManager paperCommandManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)guilds), (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)paperCommandManager, (String)"commandManager");
        this.plugin = guilds;
        this.commandManager = paperCommandManager;
        this.languages = new ArrayList();
    }

    @NotNull
    public final List<String> getLanguages() {
        return this.languages;
    }

    public final void load() {
        this.commandManager.usePerIssuerLocale(true, false);
        this.commandManager.enableUnstableAPI("help");
        this.loadLang();
        GuildHandler guildHandler = this.plugin.getGuildHandler();
        Intrinsics.checkNotNullExpressionValue((Object)guildHandler, (String)"plugin.guildHandler");
        ArenaHandler arenaHandler = this.plugin.getArenaHandler();
        Intrinsics.checkNotNullExpressionValue((Object)arenaHandler, (String)"plugin.arenaHandler");
        this.loadContexts(guildHandler, arenaHandler);
        GuildHandler guildHandler2 = this.plugin.getGuildHandler();
        Intrinsics.checkNotNullExpressionValue((Object)guildHandler2, (String)"plugin.guildHandler");
        ArenaHandler arenaHandler2 = this.plugin.getArenaHandler();
        Intrinsics.checkNotNullExpressionValue((Object)arenaHandler2, (String)"plugin.arenaHandler");
        this.loadCompletions(guildHandler2, arenaHandler2);
        GuildHandler guildHandler3 = this.plugin.getGuildHandler();
        Intrinsics.checkNotNullExpressionValue((Object)guildHandler3, (String)"plugin.guildHandler");
        this.loadConditions(guildHandler3);
        this.loadDI();
        this.loadSyntaxReplacements();
        this.loadCommands();
        this.loadCompletionCache();
    }

    private final void loadSyntaxReplacements() {
        this.commandManager.getCommandReplacements().addReplacement("guilds", this.plugin.getSettingsHandler().getMainConf().getProperty(PluginSettings.PLUGIN_ALIASES));
        this.commandManager.getCommandReplacements().addReplacement("msg", MessageUtils.asString(this.commandManager, (MessageKeyProvider)Messages.SYNTAX__MSG));
        this.commandManager.getCommandReplacements().addReplacement("name", MessageUtils.asString(this.commandManager, (MessageKeyProvider)Messages.SYNTAX__NAME));
        this.commandManager.getCommandReplacements().addReplacement("player", MessageUtils.asString(this.commandManager, (MessageKeyProvider)Messages.SYNTAX__PLAYER));
        this.commandManager.getCommandReplacements().addReplacement("amount", MessageUtils.asString(this.commandManager, (MessageKeyProvider)Messages.SYNTAX__AMOUNT));
        this.commandManager.getCommandReplacements().addReplacement("guild", MessageUtils.asString(this.commandManager, (MessageKeyProvider)Messages.SYNTAX__GUILD));
        this.commandManager.getCommandReplacements().addReplacement("new-name", MessageUtils.asString(this.commandManager, (MessageKeyProvider)Messages.SYNTAX__NEW_NAME));
        this.commandManager.getCommandReplacements().addReplacement("motd", MessageUtils.asString(this.commandManager, (MessageKeyProvider)Messages.SYNTAX__MOTD));
        this.commandManager.getCommandReplacements().addReplacement("prefix", MessageUtils.asString(this.commandManager, (MessageKeyProvider)Messages.SYNTAX__PREFIX));
        this.commandManager.getCommandReplacements().addReplacement("vault-number", MessageUtils.asString(this.commandManager, (MessageKeyProvider)Messages.SYNTAX__VAULT_NUMBER));
        this.commandManager.getCommandReplacements().addReplacement("arena", MessageUtils.asString(this.commandManager, (MessageKeyProvider)Messages.SYNTAX__ARENA));
        this.commandManager.getCommandReplacements().addReplacement("position", MessageUtils.asString(this.commandManager, (MessageKeyProvider)Messages.SYNTAX__POSITION));
        this.commandManager.getCommandReplacements().addReplacement("code", MessageUtils.asString(this.commandManager, (MessageKeyProvider)Messages.SYNTAX__CODE));
        this.commandManager.getCommandReplacements().addReplacement("uses", MessageUtils.asString(this.commandManager, (MessageKeyProvider)Messages.SYNTAX__USES));
        this.commandManager.getCommandReplacements().addReplacement("language", MessageUtils.asString(this.commandManager, (MessageKeyProvider)Messages.SYNTAX__LANGUAGE));
        this.commandManager.getCommandReplacements().addReplacement("new-backend", MessageUtils.asString(this.commandManager, (MessageKeyProvider)Messages.SYNTAX__NEW_BACKEND));
        this.commandManager.getCommandReplacements().addReplacement("new-master", MessageUtils.asString(this.commandManager, (MessageKeyProvider)Messages.SYNTAX__NEW_MASTER));
        this.commandManager.getCommandReplacements().addReplacement("optional", MessageUtils.asString(this.commandManager, (MessageKeyProvider)Messages.SYNTAX__OPTIONAL));
    }

    public final void loadLang() {
        this.languages.clear();
        File file = this.plugin.getDataFolder();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"plugin.dataFolder");
        File[] fileArray = FilesKt.resolve((File)file, (String)"languages").listFiles();
        if (fileArray != null) {
            int n;
            Object object = fileArray;
            boolean bl = false;
            Object object2 = object;
            Collection<File> collection = new ArrayList();
            boolean bl2 = false;
            int n2 = ((File[])object2).length;
            for (n = 0; n < n2; ++n) {
                File file2;
                File file3 = file2 = object2[n];
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"it");
                if (!StringsKt.equals((String)FilesKt.getExtension((File)file3), (String)"yml", (boolean)true)) continue;
                collection.add(file2);
            }
            object = (List)collection;
            bl = false;
            object2 = object.iterator();
            while (object2.hasNext()) {
                collection = object2.next();
                File file4 = (File)((Object)collection);
                n = 0;
                Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"it");
                Locale locale = Locale.forLanguageTag(FilesKt.getNameWithoutExtension((File)file4));
                this.commandManager.addSupportedLanguage(locale);
                this.commandManager.getLocales().loadYamlLanguageFile(file4, locale);
                this.languages.add(FilesKt.getNameWithoutExtension((File)file4));
            }
        }
        this.commandManager.getLocales().setDefaultLocale(Locale.forLanguageTag(this.plugin.getSettingsHandler().getMainConf().getProperty(PluginSettings.MESSAGES_LANGUAGE)));
    }

    private final void loadContexts(GuildHandler guildHandler, ArenaHandler arenaHandler) {
        this.commandManager.getCommandContexts().registerIssuerAwareContext(Guild.class, arg_0 -> ACFHandler.loadContexts$lambda$2(guildHandler, arg_0));
        this.commandManager.getCommandContexts().registerContext(Arena.class, arg_0 -> ACFHandler.loadContexts$lambda$3(arenaHandler, arg_0));
    }

    private final void loadConditions(GuildHandler guildHandler) {
        this.commandManager.getCommandConditions().addCondition(Guild.class, "perm", (arg_0, arg_1, arg_2) -> ACFHandler.loadConditions$lambda$4(guildHandler, arg_0, arg_1, arg_2));
        this.commandManager.getCommandConditions().addCondition(Guild.class, "NotMaxedAllies", (arg_0, arg_1, arg_2) -> ACFHandler.loadConditions$lambda$5(guildHandler, arg_0, arg_1, arg_2));
        this.commandManager.getCommandConditions().addCondition(Player.class, "NoGuild", (arg_0, arg_1, arg_2) -> ACFHandler.loadConditions$lambda$6(guildHandler, arg_0, arg_1, arg_2));
        this.commandManager.getCommandConditions().addCondition("NotMigrating", arg_0 -> ACFHandler.loadConditions$lambda$7(guildHandler, arg_0));
    }

    private final void loadCompletions(GuildHandler guildHandler, ArenaHandler arenaHandler) {
        this.commandManager.getCommandCompletions().registerCompletion("invitedTo", arg_0 -> ACFHandler.loadCompletions$lambda$8(guildHandler, arg_0));
        this.commandManager.getCommandCompletions().registerCompletion("joinableGuilds", arg_0 -> ACFHandler.loadCompletions$lambda$9(guildHandler, arg_0));
        this.commandManager.getCommandCompletions().registerCompletion("guilds", arg_0 -> ACFHandler.loadCompletions$lambda$10(guildHandler, arg_0));
        this.commandManager.getCommandCompletions().registerCompletion("arenas", arg_0 -> ACFHandler.loadCompletions$lambda$11(arenaHandler, arg_0));
        this.commandManager.getCommandCompletions().registerStaticCompletion("locations", ACFHandler::loadCompletions$lambda$12);
        this.commandManager.getCommandCompletions().registerCompletion("languages", arg_0 -> ACFHandler.loadCompletions$lambda$13(this, arg_0));
        this.commandManager.getCommandCompletions().registerStaticCompletion("sources", ACFHandler::loadCompletions$lambda$14);
        this.commandManager.getCommandCompletions().registerAsyncCompletion("members", arg_0 -> ACFHandler.loadCompletions$lambda$16(guildHandler, arg_0));
        this.commandManager.getCommandCompletions().registerCompletion("members-admin", arg_0 -> ACFHandler.loadCompletions$lambda$18(guildHandler, arg_0));
        this.commandManager.getCommandCompletions().registerCompletion("allyInvites", arg_0 -> ACFHandler.loadCompletions$lambda$20(guildHandler, arg_0));
        this.commandManager.getCommandCompletions().registerCompletion("allies", arg_0 -> ACFHandler.loadCompletions$lambda$22(guildHandler, arg_0));
        this.commandManager.getCommandCompletions().registerCompletion("activeCodes", arg_0 -> ACFHandler.loadCompletions$lambda$24(guildHandler, arg_0));
        this.commandManager.getCommandCompletions().registerCompletion("vaultAmount", arg_0 -> ACFHandler.loadCompletions$lambda$25(guildHandler, arg_0));
    }

    private final void loadCommands() {
        Set<Class<?>> set = new ZISScanner().getClasses(Guilds.class, "me.glaremasters.guilds.commands");
        Intrinsics.checkNotNullExpressionValue(set, (String)"ZISScanner().getClasses(\u2026masters.guilds.commands\")");
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)loadCommands.1.INSTANCE);
        boolean bl = false;
        for (Object e : sequence) {
            Class clazz = (Class)e;
            boolean bl2 = false;
            Object t = clazz.newInstance();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type co.aikar.commands.BaseCommand");
            this.commandManager.registerCommand((BaseCommand)t);
        }
    }

    private final void loadCompletionCache() {
        GuildHandler guildHandler = this.plugin.getGuildHandler();
        Iterable iterable = guildHandler.getGuilds().values();
        boolean bl = false;
        for (Object t : iterable) {
            Guild guild = (Guild)t;
            boolean bl2 = false;
            List<GuildMember> list2 = guild.getMembers();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"guild.members");
            Iterable iterable2 = CollectionsKt.filterNotNull((Iterable)list2);
            boolean bl3 = false;
            for (Object t2 : iterable2) {
                GuildMember guildMember = (GuildMember)t2;
                boolean bl4 = false;
                guildHandler.getLookupCache().putIfAbsent(guildMember.getUuid(), guildMember.getName());
            }
        }
    }

    private final void loadDI() {
        this.commandManager.registerDependency(GuildHandler.class, this.plugin.getGuildHandler());
        this.commandManager.registerDependency(SettingsManager.class, this.plugin.getSettingsHandler().getMainConf());
        this.commandManager.registerDependency(ActionHandler.class, this.plugin.getActionHandler());
        this.commandManager.registerDependency(Economy.class, this.plugin.getEconomy());
        this.commandManager.registerDependency(Permission.class, this.plugin.getPermissions());
        this.commandManager.registerDependency(CooldownHandler.class, this.plugin.getCooldownHandler());
        this.commandManager.registerDependency(ArenaHandler.class, this.plugin.getArenaHandler());
        this.commandManager.registerDependency(ChallengeHandler.class, this.plugin.getChallengeHandler());
        this.commandManager.registerDependency(DatabaseAdapter.class, this.plugin.getDatabase());
    }

    private static final Guild loadContexts$lambda$2(GuildHandler guildHandler, BukkitCommandExecutionContext bukkitCommandExecutionContext) {
        Guild guild;
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"$guildHandler");
        Guild guild2 = guild = bukkitCommandExecutionContext.hasFlag("other") ? guildHandler.getGuild(bukkitCommandExecutionContext.popFirstArg()) : guildHandler.getGuild((OfflinePlayer)bukkitCommandExecutionContext.getPlayer());
        if (guild == null) {
            throw new InvalidCommandArgument((MessageKeyProvider)Messages.ERROR__NO_GUILD, new String[0]);
        }
        Guild guild3 = guild;
        return guild3;
    }

    private static final Arena loadContexts$lambda$3(ArenaHandler arenaHandler, BukkitCommandExecutionContext bukkitCommandExecutionContext) {
        Intrinsics.checkNotNullParameter((Object)arenaHandler, (String)"$arenaHandler");
        String string = bukkitCommandExecutionContext.popFirstArg();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"c.popFirstArg()");
        return arenaHandler.getArena(string).get();
    }

    private static final void loadConditions$lambda$4(GuildHandler guildHandler, ConditionContext conditionContext, BukkitCommandExecutionContext bukkitCommandExecutionContext, Guild guild) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"$guildHandler");
        if (guild == null) {
            return;
        }
        Player player = bukkitCommandExecutionContext.getPlayer();
        Guild guild2 = guildHandler.getGuild((OfflinePlayer)player);
        if (guild2 == null) {
            throw new ExpectationNotMet(Messages.ERROR__PLAYER_NOT_IN_GUILD);
        }
        Guild guild3 = guild2;
        if (!guild3.memberHasPermission(player, conditionContext.getConfigValue("perm", "SERVER_OWNER"))) {
            throw new InvalidPermissionException();
        }
    }

    private static final void loadConditions$lambda$5(GuildHandler guildHandler, ConditionContext conditionContext, BukkitCommandExecutionContext bukkitCommandExecutionContext, Guild guild) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"$guildHandler");
        if (guild == null) {
            return;
        }
        Player player = bukkitCommandExecutionContext.getPlayer();
        Guild guild2 = guildHandler.getGuild((OfflinePlayer)player);
        if (guild2 == null) {
            throw new ExpectationNotMet(Messages.ERROR__PLAYER_NOT_IN_GUILD);
        }
        Guild guild3 = guild2;
        if (guild3.getAllies().size() >= guild3.getTier().getMaxAllies()) {
            throw new ExpectationNotMet(Messages.ALLY__MAX_ALLIES);
        }
    }

    private static final void loadConditions$lambda$6(GuildHandler guildHandler, ConditionContext conditionContext, BukkitCommandExecutionContext bukkitCommandExecutionContext, Player player) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"$guildHandler");
        if (player == null) {
            return;
        }
        Player player2 = bukkitCommandExecutionContext.getPlayer();
        if (guildHandler.getGuild((OfflinePlayer)player2) != null) {
            throw new ExpectationNotMet(Messages.ERROR__ALREADY_IN_GUILD);
        }
    }

    private static final void loadConditions$lambda$7(GuildHandler guildHandler, ConditionContext conditionContext) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"$guildHandler");
        if (guildHandler.isMigrating()) {
            throw new ExpectationNotMet(Messages.ERROR__MIGRATING);
        }
    }

    private static final Collection loadCompletions$lambda$8(GuildHandler guildHandler, BukkitCommandCompletionContext bukkitCommandCompletionContext) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"$guildHandler");
        return guildHandler.getInvitedGuilds((OfflinePlayer)bukkitCommandCompletionContext.getPlayer());
    }

    private static final Collection loadCompletions$lambda$9(GuildHandler guildHandler, BukkitCommandCompletionContext bukkitCommandCompletionContext) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"$guildHandler");
        return guildHandler.getJoinableGuild(bukkitCommandCompletionContext.getPlayer());
    }

    private static final Collection loadCompletions$lambda$10(GuildHandler guildHandler, BukkitCommandCompletionContext bukkitCommandCompletionContext) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"$guildHandler");
        return guildHandler.getGuildNames();
    }

    private static final Collection loadCompletions$lambda$11(ArenaHandler arenaHandler, BukkitCommandCompletionContext bukkitCommandCompletionContext) {
        Intrinsics.checkNotNullParameter((Object)arenaHandler, (String)"$arenaHandler");
        return arenaHandler.arenaNames();
    }

    private static final Collection loadCompletions$lambda$12() {
        Object[] objectArray = new String[]{"challenger", "defender"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final Collection loadCompletions$lambda$13(ACFHandler aCFHandler, BukkitCommandCompletionContext bukkitCommandCompletionContext) {
        Intrinsics.checkNotNullParameter((Object)aCFHandler, (String)"this$0");
        return CollectionsKt.sorted((Iterable)aCFHandler.languages);
    }

    private static final Collection loadCompletions$lambda$14() {
        Object[] objectArray = new String[]{"JSON", "MYSQL", "SQLITE", "MARIADB"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final Collection loadCompletions$lambda$16(GuildHandler guildHandler, BukkitCommandCompletionContext bukkitCommandCompletionContext) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"$guildHandler");
        Guild guild = guildHandler.getGuild((OfflinePlayer)bukkitCommandCompletionContext.getPlayer());
        if (guild == null) {
            return CollectionsKt.emptyList();
        }
        Guild guild2 = guild;
        List<GuildMember> list2 = guild2.getMembers();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"guild.members");
        Iterable iterable = list2;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Iterable iterable3 = iterable2;
        boolean bl3 = false;
        Iterator iterator = iterable3.iterator();
        while (iterator.hasNext()) {
            Object t;
            Object t2 = t = iterator.next();
            boolean bl4 = false;
            GuildMember guildMember = (GuildMember)t2;
            boolean bl5 = false;
            String string = guildHandler.getLookupCache().get(guildMember.getUuid());
            if (string == null) {
                string = guildMember.getName();
            }
            if (string == null) continue;
            String string2 = string;
            boolean bl6 = false;
            collection.add(string2);
        }
        return (List)collection;
    }

    private static final Collection loadCompletions$lambda$18(GuildHandler guildHandler, BukkitCommandCompletionContext bukkitCommandCompletionContext) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"$guildHandler");
        Guild guild = bukkitCommandCompletionContext.getContextValue(Guild.class, 1);
        if (guild == null) {
            return CollectionsKt.emptyList();
        }
        Guild guild2 = guild;
        List<GuildMember> list2 = guild2.getMembers();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"guild.members");
        Iterable iterable = list2;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Iterable iterable3 = iterable2;
        boolean bl3 = false;
        Iterator iterator = iterable3.iterator();
        while (iterator.hasNext()) {
            Object t;
            Object t2 = t = iterator.next();
            boolean bl4 = false;
            GuildMember guildMember = (GuildMember)t2;
            boolean bl5 = false;
            String string = guildHandler.getLookupCache().get(guildMember.getUuid());
            if (string == null) {
                string = guildMember.getName();
            }
            if (string == null) continue;
            String string2 = string;
            boolean bl6 = false;
            collection.add(string2);
        }
        return (List)collection;
    }

    private static final Collection loadCompletions$lambda$20(GuildHandler guildHandler, BukkitCommandCompletionContext bukkitCommandCompletionContext) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"$guildHandler");
        Guild guild = guildHandler.getGuild((OfflinePlayer)bukkitCommandCompletionContext.getPlayer());
        if (guild == null) {
            return null;
        }
        Guild guild2 = guild;
        if (!guild2.hasPendingAllies()) {
            return null;
        }
        List<UUID> list2 = guild2.getPendingAllies();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"guild.pendingAllies");
        Iterable iterable = list2;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Iterable iterable3 = iterable2;
        boolean bl3 = false;
        Iterator iterator = iterable3.iterator();
        while (iterator.hasNext()) {
            String string;
            Object t;
            Object t2 = t = iterator.next();
            boolean bl4 = false;
            UUID uUID = (UUID)t2;
            boolean bl5 = false;
            if (guildHandler.getNameById(uUID) == null) continue;
            boolean bl6 = false;
            collection.add(string);
        }
        return (List)collection;
    }

    private static final Collection loadCompletions$lambda$22(GuildHandler guildHandler, BukkitCommandCompletionContext bukkitCommandCompletionContext) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"$guildHandler");
        Guild guild = guildHandler.getGuild((OfflinePlayer)bukkitCommandCompletionContext.getPlayer());
        if (guild == null) {
            return null;
        }
        Guild guild2 = guild;
        if (!guild2.hasAllies()) {
            return null;
        }
        List<UUID> list2 = guild2.getAllies();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"guild.allies");
        Iterable iterable = list2;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Iterable iterable3 = iterable2;
        boolean bl3 = false;
        Iterator iterator = iterable3.iterator();
        while (iterator.hasNext()) {
            String string;
            Object t;
            Object t2 = t = iterator.next();
            boolean bl4 = false;
            UUID uUID = (UUID)t2;
            boolean bl5 = false;
            if (guildHandler.getNameById(uUID) == null) continue;
            boolean bl6 = false;
            collection.add(string);
        }
        return (List)collection;
    }

    private static final Collection loadCompletions$lambda$24(GuildHandler guildHandler, BukkitCommandCompletionContext bukkitCommandCompletionContext) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"$guildHandler");
        Guild guild = guildHandler.getGuild((OfflinePlayer)bukkitCommandCompletionContext.getPlayer());
        if (guild == null) {
            return null;
        }
        Guild guild2 = guild;
        if (guild2.getCodes() == null) {
            return null;
        }
        List<GuildCode> list2 = guild2.getCodes();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"guild.codes");
        Iterable iterable = list2;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            GuildCode guildCode = (GuildCode)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(guildCode.getId());
        }
        return (List)collection;
    }

    private static final Collection loadCompletions$lambda$25(GuildHandler guildHandler, BukkitCommandCompletionContext bukkitCommandCompletionContext) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"$guildHandler");
        Guild guild = guildHandler.getGuild((OfflinePlayer)bukkitCommandCompletionContext.getPlayer());
        if (guild == null) {
            return null;
        }
        Guild guild2 = guild;
        if (guild2.getVaults() == null) {
            return null;
        }
        List<Inventory> list2 = guildHandler.getVaults().get(guild2);
        if (list2 == null) {
            return null;
        }
        List<Inventory> list3 = list2;
        Iterable iterable = (Iterable)RangesKt.until((int)1, (int)list3.size());
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        Iterator iterator = iterable2.iterator();
        while (iterator.hasNext()) {
            Object t;
            Object t2 = t = iterator.next();
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(t2.toString());
        }
        return (List)collection;
    }
}

