/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.commands.war;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.api.events.challenges.GuildWarAcceptEvent;
import me.glaremasters.guilds.api.events.challenges.GuildWarChallengeEvent;
import me.glaremasters.guilds.api.events.challenges.GuildWarDeclineEvent;
import me.glaremasters.guilds.arena.Arena;
import me.glaremasters.guilds.arena.ArenaHandler;
import me.glaremasters.guilds.challenges.ChallengeHandler;
import me.glaremasters.guilds.configuration.sections.WarSettings;
import me.glaremasters.guilds.exceptions.ExpectationNotMet;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.guild.GuildChallenge;
import me.glaremasters.guilds.guild.GuildHandler;
import me.glaremasters.guilds.libs.commands.BaseCommand;
import me.glaremasters.guilds.libs.commands.PaperCommandManager;
import me.glaremasters.guilds.libs.commands.annotation.CommandAlias;
import me.glaremasters.guilds.libs.commands.annotation.CommandCompletion;
import me.glaremasters.guilds.libs.commands.annotation.CommandPermission;
import me.glaremasters.guilds.libs.commands.annotation.Conditions;
import me.glaremasters.guilds.libs.commands.annotation.Dependency;
import me.glaremasters.guilds.libs.commands.annotation.Description;
import me.glaremasters.guilds.libs.commands.annotation.Flags;
import me.glaremasters.guilds.libs.commands.annotation.Subcommand;
import me.glaremasters.guilds.libs.commands.annotation.Syntax;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.libs.kotlin.Metadata;
import me.glaremasters.guilds.libs.kotlin.jvm.internal.Intrinsics;
import me.glaremasters.guilds.libs.locales.MessageKeyProvider;
import me.glaremasters.guilds.messages.Messages;
import me.glaremasters.guilds.tasks.GuildWarChallengeCheckTask;
import me.glaremasters.guilds.tasks.GuildWarJoinTask;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@CommandAlias(value="%guilds")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\b\u0001\u0010%\u001a\u00020&H\u0007J$\u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u0010(\u001a\u00020&H\u0007J\u001a\u0010)\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\b\u0001\u0010%\u001a\u00020&H\u0007J\u0018\u0010*\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0007R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u00168\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u00020\u001c8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006+"}, d2={"Lme/glaremasters/guilds/commands/war/CommandWar;", "Lme/glaremasters/guilds/libs/commands/BaseCommand;", "()V", "arenaHandler", "Lme/glaremasters/guilds/arena/ArenaHandler;", "getArenaHandler", "()Lme/glaremasters/guilds/arena/ArenaHandler;", "setArenaHandler", "(Lme/glaremasters/guilds/arena/ArenaHandler;)V", "challengeHandler", "Lme/glaremasters/guilds/challenges/ChallengeHandler;", "getChallengeHandler", "()Lme/glaremasters/guilds/challenges/ChallengeHandler;", "setChallengeHandler", "(Lme/glaremasters/guilds/challenges/ChallengeHandler;)V", "guildHandler", "Lme/glaremasters/guilds/guild/GuildHandler;", "getGuildHandler", "()Lme/glaremasters/guilds/guild/GuildHandler;", "setGuildHandler", "(Lme/glaremasters/guilds/guild/GuildHandler;)V", "guilds", "Lme/glaremasters/guilds/Guilds;", "getGuilds", "()Lme/glaremasters/guilds/Guilds;", "setGuilds", "(Lme/glaremasters/guilds/Guilds;)V", "settingsManager", "Lme/glaremasters/guilds/libs/configme/SettingsManager;", "getSettingsManager", "()Lch/jalu/configme/SettingsManager;", "setSettingsManager", "(Lch/jalu/configme/SettingsManager;)V", "accept", "", "player", "Lorg/bukkit/entity/Player;", "guild", "Lme/glaremasters/guilds/guild/Guild;", "challenge", "targetGuild", "deny", "join", "Guilds"})
public final class CommandWar
extends BaseCommand {
    @Dependency
    public GuildHandler guildHandler;
    @Dependency
    public SettingsManager settingsManager;
    @Dependency
    public ChallengeHandler challengeHandler;
    @Dependency
    public ArenaHandler arenaHandler;
    @Dependency
    public Guilds guilds;

    @NotNull
    public final GuildHandler getGuildHandler() {
        GuildHandler guildHandler = this.guildHandler;
        if (guildHandler != null) {
            return guildHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guildHandler");
        return null;
    }

    public final void setGuildHandler(@NotNull GuildHandler guildHandler) {
        Intrinsics.checkNotNullParameter((Object)guildHandler, (String)"<set-?>");
        this.guildHandler = guildHandler;
    }

    @NotNull
    public final SettingsManager getSettingsManager() {
        SettingsManager settingsManager = this.settingsManager;
        if (settingsManager != null) {
            return settingsManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"settingsManager");
        return null;
    }

    public final void setSettingsManager(@NotNull SettingsManager settingsManager) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"<set-?>");
        this.settingsManager = settingsManager;
    }

    @NotNull
    public final ChallengeHandler getChallengeHandler() {
        ChallengeHandler challengeHandler = this.challengeHandler;
        if (challengeHandler != null) {
            return challengeHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"challengeHandler");
        return null;
    }

    public final void setChallengeHandler(@NotNull ChallengeHandler challengeHandler) {
        Intrinsics.checkNotNullParameter((Object)challengeHandler, (String)"<set-?>");
        this.challengeHandler = challengeHandler;
    }

    @NotNull
    public final ArenaHandler getArenaHandler() {
        ArenaHandler arenaHandler = this.arenaHandler;
        if (arenaHandler != null) {
            return arenaHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"arenaHandler");
        return null;
    }

    public final void setArenaHandler(@NotNull ArenaHandler arenaHandler) {
        Intrinsics.checkNotNullParameter((Object)arenaHandler, (String)"<set-?>");
        this.arenaHandler = arenaHandler;
    }

    @NotNull
    public final Guilds getGuilds() {
        Guilds guilds = this.guilds;
        if (guilds != null) {
            return guilds;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"guilds");
        return null;
    }

    public final void setGuilds(@NotNull Guilds guilds) {
        Intrinsics.checkNotNullParameter((Object)((Object)guilds), (String)"<set-?>");
        this.guilds = guilds;
    }

    @Subcommand(value="war accept")
    @Description(value="{@@descriptions.war-accept}")
    @Syntax(value="")
    @CommandPermission(value="guilds.command.war.accept")
    public final void accept(@NotNull Player player, @Conditions(value="perm:perm=INITIATE_WAR") @NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        GuildChallenge guildChallenge = this.getChallengeHandler().getChallenge(guild);
        if (guildChallenge == null) {
            throw new ExpectationNotMet(Messages.WAR__NO_PENDING_CHALLENGE);
        }
        GuildChallenge guildChallenge2 = guildChallenge;
        Guild guild2 = guildChallenge2.getChallenger();
        if (guildChallenge2.isAccepted()) {
            throw new ExpectationNotMet(Messages.WAR__ALREADY_ACCEPTED);
        }
        GuildWarAcceptEvent guildWarAcceptEvent = new GuildWarAcceptEvent(player, guild, guild2);
        Bukkit.getPluginManager().callEvent((Event)guildWarAcceptEvent);
        Integer n = this.getSettingsManager().getProperty(WarSettings.JOIN_TIME);
        Integer n2 = this.getSettingsManager().getProperty(WarSettings.READY_TIME);
        Object object = new String[]{"{guild}", guild.getName(), "{amount}", String.valueOf(n)};
        guild2.sendMessage(this.getCurrentCommandManager(), Messages.WAR__CHALLENGER_WAR_ACCEPTED, (String)object);
        object = new String[]{"{guild}", guild2.getName(), "{amount}", String.valueOf(n)};
        guild.sendMessage(this.getCurrentCommandManager(), Messages.WAR__DEFENDER_WAR_ACCEPTED, (String)object);
        guildChallenge2.setAccepted(true);
        guildChallenge2.setJoinble(true);
        object = Stream.concat(guild.getOnlineAsUUIDs().stream(), guild2.getOnlineAsUUIDs().stream()).collect(Collectors.toList());
        String string = this.getCurrentCommandManager().getLocales().getMessage(this.getCurrentCommandIssuer(), Messages.WAR__ACTION_BAR_JOIN.getMessageKey());
        String string2 = this.getCurrentCommandManager().getLocales().getMessage(this.getCurrentCommandIssuer(), Messages.WAR__ACTION_BAR_READY.getMessageKey());
        Guilds guilds = this.getGuilds();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"joinTime");
        int n3 = n;
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"readyTime");
        new GuildWarJoinTask(guilds, n3, n2, (List<UUID>)object, string, string2, guildChallenge2, this.getChallengeHandler()).runTaskTimer((Plugin)this.getGuilds(), 0L, 20L);
    }

    @Subcommand(value="war challenge")
    @Description(value="{@@descriptions.war-challenge}")
    @Syntax(value="%guild")
    @CommandPermission(value="guilds.command.war.challenge")
    @CommandCompletion(value="@guilds")
    public final void challenge(@NotNull Player player, @Conditions(value="perm:perm=INITIATE_WAR") @NotNull Guild guild, @Flags(value="other") @NotNull Guild guild2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        Intrinsics.checkNotNullParameter((Object)guild2, (String)"targetGuild");
        if (this.getChallengeHandler().getChallenge(guild) != null) {
            throw new ExpectationNotMet(Messages.WAR__ALREADY_CHALLENGING);
        }
        boolean bl = this.getArenaHandler().getAvailableArena().isPresent();
        if (!bl) {
            throw new ExpectationNotMet(Messages.ARENA__ALL_FULL);
        }
        Arena arena = this.getArenaHandler().getAvailableArena().get();
        Intrinsics.checkNotNullExpressionValue((Object)arena, (String)"arenaHandler.getAvailableArena().get()");
        Arena arena2 = arena;
        if (this.getGuildHandler().isSameGuild(guild, guild2)) {
            throw new ExpectationNotMet(Messages.WAR__NO_SELF_CHALLENGE);
        }
        if (!this.getChallengeHandler().notOnCooldown(guild2, this.getSettingsManager())) {
            MessageKeyProvider messageKeyProvider = Messages.WAR__DEFEND_COOLDOWN;
            String[] stringArray = new String[2];
            stringArray[0] = "{guild}";
            Intrinsics.checkNotNullExpressionValue((Object)guild2.getName(), (String)"targetGuild.name");
            throw new ExpectationNotMet(messageKeyProvider, stringArray);
        }
        if (this.getChallengeHandler().getOnlineDefenders(guild2).isEmpty()) {
            throw new ExpectationNotMet(Messages.WAR__NO_DEFENDERS);
        }
        if (arena2.getChallengerLoc() == null) {
            String[] stringArray = new String[]{"{arena}", arena2.getName()};
            throw new ExpectationNotMet((MessageKeyProvider)Messages.ARENA__LOCATION__ISSUE__CHALLENGER, stringArray);
        }
        if (arena2.getDefenderLoc() == null) {
            String[] stringArray = new String[]{"{arena}", arena2.getName()};
            throw new ExpectationNotMet((MessageKeyProvider)Messages.ARENA__LOCATION__ISSUE__DEFENDER, stringArray);
        }
        GuildWarChallengeEvent guildWarChallengeEvent = new GuildWarChallengeEvent(player, guild, guild2);
        Bukkit.getPluginManager().callEvent((Event)guildWarChallengeEvent);
        if (guildWarChallengeEvent.isCancelled()) {
            return;
        }
        Integer n = this.getSettingsManager().getProperty(WarSettings.MIN_PLAYERS);
        Integer n2 = this.getSettingsManager().getProperty(WarSettings.MAX_PLAYERS);
        Integer n3 = this.getSettingsManager().getProperty(WarSettings.ACCEPT_TIME);
        ChallengeHandler challengeHandler = this.getChallengeHandler();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"minPlayers");
        if (!challengeHandler.checkEnoughOnline(guild, guild2, n)) {
            throw new ExpectationNotMet(Messages.WAR__NOT_ENOUGH_ON);
        }
        ChallengeHandler challengeHandler2 = this.getChallengeHandler();
        int n4 = n;
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"maxPlayers");
        GuildChallenge guildChallenge = challengeHandler2.createNewChallenge(guild, guild2, n4, n2, arena2);
        this.getChallengeHandler().addChallenge(guildChallenge);
        arena2.setInUse(true);
        String[] stringArray = new String[]{"{guild}", guild2.getName(), "{amount}", String.valueOf(n3)};
        this.getCurrentCommandIssuer().sendInfo(Messages.WAR__CHALLENGE_SENT, stringArray);
        ChallengeHandler challengeHandler3 = this.getChallengeHandler();
        PaperCommandManager paperCommandManager = this.getGuilds().getCommandManager();
        String string = guild.getName();
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"acceptTime");
        challengeHandler3.pingOnlineDefenders(guild2, paperCommandManager, string, n3);
        new GuildWarChallengeCheckTask(this.getGuilds(), guildChallenge, this.getChallengeHandler()).runTaskLater((Plugin)this.getGuilds(), n3 * 20);
    }

    @Subcommand(value="war deny")
    @Description(value="{@@descriptions.war-deny}")
    @CommandPermission(value="guilds.command.war.deny")
    @Syntax(value="")
    public final void deny(@NotNull Player player, @Conditions(value="perm:perm=INITIATE_WAR") @NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        GuildChallenge guildChallenge = this.getChallengeHandler().getChallenge(guild);
        if (guildChallenge == null) {
            throw new ExpectationNotMet(Messages.WAR__NO_PENDING_CHALLENGE);
        }
        GuildChallenge guildChallenge2 = guildChallenge;
        Guild guild2 = guildChallenge2.getChallenger();
        GuildWarDeclineEvent guildWarDeclineEvent = new GuildWarDeclineEvent(player, guild2, guild);
        Bukkit.getPluginManager().callEvent((Event)guildWarDeclineEvent);
        String[] stringArray = new String[]{"{guild}", guild.getName()};
        guild2.sendMessage(this.getCurrentCommandManager(), Messages.WAR__CHALLENGE_DENIED_CHALLENGER, stringArray);
        stringArray = new String[]{"{guild}", guild2.getName()};
        guild.sendMessage(this.getCurrentCommandManager(), Messages.WAR__CHALLENGE_DENIED_DEFENDER, stringArray);
        guildChallenge2.getArena().setInUse(false);
        this.getChallengeHandler().removeChallenge(guildChallenge2);
    }

    @Subcommand(value="war join")
    @Description(value="{@@descriptions.war-join}")
    @Syntax(value="")
    @CommandPermission(value="guilds.command.war.join")
    public final void join(@NotNull Player player, @NotNull Guild guild) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)guild, (String)"guild");
        GuildChallenge guildChallenge = this.getChallengeHandler().getChallenge(guild);
        if (guildChallenge == null) {
            throw new ExpectationNotMet(Messages.WAR__NO_PENDING_CHALLENGE);
        }
        GuildChallenge guildChallenge2 = guildChallenge;
        if (!guildChallenge2.isJoinble()) {
            throw new ExpectationNotMet(Messages.WAR__NOT_JOINABLE);
        }
        if (Intrinsics.areEqual((Object)guildChallenge2.getDefender(), (Object)guild)) {
            if (guildChallenge2.getDefendPlayers().contains(player.getUniqueId())) {
                throw new ExpectationNotMet(Messages.WAR__ALREADY_JOINED);
            }
            if (guildChallenge2.getDefendPlayers().size() == guildChallenge2.getMaxPlayersPerSide()) {
                throw new ExpectationNotMet(Messages.WAR__ALREADY_AT_MAX);
            }
            List<UUID> list2 = guildChallenge2.getDefendPlayers();
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
            list2.add(uUID);
        } else {
            if (guildChallenge2.getChallengePlayers().contains(player.getUniqueId())) {
                throw new ExpectationNotMet(Messages.WAR__ALREADY_JOINED);
            }
            if (guildChallenge2.getChallengePlayers().size() == guildChallenge2.getMaxPlayersPerSide()) {
                throw new ExpectationNotMet(Messages.WAR__ALREADY_AT_MAX);
            }
            List<UUID> list3 = guildChallenge2.getChallengePlayers();
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uniqueId");
            list3.add(uUID);
        }
        String[] stringArray = new String[]{"{player}", player.getName()};
        guild.sendMessage(this.getCurrentCommandManager(), Messages.WAR__WAR_JOINED, stringArray);
    }
}

