/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.configuration;

import java.io.File;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.configuration.BuffsMigrationService;
import me.glaremasters.guilds.configuration.GuildConfigurationBuilder;
import me.glaremasters.guilds.configuration.GuildsMigrationService;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.libs.configme.SettingsManagerBuilder;
import me.glaremasters.guilds.libs.configme.migration.PlainMigrationService;

public class SettingsHandler {
    private final SettingsManager mainConf;
    private final SettingsManager tierConf;
    private final SettingsManager roleConf;
    private final SettingsManager buffConf;

    public SettingsHandler(Guilds guilds) {
        this.mainConf = SettingsManagerBuilder.withYamlFile(new File(guilds.getDataFolder(), "config.yml")).migrationService(new GuildsMigrationService(guilds.getDataFolder())).configurationData(GuildConfigurationBuilder.buildConfigurationData()).create();
        this.tierConf = SettingsManagerBuilder.withYamlFile(new File(guilds.getDataFolder(), "tiers.yml")).migrationService(new PlainMigrationService()).configurationData(GuildConfigurationBuilder.buildTierData()).create();
        this.roleConf = SettingsManagerBuilder.withYamlFile(new File(guilds.getDataFolder(), "roles.yml")).migrationService(new PlainMigrationService()).configurationData(GuildConfigurationBuilder.buildRoleData()).create();
        this.buffConf = SettingsManagerBuilder.withYamlFile(new File(guilds.getDataFolder(), "buffs.yml")).migrationService(new BuffsMigrationService()).configurationData(GuildConfigurationBuilder.buildBuffData()).create();
    }

    public SettingsManager getMainConf() {
        return this.mainConf;
    }

    public SettingsManager getTierConf() {
        return this.tierConf;
    }

    public SettingsManager getRoleConf() {
        return this.roleConf;
    }

    public SettingsManager getBuffConf() {
        return this.buffConf;
    }
}

