/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.configuration.sections;

import java.util.List;
import me.glaremasters.guilds.libs.configme.Comment;
import me.glaremasters.guilds.libs.configme.SettingsHolder;
import me.glaremasters.guilds.libs.configme.configurationdata.CommentsConfiguration;
import me.glaremasters.guilds.libs.configme.properties.Property;
import me.glaremasters.guilds.libs.configme.properties.PropertyInitializer;

public class GuildSettings
implements SettingsHolder {
    @Comment(value={"With the default RegEx currently set, the minimum length of the prefix is 1 and the maximum is 64.", "To change this, adjust the number and you can refer to the link below on how to modify RegEx.", "RegEx (https://en.wikipedia.org/wiki/Regular_expression) used to only allow certain characters (default only allows alphanumeric characters).", "To turn off the ability to use colors, remove the & from the RegEx.", "Trying to use symbols such as Chinese ones? Try this Regex: [\\u4E00-\\u9FA5_a-zA-Z0-9&_\\\u4e00-\u9fa5]{1,6}"})
    public static final Property<String> NAME_REQUIREMENTS = PropertyInitializer.newProperty("guild.requirements.name", "[a-zA-Z0-9&]{1,64}");
    @Comment(value={"Similar to the name, just refer above."})
    public static final Property<String> PREFIX_REQUIREMENTS = PropertyInitializer.newProperty("guild.requirements.prefix", "[a-zA-Z0-9&]{1,20}");
    @Comment(value={"Would you like to include color codes signs (&b &l, etc) in the length check?"})
    public static final Property<Boolean> INCLUDE_COLOR_CODES = PropertyInitializer.newProperty("guild.requirements.include-color-codes", true);
    @Comment(value={"Would you like to allow players to make a guild without a prefix?"})
    public static final Property<Boolean> DISABLE_PREFIX = PropertyInitializer.newProperty("guild.disable-prefix", false);
    @Comment(value={"Would you like player to respawn at their guild home (if they have one) when they die?"})
    public static final Property<Boolean> RESPAWN_AT_HOME = PropertyInitializer.newProperty("guild.respawn-at-home", false);
    @Comment(value={"Do we want to enable the blacklist?"})
    public static final Property<Boolean> BLACKLIST_TOGGLE = PropertyInitializer.newProperty("guild.blacklist.enabled", true);
    @Comment(value={"Do we want the blacklist to be case sensitive?"})
    public static final Property<Boolean> BLACKLIST_SENSITIVE = PropertyInitializer.newProperty("guild.blacklist.case-sensitive", true);
    @Comment(value={"What words would you like to blacklist from being used?"})
    public static final Property<List<String>> BLACKLIST_WORDS = PropertyInitializer.newListProperty("guild.blacklist.words", "crap", "ass", "stupid");
    @Comment(value={"This is the style used when a message sent in guild chat.", "As of 3.4.7, this now supports {display-name} to show the display name of a player."})
    public static final Property<String> GUILD_CHAT_FORMAT = PropertyInitializer.newProperty("guild.format.chat", "&7&l[Guild Chat]&r &b[{role}&b]&r &b {player}: {message}");
    @Comment(value={"This is the style used when a message is sent to ally chat"})
    public static final Property<String> ALLY_CHAT_FORMAT = PropertyInitializer.newProperty("guild.format.ally-chat", "&7&l[Ally Chat]&r &b[{guild}&b]&r &b {player}: {message}");
    @Comment(value={"Similar to the one above, just for the admins spying."})
    public static final Property<String> SPY_CHAT_FORMAT = PropertyInitializer.newProperty("guild.format.spy", "&7&l[Guild Spy]&r &b[{guild}&b]&r &b[{role}&b]&r &b {player}: {message}");
    @Comment(value={"Would you like to log the guild chat to console?"})
    public static final Property<Boolean> LOG_GUILD_CHAT = PropertyInitializer.newProperty("guild.format.log-guild-chat", false);
    @Comment(value={"Would you like to log the ally chat to console?"})
    public static final Property<Boolean> LOG_ALLY_CHAT = PropertyInitializer.newProperty("guild.format.log-ally-chat", false);
    @Comment(value={"The left bracket in the placeholder"})
    public static final Property<String> FORMAT_BRACKET_LEFT = PropertyInitializer.newProperty("guild.format.placeholder-design.left-bracket", "[");
    @Comment(value={"The content of the placeholder. Either will be {name} or {prefix}"})
    public static final Property<String> FORMAT_CONTENT = PropertyInitializer.newProperty("guild.format.placeholder-design.content", "{name}");
    @Comment(value={"What to show instead of the placeholder if there's no guild"})
    public static final Property<String> FORMAT_NO_GUILD = PropertyInitializer.newProperty("guild.format.placeholder-design.no-guild", "");
    @Comment(value={"The right bracket in the placeholder"})
    public static final Property<String> FORMAT_BRACKET_RIGHT = PropertyInitializer.newProperty("guild.format.placeholder-design.right-bracket", "]");
    @Comment(value={"Do we want people in the same guild to be able to damage each other?"})
    public static final Property<Boolean> GUILD_DAMAGE = PropertyInitializer.newProperty("guild.damage.guild", false);
    @Comment(value={"Do we want allies to be able to damage each other?"})
    public static final Property<Boolean> ALLY_DAMAGE = PropertyInitializer.newProperty("guild.damage.ally", false);
    @Comment(value={"Would you like to send players their guild's motd on login?"})
    public static final Property<Boolean> MOTD_ON_LOGIN = PropertyInitializer.newProperty("guild.motd-on-login", true);

    private GuildSettings() {
    }

    @Override
    public void registerComments(CommentsConfiguration commentsConfiguration) {
        String[] stringArray = new String[]{"Used for {GUILD_FORMATTED} and %guilds_formatted%"};
        commentsConfiguration.setComment("guild.format.placeholder-design", stringArray);
    }
}

