/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.cooldowns;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.cooldowns.Cooldown;
import me.glaremasters.guilds.guild.Guild;
import me.glaremasters.guilds.libs.commands.lib.expiringmap.ExpirationPolicy;
import me.glaremasters.guilds.libs.commands.lib.expiringmap.ExpiringMap;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class CooldownHandler {
    private final ExpiringMap<UUID, Cooldown> cooldowns = ExpiringMap.builder().variableExpiration().expirationListener((object, object2) -> {}).build();
    private final Guilds guilds;

    public CooldownHandler(Guilds guilds) {
        this.guilds = guilds;
    }

    public void loadCooldowns() {
        try {
            List<Cooldown> list2 = this.guilds.getDatabase().getCooldownAdapter().getAllCooldowns();
            for (Cooldown cooldown : list2) {
                if (cooldown.getCooldownExpiry() < System.currentTimeMillis()) {
                    this.guilds.getDatabase().getCooldownAdapter().deleteCooldown(cooldown);
                    continue;
                }
                this.addCooldown(cooldown);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void saveCooldowns() {
        this.guilds.getDatabase().getCooldownAdapter().saveCooldowns(this.cooldowns.values());
    }

    public Cooldown getCooldown(@NotNull Cooldown.Type type, @NotNull UUID uUID) {
        return this.cooldowns.values().stream().filter(cooldown -> cooldown.getCooldownType() == type && cooldown.getCooldownOwner().equals(uUID)).findFirst().orElse(null);
    }

    public boolean hasCooldown(@NotNull String string, @NotNull UUID uUID) {
        return this.hasCooldown(Cooldown.Type.getByTypeName(string), uUID);
    }

    public boolean hasCooldown(@NotNull Cooldown.Type type, @NotNull UUID uUID) {
        Cooldown cooldown = this.getCooldown(type, uUID);
        return cooldown != null && cooldown.getCooldownExpiry() > System.currentTimeMillis();
    }

    public int getRemaining(@NotNull String string, @NotNull UUID uUID) {
        return this.getRemaining(Cooldown.Type.getByTypeName(string), uUID);
    }

    public int getRemaining(@NotNull Cooldown.Type type, @NotNull UUID uUID) {
        int n = Integer.parseInt(String.format("%d", TimeUnit.MILLISECONDS.toSeconds(this.getCooldown(type, uUID).getCooldownExpiry())));
        int n2 = Integer.parseInt(String.format("%d", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())));
        return n - n2;
    }

    public void addCooldown(@NotNull OfflinePlayer offlinePlayer, @NotNull String string, int n, @NotNull TimeUnit timeUnit) {
        this.addCooldown(Cooldown.Type.getByTypeName(string), offlinePlayer.getUniqueId(), n, timeUnit);
    }

    public void addCooldown(@NotNull Guild guild, @NotNull String string, int n, @NotNull TimeUnit timeUnit) {
        this.addCooldown(Cooldown.Type.getByTypeName(string), guild.getId(), n, timeUnit);
    }

    public void addCooldown(@NotNull Cooldown.Type type, @NotNull UUID uUID, int n, @NotNull TimeUnit timeUnit) {
        Cooldown cooldown = new Cooldown(UUID.randomUUID(), type, uUID, System.currentTimeMillis() + timeUnit.toMillis(n));
        this.cooldowns.put(cooldown.getCooldownId(), cooldown, ExpirationPolicy.CREATED, n, timeUnit);
    }

    private void addCooldown(@NotNull Cooldown cooldown) {
        long l = cooldown.getCooldownExpiry() - System.currentTimeMillis();
        if (l < 0L) {
            return;
        }
        this.cooldowns.put(cooldown.getCooldownId(), cooldown, ExpirationPolicy.CREATED, TimeUnit.MILLISECONDS.toSeconds(l), TimeUnit.SECONDS);
    }

    public ExpiringMap<UUID, Cooldown> getCooldowns() {
        return this.cooldowns;
    }
}

