/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.database;

import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.configuration.sections.StorageSettings;
import me.glaremasters.guilds.database.DatabaseBackend;
import me.glaremasters.guilds.database.DatabaseManager;
import me.glaremasters.guilds.database.arenas.ArenaAdapter;
import me.glaremasters.guilds.database.challenges.ChallengeAdapter;
import me.glaremasters.guilds.database.cooldowns.CooldownAdapter;
import me.glaremasters.guilds.database.guild.GuildAdapter;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.utils.LoggingUtils;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public final class DatabaseAdapter
implements AutoCloseable {
    private final Guilds guilds;
    private final SettingsManager settings;
    private DatabaseBackend backend;
    private GuildAdapter guildAdapter;
    private ChallengeAdapter challengeAdapter;
    private ArenaAdapter arenaAdapter;
    private CooldownAdapter cooldownAdapter;
    private DatabaseManager databaseManager;
    private String sqlTablePrefix;

    public DatabaseAdapter(Guilds guilds, SettingsManager settingsManager) {
        this(guilds, settingsManager, true);
    }

    public DatabaseAdapter(Guilds guilds, SettingsManager settingsManager, boolean bl) {
        String string = settingsManager.getProperty(StorageSettings.STORAGE_TYPE).toLowerCase();
        DatabaseBackend databaseBackend = DatabaseBackend.getByBackendName(string);
        if (databaseBackend == null) {
            databaseBackend = DatabaseBackend.JSON;
        }
        this.guilds = guilds;
        this.settings = settingsManager;
        if (bl) {
            this.setUpBackend(databaseBackend);
        }
    }

    public boolean isConnected() {
        return this.getBackend() == DatabaseBackend.JSON || this.databaseManager != null && this.databaseManager.isConnected();
    }

    public void open() {
        String string = this.settings.getProperty(StorageSettings.STORAGE_TYPE).toLowerCase();
        DatabaseBackend databaseBackend = DatabaseBackend.getByBackendName(string);
        if (this.databaseManager != null && !this.databaseManager.isConnected()) {
            this.databaseManager = new DatabaseManager(this.settings, databaseBackend);
        }
    }

    @Override
    public void close() {
        if (this.databaseManager != null && this.databaseManager.isConnected()) {
            this.databaseManager.getHikari().close();
        }
    }

    public DatabaseBackend getBackend() {
        return this.backend;
    }

    public GuildAdapter getGuildAdapter() {
        return this.guildAdapter;
    }

    public ChallengeAdapter getChallengeAdapter() {
        return this.challengeAdapter;
    }

    public ArenaAdapter getArenaAdapter() {
        return this.arenaAdapter;
    }

    public CooldownAdapter getCooldownAdapter() {
        return this.cooldownAdapter;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public String getSqlTablePrefix() {
        return this.sqlTablePrefix;
    }

    public DatabaseAdapter cloneWith(DatabaseBackend databaseBackend) {
        if (this.backend.equals((Object)databaseBackend)) {
            throw new IllegalArgumentException("Given backend matches current backend. Use this backend.");
        }
        DatabaseAdapter databaseAdapter = new DatabaseAdapter(this.guilds, this.settings, false);
        databaseAdapter.setUpBackend(databaseBackend);
        return databaseAdapter;
    }

    private void setUpBackend(DatabaseBackend databaseBackend) {
        if (this.isConnected()) {
            return;
        }
        if (databaseBackend != DatabaseBackend.JSON) {
            this.databaseManager = new DatabaseManager(this.settings, databaseBackend);
            this.sqlTablePrefix = this.settings.getProperty(StorageSettings.SQL_TABLE_PREFIX).toLowerCase();
        }
        this.backend = databaseBackend;
        try {
            this.guildAdapter = new GuildAdapter(this.guilds, this);
            this.guildAdapter.createContainer();
            this.challengeAdapter = new ChallengeAdapter(this.guilds, this);
            this.challengeAdapter.createContainer();
            this.arenaAdapter = new ArenaAdapter(this.guilds, this);
            this.arenaAdapter.createContainer();
            this.cooldownAdapter = new CooldownAdapter(this.guilds, this);
            this.cooldownAdapter.createContainer();
        }
        catch (Exception exception) {
            LoggingUtils.severe("There was an issue setting up the backend database. Shutting down to prevent further issues. If you are using MySQL, make sure your database server is on the latest version!");
            exception.printStackTrace();
            Bukkit.getServer().getPluginManager().disablePlugin((Plugin)this.guilds);
        }
    }
}

