/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.database;

import me.glaremasters.guilds.configuration.sections.StorageSettings;
import me.glaremasters.guilds.database.DatabaseBackend;
import me.glaremasters.guilds.libs.configme.SettingsManager;
import me.glaremasters.guilds.libs.hikari.HikariConfig;
import me.glaremasters.guilds.libs.hikari.HikariDataSource;
import me.glaremasters.guilds.libs.jdbi.v3.core.Jdbi;
import me.glaremasters.guilds.libs.jdbi.v3.sqlobject.SqlObjectPlugin;

public class DatabaseManager {
    private Jdbi jdbi;
    private HikariDataSource hikari;
    private String dataSourceName;

    public DatabaseManager(SettingsManager settingsManager, DatabaseBackend databaseBackend) {
        HikariDataSource hikariDataSource;
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setMaximumPoolSize(settingsManager.getProperty(StorageSettings.SQL_POOL_SIZE));
        hikariConfig.setMinimumIdle(settingsManager.getProperty(StorageSettings.SQL_POOL_IDLE));
        hikariConfig.setMaxLifetime(settingsManager.getProperty(StorageSettings.SQL_POOL_LIFETIME).intValue());
        hikariConfig.setConnectionTimeout(settingsManager.getProperty(StorageSettings.SQL_POOL_TIMEOUT).intValue());
        String string = settingsManager.getProperty(StorageSettings.SQL_DATABASE);
        switch (databaseBackend) {
            case MYSQL: {
                hikariConfig.setPoolName("Guilds MySQL Connection Pool");
                if (this.dataSourceName == null) {
                    this.tryDataSourceName("com.mysql.jdbc.jdbc2.optional.MysqlDataSource");
                }
                if (this.dataSourceName == null) {
                    this.tryDataSourceName("com.mysql.cj.jdbc.MysqlDataSource");
                }
                hikariConfig.setDataSourceClassName(this.dataSourceName);
                hikariConfig.addDataSourceProperty("serverName", settingsManager.getProperty(StorageSettings.SQL_HOST));
                hikariConfig.addDataSourceProperty("port", settingsManager.getProperty(StorageSettings.SQL_PORT));
                hikariConfig.addDataSourceProperty("databaseName", string);
                hikariConfig.addDataSourceProperty("user", settingsManager.getProperty(StorageSettings.SQL_USERNAME));
                hikariConfig.addDataSourceProperty("password", settingsManager.getProperty(StorageSettings.SQL_PASSWORD));
                hikariConfig.addDataSourceProperty("useSSL", settingsManager.getProperty(StorageSettings.SQL_ENABLE_SSL));
                if (!settingsManager.getProperty(StorageSettings.UTF8).booleanValue()) break;
                hikariConfig.addDataSourceProperty("characterEncoding", "utf8");
                break;
            }
            case SQLITE: {
                hikariConfig.setPoolName("Guilds SQLite Connection Pool");
                hikariConfig.setJdbcUrl("jdbc:sqlite:plugins/Guilds/guilds.db");
                break;
            }
            case MARIADB: {
                hikariConfig.setPoolName("Guilds MariaDB Connection Pool");
                hikariConfig.setDataSourceClassName("me.glaremasters.guilds.libs.jdbc.MariaDbDataSource");
                hikariConfig.addDataSourceProperty("serverName", settingsManager.getProperty(StorageSettings.SQL_HOST));
                hikariConfig.addDataSourceProperty("port", settingsManager.getProperty(StorageSettings.SQL_PORT));
                hikariConfig.addDataSourceProperty("databaseName", string);
                hikariConfig.addDataSourceProperty("user", settingsManager.getProperty(StorageSettings.SQL_USERNAME));
                hikariConfig.addDataSourceProperty("password", settingsManager.getProperty(StorageSettings.SQL_PASSWORD));
                if (!settingsManager.getProperty(StorageSettings.UTF8).booleanValue()) break;
                hikariConfig.addDataSourceProperty("characterEncoding", "utf8");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid backend for DatabaseManager setup: " + databaseBackend.getBackendName());
            }
        }
        try {
            hikariDataSource = new HikariDataSource(hikariConfig);
        }
        catch (Exception exception) {
            return;
        }
        this.jdbi = Jdbi.create(hikariDataSource);
        this.jdbi.installPlugin(new SqlObjectPlugin());
        this.hikari = hikariDataSource;
    }

    public void tryDataSourceName(String string) {
        try {
            this.dataSourceName(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void dataSourceName(String string) {
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        this.dataSourceName = string;
    }

    public final boolean isConnected() {
        return this.hikari != null && this.hikari.isRunning();
    }

    public Jdbi getJdbi() {
        return this.jdbi;
    }

    public HikariDataSource getHikari() {
        return this.hikari;
    }
}

