/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.database.challenges.provider;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.database.challenges.ChallengeProvider;
import me.glaremasters.guilds.guild.GuildChallenge;
import me.glaremasters.guilds.utils.LoggingUtils;
import org.jetbrains.annotations.NotNull;

public class ChallengeJsonProvider
implements ChallengeProvider {
    private final File dataFolder;
    private final Gson gson;

    public ChallengeJsonProvider(File file) {
        this.dataFolder = file;
        this.gson = Guilds.getGson();
    }

    @Override
    public void createContainer(@Nullable String string) {
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdir();
        }
    }

    @Override
    public Set<GuildChallenge> getAllChallenges(@Nullable String string) {
        HashSet<GuildChallenge> hashSet = new HashSet<GuildChallenge>();
        for (File file : Objects.requireNonNull(this.dataFolder.listFiles())) {
            try {
                GuildChallenge guildChallenge = this.gson.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8), GuildChallenge.class);
                guildChallenge.getId();
                hashSet.add(guildChallenge);
            }
            catch (Exception exception) {
                LoggingUtils.severe("There was an error loading a GuildChallenge from the following file: " + file.getAbsolutePath());
                LoggingUtils.severe("To prevent data loss in the plugin, this GuildChallenge has been prevented from loading.");
            }
        }
        return hashSet;
    }

    @Override
    public boolean challengeExists(@Nullable String string, @NotNull String string3) {
        return Arrays.stream(Objects.requireNonNull(this.dataFolder.listFiles())).map(file -> com.google.common.io.Files.getNameWithoutExtension((String)file.getName())).anyMatch(string2 -> string2.equals(string3));
    }

    @Override
    public GuildChallenge getChallenge(@Nullable String string, @NotNull String string2) {
        File file2 = Arrays.stream(Objects.requireNonNull(this.dataFolder.listFiles())).filter(file -> com.google.common.io.Files.getNameWithoutExtension((String)file.getName()).equals(string2)).findFirst().orElse(null);
        if (file2 == null) {
            return null;
        }
        return this.gson.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(file2), StandardCharsets.UTF_8), GuildChallenge.class);
    }

    @Override
    public void createChallenge(@Nullable String string, String string2, String string3) {
        this.writeChallengeFile(new File(this.dataFolder, string2 + ".json"), string3);
    }

    @Override
    public void updateChallenge(@Nullable String string, @NotNull String string2, @NotNull String string3) {
        File file = new File(this.dataFolder, string2 + ".json");
        this.deleteChallenge(file);
        this.writeChallengeFile(file, string3);
    }

    @Override
    public void deleteChallenge(@Nullable String string, @NotNull String string2) {
        this.deleteChallenge(new File(this.dataFolder, string2 + ".json"));
    }

    private void writeChallengeFile(File file, String string) {
        Files.write(Paths.get(file.getPath(), new String[0]), string.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private void deleteChallenge(File file) {
        if (file.exists()) {
            file.delete();
        }
    }
}

