/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.database.guild;

import java.io.File;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import me.glaremasters.guilds.Guilds;
import me.glaremasters.guilds.database.DatabaseAdapter;
import me.glaremasters.guilds.database.DatabaseBackend;
import me.glaremasters.guilds.database.guild.GuildProvider;
import me.glaremasters.guilds.database.guild.provider.GuildJsonProvider;
import me.glaremasters.guilds.guild.Guild;
import org.jetbrains.annotations.NotNull;

public class GuildAdapter {
    private final GuildProvider provider;
    private String sqlTablePrefix;

    public GuildAdapter(Guilds guilds, DatabaseAdapter databaseAdapter) {
        DatabaseBackend databaseBackend = databaseAdapter.getBackend();
        switch (databaseBackend) {
            default: {
                File file = new File(guilds.getDataFolder(), "data");
                this.provider = new GuildJsonProvider(file);
                break;
            }
            case MYSQL: 
            case SQLITE: 
            case MARIADB: {
                this.sqlTablePrefix = databaseAdapter.getSqlTablePrefix();
                this.provider = databaseAdapter.getDatabaseManager().getJdbi().onDemand(databaseBackend.getGuildProvider());
            }
        }
    }

    public void createContainer() {
        this.provider.createContainer(this.sqlTablePrefix);
    }

    public boolean guildExists(@NotNull String string) {
        return this.provider.guildExists(this.sqlTablePrefix, string);
    }

    public List<String> getAllGuildIds() {
        return this.provider.getAllGuildIds(this.sqlTablePrefix);
    }

    public List<Guild> getAllGuilds() {
        return this.provider.getAllGuilds(this.sqlTablePrefix);
    }

    public Guild getGuild(@NotNull String string) {
        return this.provider.getGuild(this.sqlTablePrefix, string);
    }

    public void saveGuilds(@NotNull Collection<Guild> collection) {
        for (Guild guild : collection) {
            this.saveGuild(guild);
        }
    }

    public void saveGuild(@NotNull Guild guild) {
        if (!this.guildExists(guild.getId().toString())) {
            this.createGuild(guild);
        } else {
            this.updateGuild(guild);
        }
    }

    public void createGuild(@NotNull Guild guild) {
        this.provider.createGuild(this.sqlTablePrefix, guild.getId().toString(), Guilds.getGson().toJson((Object)guild, (Type)((Object)Guild.class)));
    }

    public void updateGuild(@NotNull Guild guild) {
        this.provider.updateGuild(this.sqlTablePrefix, guild.getId().toString(), Guilds.getGson().toJson((Object)guild, (Type)((Object)Guild.class)));
    }

    public void deleteGuild(@NotNull String string) {
        this.provider.deleteGuild(this.sqlTablePrefix, string);
    }
}

