/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.beanmapper;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.glaremasters.guilds.libs.configme.beanmapper.ConfigMeMapperException;
import me.glaremasters.guilds.libs.configme.beanmapper.Mapper;
import me.glaremasters.guilds.libs.configme.beanmapper.MappingContext;
import me.glaremasters.guilds.libs.configme.beanmapper.MappingContextImpl;
import me.glaremasters.guilds.libs.configme.beanmapper.leafvaluehandler.LeafValueHandler;
import me.glaremasters.guilds.libs.configme.beanmapper.leafvaluehandler.StandardLeafValueHandlers;
import me.glaremasters.guilds.libs.configme.beanmapper.propertydescription.BeanDescriptionFactory;
import me.glaremasters.guilds.libs.configme.beanmapper.propertydescription.BeanDescriptionFactoryImpl;
import me.glaremasters.guilds.libs.configme.beanmapper.propertydescription.BeanPropertyDescription;
import me.glaremasters.guilds.libs.configme.properties.convertresult.ConvertErrorRecorder;
import me.glaremasters.guilds.libs.configme.utils.TypeInformation;

public class MapperImpl
implements Mapper {
    public static final Object RETURN_NULL = new Object();
    private final BeanDescriptionFactory beanDescriptionFactory;
    private final LeafValueHandler leafValueHandler;

    public MapperImpl() {
        this(new BeanDescriptionFactoryImpl(), StandardLeafValueHandlers.getDefaultLeafValueHandler());
    }

    public MapperImpl(BeanDescriptionFactory beanDescriptionFactory, LeafValueHandler leafValueHandler) {
        this.beanDescriptionFactory = beanDescriptionFactory;
        this.leafValueHandler = leafValueHandler;
    }

    protected final BeanDescriptionFactory getBeanDescriptionFactory() {
        return this.beanDescriptionFactory;
    }

    protected final LeafValueHandler getLeafValueHandler() {
        return this.leafValueHandler;
    }

    protected MappingContext createRootMappingContext(TypeInformation typeInformation, ConvertErrorRecorder convertErrorRecorder) {
        return MappingContextImpl.createRoot(typeInformation, convertErrorRecorder);
    }

    @Override
    public Object toExportValue(Object object) {
        Object object2 = this.leafValueHandler.toExportValue(object);
        if (object2 != null || object == null) {
            return MapperImpl.unwrapReturnNull(object2);
        }
        object2 = this.createExportValueForSpecialTypes(object);
        if (object2 != null) {
            return MapperImpl.unwrapReturnNull(object2);
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (BeanPropertyDescription beanPropertyDescription : this.beanDescriptionFactory.getAllProperties(object.getClass())) {
            Object object3 = this.toExportValue(beanPropertyDescription.getValue(object));
            if (object3 == null) continue;
            linkedHashMap.put(beanPropertyDescription.getName(), object3);
        }
        return linkedHashMap;
    }

    @Nullable
    protected Object createExportValueForSpecialTypes(Object object) {
        if (object instanceof Collection) {
            return ((Collection)object).stream().map(this::toExportValue).collect(Collectors.toList());
        }
        if (object instanceof Map) {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                linkedHashMap.put(entry.getKey(), this.toExportValue(entry.getValue()));
            }
            return linkedHashMap;
        }
        if (object instanceof Optional) {
            Optional optional = (Optional)object;
            return optional.map(this::toExportValue).orElse(RETURN_NULL);
        }
        return null;
    }

    protected static Object unwrapReturnNull(Object object) {
        return object == RETURN_NULL ? null : object;
    }

    @Override
    @Nullable
    public Object convertToBean(Object object, TypeInformation typeInformation, ConvertErrorRecorder convertErrorRecorder) {
        if (object == null) {
            return null;
        }
        return this.convertValueForType(this.createRootMappingContext(typeInformation, convertErrorRecorder), object);
    }

    @Nullable
    protected Object convertValueForType(MappingContext mappingContext, Object object) {
        Class<?> clazz = mappingContext.getTypeInformation().getSafeToWriteClass();
        if (clazz == null) {
            throw new ConfigMeMapperException(mappingContext, "Cannot determine required type");
        }
        Object object2 = this.leafValueHandler.convert(mappingContext.getTypeInformation(), object);
        if (object2 != null) {
            return object2;
        }
        object2 = this.handleSpecialTypes(mappingContext, object);
        if (object2 != null) {
            return object2;
        }
        return this.createBean(mappingContext, object);
    }

    @Nullable
    protected Object handleSpecialTypes(MappingContext mappingContext, Object object) {
        Class<?> clazz = mappingContext.getTypeInformation().getSafeToWriteClass();
        if (Collection.class.isAssignableFrom(clazz)) {
            return this.createCollection(mappingContext, object);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return this.createMap(mappingContext, object);
        }
        if (Optional.class.isAssignableFrom(clazz)) {
            return this.createOptional(mappingContext, object);
        }
        return null;
    }

    @Nullable
    protected Collection createCollection(MappingContext mappingContext, Object object) {
        if (object instanceof Iterable) {
            TypeInformation typeInformation = mappingContext.getGenericTypeInfoOrFail(0);
            Collection collection = this.createCollectionMatchingType(mappingContext);
            int n = 0;
            for (Object t : (Iterable)object) {
                Object object2 = this.convertValueForType(mappingContext.createChild("[" + n + "]", typeInformation), t);
                if (object2 == null) {
                    mappingContext.registerError("Cannot convert value at index " + n);
                    continue;
                }
                collection.add(object2);
            }
            return collection;
        }
        return null;
    }

    protected Collection createCollectionMatchingType(MappingContext mappingContext) {
        Class<AbstractCollection> clazz = mappingContext.getTypeInformation().getSafeToWriteClass();
        if (clazz.isAssignableFrom(ArrayList.class)) {
            return new ArrayList();
        }
        if (clazz.isAssignableFrom(LinkedHashSet.class)) {
            return new LinkedHashSet();
        }
        throw new ConfigMeMapperException(mappingContext, "Unsupported collection type '" + clazz + "'");
    }

    @Nullable
    protected Map createMap(MappingContext mappingContext, Object object) {
        if (object instanceof Map) {
            if (mappingContext.getGenericTypeInfoOrFail(0).getSafeToWriteClass() != String.class) {
                throw new ConfigMeMapperException(mappingContext, "The key type of maps may only be of String type");
            }
            TypeInformation typeInformation = mappingContext.getGenericTypeInfoOrFail(1);
            Map map = (Map)object;
            Map map2 = this.createMapMatchingType(mappingContext);
            for (Map.Entry entry : map.entrySet()) {
                Object object2 = this.convertValueForType(mappingContext.createChild("[k=" + (String)entry.getKey() + "]", typeInformation), entry.getValue());
                if (object2 == null) {
                    mappingContext.registerError("Cannot map value for key " + (String)entry.getKey());
                    continue;
                }
                map2.put(entry.getKey(), object2);
            }
            return map2;
        }
        return null;
    }

    protected Map createMapMatchingType(MappingContext mappingContext) {
        Class<AbstractMap> clazz = mappingContext.getTypeInformation().getSafeToWriteClass();
        if (clazz.isAssignableFrom(LinkedHashMap.class)) {
            return new LinkedHashMap();
        }
        if (clazz.isAssignableFrom(TreeMap.class)) {
            return new TreeMap();
        }
        throw new ConfigMeMapperException(mappingContext, "Unsupported map type '" + clazz + "'");
    }

    protected Object createOptional(MappingContext mappingContext, Object object) {
        MappingContext mappingContext2 = mappingContext.createChild("[v]", mappingContext.getGenericTypeInfoOrFail(0));
        Object object2 = this.convertValueForType(mappingContext2, object);
        return Optional.ofNullable(object2);
    }

    @Nullable
    protected Object createBean(MappingContext mappingContext, Object object) {
        if (!(object instanceof Map)) {
            return null;
        }
        Collection<BeanPropertyDescription> collection = this.beanDescriptionFactory.getAllProperties(mappingContext.getTypeInformation().getSafeToWriteClass());
        if (collection.isEmpty()) {
            return null;
        }
        Map map = (Map)object;
        Object object2 = this.createBeanMatchingType(mappingContext);
        for (BeanPropertyDescription beanPropertyDescription : collection) {
            Object object3 = this.convertValueForType(mappingContext.createChild(beanPropertyDescription.getName(), beanPropertyDescription.getTypeInformation()), map.get(beanPropertyDescription.getName()));
            if (object3 == null) {
                if (beanPropertyDescription.getValue(object2) == null) {
                    return null;
                }
                mappingContext.registerError("No value found, fallback to field default value");
                continue;
            }
            beanPropertyDescription.setValue(object2, object3);
        }
        return object2;
    }

    protected Object createBeanMatchingType(MappingContext mappingContext) {
        Class<?> clazz = mappingContext.getTypeInformation().getSafeToWriteClass();
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ConfigMeMapperException(mappingContext, "Could not create object of type '" + clazz.getName() + "'. It is required to have a default constructor", reflectiveOperationException);
        }
    }
}

