/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.beanmapper.propertydescription;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.glaremasters.guilds.libs.configme.beanmapper.ConfigMeMapperException;
import me.glaremasters.guilds.libs.configme.beanmapper.ExportName;
import me.glaremasters.guilds.libs.configme.beanmapper.propertydescription.BeanDescriptionFactory;
import me.glaremasters.guilds.libs.configme.beanmapper.propertydescription.BeanPropertyDescription;
import me.glaremasters.guilds.libs.configme.beanmapper.propertydescription.BeanPropertyDescriptionImpl;
import me.glaremasters.guilds.libs.configme.utils.TypeInformation;

public class BeanDescriptionFactoryImpl
implements BeanDescriptionFactory {
    private final Map<Class<?>, List<BeanPropertyDescription>> classProperties = new HashMap();

    @Override
    public Collection<BeanPropertyDescription> getAllProperties(Class<?> clazz) {
        return this.classProperties.computeIfAbsent(clazz, this::collectAllProperties);
    }

    protected List<BeanPropertyDescription> collectAllProperties(Class<?> clazz) {
        List<PropertyDescriptor> list2 = this.getWritableProperties(clazz);
        List<BeanPropertyDescription> list3 = list2.stream().map(this::convert).filter(Objects::nonNull).collect(Collectors.toList());
        this.validateProperties(clazz, list3);
        return list3;
    }

    @Nullable
    protected BeanPropertyDescription convert(PropertyDescriptor propertyDescriptor) {
        if (Boolean.TRUE.equals(propertyDescriptor.getValue("transient"))) {
            return null;
        }
        return new BeanPropertyDescriptionImpl(this.getPropertyName(propertyDescriptor), this.createTypeInfo(propertyDescriptor), propertyDescriptor.getReadMethod(), propertyDescriptor.getWriteMethod());
    }

    protected void validateProperties(Class<?> clazz, Collection<BeanPropertyDescription> collection) {
        HashSet hashSet = new HashSet(collection.size());
        collection.forEach(beanPropertyDescription -> {
            if (beanPropertyDescription.getName().isEmpty()) {
                throw new ConfigMeMapperException("Custom name of " + beanPropertyDescription + " may not be empty");
            }
            if (!hashSet.add(beanPropertyDescription.getName())) {
                throw new ConfigMeMapperException(clazz + " has multiple properties with name '" + beanPropertyDescription.getName() + "'");
            }
        });
    }

    protected String getPropertyName(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor.getReadMethod().isAnnotationPresent(ExportName.class)) {
            return propertyDescriptor.getReadMethod().getAnnotation(ExportName.class).value();
        }
        if (propertyDescriptor.getWriteMethod().isAnnotationPresent(ExportName.class)) {
            return propertyDescriptor.getWriteMethod().getAnnotation(ExportName.class).value();
        }
        return propertyDescriptor.getName();
    }

    protected TypeInformation createTypeInfo(PropertyDescriptor propertyDescriptor) {
        return new TypeInformation(propertyDescriptor.getWriteMethod().getGenericParameterTypes()[0]);
    }

    protected List<PropertyDescriptor> getWritableProperties(Class<?> clazz) {
        PropertyDescriptor[] propertyDescriptorArray;
        try {
            propertyDescriptorArray = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        }
        catch (IntrospectionException introspectionException) {
            throw new IllegalStateException(introspectionException);
        }
        ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>(propertyDescriptorArray.length);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
            if (propertyDescriptor.getWriteMethod() == null || propertyDescriptor.getReadMethod() == null) continue;
            arrayList.add(propertyDescriptor);
        }
        return this.sortPropertiesList(clazz, arrayList);
    }

    protected List<PropertyDescriptor> sortPropertiesList(Class<?> clazz, List<PropertyDescriptor> list2) {
        Map<String, Integer> map = this.createFieldNameOrderMap(clazz);
        int n = map.size();
        list2.sort(Comparator.comparing(propertyDescriptor -> {
            Integer n2 = (Integer)map.get(propertyDescriptor.getName());
            return n2 == null ? n : n2;
        }));
        return list2;
    }

    protected Map<String, Integer> createFieldNameOrderMap(Class<?> clazz) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = 0;
        for (Class<?> clazz2 : this.collectClassAndAllParents(clazz)) {
            for (Field field : clazz2.getDeclaredFields()) {
                hashMap.put(field.getName(), n);
                ++n;
            }
        }
        return hashMap;
    }

    protected List<Class<?>> collectClassAndAllParents(Class<?> clazz) {
        ArrayList arrayList = new ArrayList();
        for (Class<?> clazz2 = clazz; clazz2 != null && clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            arrayList.add(clazz2);
        }
        Collections.reverse(arrayList);
        return arrayList;
    }
}

