/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.properties;

import java.util.Objects;
import javax.annotation.Nullable;
import me.glaremasters.guilds.libs.configme.properties.Property;
import me.glaremasters.guilds.libs.configme.properties.convertresult.ConvertErrorRecorder;
import me.glaremasters.guilds.libs.configme.properties.convertresult.PropertyValue;
import me.glaremasters.guilds.libs.configme.resource.PropertyReader;

public abstract class BaseProperty<T>
implements Property<T> {
    private final String path;
    private final T defaultValue;

    public BaseProperty(String string, T t) {
        Objects.requireNonNull(string, "path");
        Objects.requireNonNull(t, "defaultValue");
        this.path = string;
        this.defaultValue = t;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public PropertyValue<T> determineValue(PropertyReader propertyReader) {
        ConvertErrorRecorder convertErrorRecorder = new ConvertErrorRecorder();
        T t = this.getFromReader(propertyReader, convertErrorRecorder);
        if (this.isValidValue(t)) {
            return new PropertyValue<T>(t, convertErrorRecorder.isFullyValid());
        }
        return PropertyValue.withValueRequiringRewrite(this.getDefaultValue());
    }

    @Override
    public boolean isValidValue(T t) {
        return t != null;
    }

    @Nullable
    protected abstract T getFromReader(PropertyReader var1, ConvertErrorRecorder var2);

    public String toString() {
        return "Property '" + this.path + "'";
    }
}

