/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.properties;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.glaremasters.guilds.libs.configme.properties.BaseProperty;
import me.glaremasters.guilds.libs.configme.properties.convertresult.ConvertErrorRecorder;
import me.glaremasters.guilds.libs.configme.properties.types.PropertyType;
import me.glaremasters.guilds.libs.configme.resource.PropertyReader;

public class ListProperty<T>
extends BaseProperty<List<T>> {
    private final PropertyType<T> type;

    @SafeVarargs
    public ListProperty(String string, PropertyType<T> propertyType, T ... TArray) {
        this(string, propertyType, Arrays.asList(TArray));
    }

    public ListProperty(String string, PropertyType<T> propertyType, List<T> list2) {
        super(string, Collections.unmodifiableList(list2));
        Objects.requireNonNull(propertyType, "type");
        this.type = propertyType;
    }

    @Override
    @Nullable
    protected List<T> getFromReader(PropertyReader propertyReader, ConvertErrorRecorder convertErrorRecorder) {
        List<?> list2 = propertyReader.getList(this.getPath());
        if (list2 != null) {
            return Collections.unmodifiableList(list2.stream().map(object -> this.type.convert(object, convertErrorRecorder)).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return null;
    }

    @Override
    public Object toExportValue(List<T> list2) {
        return list2.stream().map(this.type::toExportValue).collect(Collectors.toList());
    }
}

