/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.properties;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.glaremasters.guilds.libs.configme.properties.StringSetProperty;

public class LowercaseStringSetProperty
extends StringSetProperty {
    public LowercaseStringSetProperty(String string, String ... stringArray) {
        super(string, LowercaseStringSetProperty.toLowercaseLinkedHashSet(Arrays.stream(stringArray)));
    }

    public LowercaseStringSetProperty(String string, Collection<String> collection) {
        super(string, LowercaseStringSetProperty.toLowercaseLinkedHashSet(collection.stream()));
    }

    @Override
    protected Collector<String, ?, Set<String>> setCollector() {
        Function<String, String> function = string -> String.valueOf(string).toLowerCase();
        return Collectors.mapping(function, super.setCollector());
    }

    protected static Set<String> toLowercaseLinkedHashSet(Stream<String> stream) {
        Set set = stream.map(String::toLowerCase).collect(Collectors.toCollection(LinkedHashSet::new));
        return Collections.unmodifiableSet(set);
    }
}

