/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.properties;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import me.glaremasters.guilds.libs.configme.properties.ArrayProperty;
import me.glaremasters.guilds.libs.configme.properties.InlineArrayProperty;
import me.glaremasters.guilds.libs.configme.properties.ListProperty;
import me.glaremasters.guilds.libs.configme.properties.MapProperty;
import me.glaremasters.guilds.libs.configme.properties.Property;
import me.glaremasters.guilds.libs.configme.properties.SetProperty;
import me.glaremasters.guilds.libs.configme.properties.TypeBasedProperty;
import me.glaremasters.guilds.libs.configme.properties.inlinearray.InlineArrayConverter;
import me.glaremasters.guilds.libs.configme.properties.types.PropertyType;

public abstract class PropertyBuilder<K, T, B extends PropertyBuilder<K, T, B>> {
    private String path;
    private T defaultValue;
    private PropertyType<K> type;

    public PropertyBuilder(PropertyType<K> propertyType) {
        this.type = propertyType;
    }

    public B path(String string) {
        this.path = string;
        return (B)this;
    }

    public B defaultValue(T t) {
        this.defaultValue = t;
        return (B)this;
    }

    public abstract Property<T> build();

    protected final String getPath() {
        return this.path;
    }

    protected final T getDefaultValue() {
        return this.defaultValue;
    }

    protected final PropertyType<K> getType() {
        return this.type;
    }

    @FunctionalInterface
    public static interface CreateFunction<K, T> {
        public Property<T> apply(String var1, T var2, PropertyType<K> var3);
    }

    public static class SetPropertyBuilder<T>
    extends PropertyBuilder<T, Set<T>, SetPropertyBuilder<T>> {
        public SetPropertyBuilder(PropertyType<T> propertyType) {
            super(propertyType);
        }

        @Override
        public SetPropertyBuilder<T> defaultValue(T ... TArray) {
            Set set = Arrays.stream(TArray).collect(Collectors.toCollection(LinkedHashSet::new));
            return (SetPropertyBuilder)super.defaultValue(set);
        }

        @Override
        public Property<Set<T>> build() {
            return new SetProperty(this.getPath(), this.getType(), (Set)this.getDefaultValue());
        }
    }

    public static class ListPropertyBuilder<T>
    extends PropertyBuilder<T, List<T>, ListPropertyBuilder<T>> {
        public ListPropertyBuilder(PropertyType<T> propertyType) {
            super(propertyType);
        }

        @Override
        public ListPropertyBuilder<T> defaultValue(T ... TArray) {
            return (ListPropertyBuilder)super.defaultValue(Arrays.asList(TArray));
        }

        @Override
        public Property<List<T>> build() {
            return new ListProperty(this.getPath(), this.getType(), (List)this.getDefaultValue());
        }
    }

    public static class InlineArrayPropertyBuilder<T>
    extends PropertyBuilder<T, T[], InlineArrayPropertyBuilder<T>> {
        private InlineArrayConverter<T> inlineConverter;

        public InlineArrayPropertyBuilder(InlineArrayConverter<T> inlineArrayConverter) {
            super(null);
            this.inlineConverter = inlineArrayConverter;
        }

        @Override
        public InlineArrayPropertyBuilder<T> defaultValue(T ... TArray) {
            return (InlineArrayPropertyBuilder)super.defaultValue(TArray);
        }

        @Override
        public Property<T[]> build() {
            return new InlineArrayProperty<Object>(this.getPath(), (Object[])this.getDefaultValue(), this.inlineConverter);
        }
    }

    public static class ArrayPropertyBuilder<T>
    extends PropertyBuilder<T, T[], ArrayPropertyBuilder<T>> {
        private final IntFunction<T[]> arrayProducer;

        public ArrayPropertyBuilder(PropertyType<T> propertyType, IntFunction<T[]> intFunction) {
            super(propertyType);
            this.arrayProducer = intFunction;
        }

        @Override
        public ArrayPropertyBuilder<T> defaultValue(T ... TArray) {
            return (ArrayPropertyBuilder)super.defaultValue(TArray);
        }

        @Override
        public Property<T[]> build() {
            return new ArrayProperty<Object>(this.getPath(), (Object[])this.getDefaultValue(), this.getType(), this.arrayProducer);
        }
    }

    public static class TypeBasedPropertyBuilder<T>
    extends PropertyBuilder<T, T, TypeBasedPropertyBuilder<T>> {
        private CreateFunction<T, T> createFunction = TypeBasedProperty::new;

        public TypeBasedPropertyBuilder(PropertyType<T> propertyType) {
            super(propertyType);
        }

        public TypeBasedPropertyBuilder<T> createFunction(CreateFunction<T, T> createFunction) {
            this.createFunction = createFunction;
            return this;
        }

        @Override
        public Property<T> build() {
            return this.createFunction.apply(this.getPath(), this.getDefaultValue(), this.getType());
        }
    }

    public static class MapPropertyBuilder<T>
    extends PropertyBuilder<T, Map<String, T>, MapPropertyBuilder<T>> {
        public MapPropertyBuilder(PropertyType<T> propertyType) {
            super(propertyType);
            this.defaultValue(new LinkedHashMap());
        }

        public MapPropertyBuilder<T> defaultEntry(String string, T t) {
            ((Map)this.getDefaultValue()).put(string, t);
            return this;
        }

        @Override
        public MapProperty<T> build() {
            return new MapProperty(this.getPath(), (Map)this.getDefaultValue(), this.getType());
        }
    }
}

