/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.properties.types;

import java.util.function.Function;
import me.glaremasters.guilds.libs.configme.properties.convertresult.ConvertErrorRecorder;
import me.glaremasters.guilds.libs.configme.properties.types.PropertyType;

public class PrimitivePropertyType<T>
implements PropertyType<T> {
    public static final PropertyType<Long> LONG = PrimitivePropertyType.fromNumber(Number::longValue);
    public static final PropertyType<Integer> INTEGER = PrimitivePropertyType.fromNumber(Number::intValue);
    public static final PropertyType<Double> DOUBLE = PrimitivePropertyType.fromNumber(Number::doubleValue);
    public static final PropertyType<Float> FLOAT = PrimitivePropertyType.fromNumber(Number::floatValue);
    public static final PropertyType<Short> SHORT = PrimitivePropertyType.fromNumber(Number::shortValue);
    public static final PropertyType<Byte> BYTE = PrimitivePropertyType.fromNumber(Number::byteValue);
    public static final PropertyType<Boolean> BOOLEAN = new PrimitivePropertyType<Boolean>(object -> object instanceof Boolean ? (Boolean)object : null);
    public static final PropertyType<String> STRING = new PrimitivePropertyType<String>(object -> object == null ? null : object.toString());
    public static final PropertyType<String> LOWERCASE_STRING = new PrimitivePropertyType<String>(object -> object == null ? null : object.toString().toLowerCase());
    private final Function<Object, T> convertFunction;
    private final Function<T, Object> exportValueFunction;

    public PrimitivePropertyType(Function<Object, T> function) {
        this(function, object -> object);
    }

    public PrimitivePropertyType(Function<Object, T> function, Function<T, Object> function2) {
        this.convertFunction = function;
        this.exportValueFunction = function2;
    }

    @Override
    public T convert(Object object, ConvertErrorRecorder convertErrorRecorder) {
        return this.convertFunction.apply(object);
    }

    @Override
    public Object toExportValue(T t) {
        return this.exportValueFunction.apply(t);
    }

    private static <T> PrimitivePropertyType<T> fromNumber(Function<Number, T> function) {
        return new PrimitivePropertyType<Object>(object -> object instanceof Number ? function.apply((Number)object) : null);
    }
}

