/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.resource;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class MapNormalizer {
    private final boolean splitDotPaths;

    public MapNormalizer(boolean bl) {
        this.splitDotPaths = bl;
    }

    protected final boolean splitDotPaths() {
        return this.splitDotPaths;
    }

    @Nullable
    public Map<String, Object> normalizeMap(@Nullable Map<Object, Object> map) {
        if (map == null) {
            return null;
        }
        return this.createNormalizedMapIfNeeded(map).orElse(map);
    }

    protected Optional<Map<String, Object>> createNormalizedMapIfNeeded(Object object) {
        if (!(object instanceof Map)) {
            return Optional.empty();
        }
        Map map = (Map)object;
        boolean bl = false;
        for (Map.Entry object2 : map.entrySet()) {
            this.createNormalizedMapIfNeeded(object2.getValue()).ifPresent(map2 -> map.put(object2.getKey(), map2));
            if (bl || !this.isKeyInvalid(object2.getKey())) continue;
            bl = true;
        }
        if (bl) {
            LinkedHashMap linkedHashMap = new LinkedHashMap(map.size());
            for (Map.Entry entry : map.entrySet()) {
                this.addValueIntoMap(linkedHashMap, Objects.toString(entry.getKey()), entry.getValue());
            }
            return Optional.of(linkedHashMap);
        }
        return Optional.empty();
    }

    protected boolean isKeyInvalid(Object object) {
        if (object instanceof String) {
            return this.splitDotPaths && ((String)object).contains(".");
        }
        return true;
    }

    protected void addValueIntoMap(Map<String, Object> map, String string, Object object3) {
        int n;
        int n2 = n = this.splitDotPaths ? string.indexOf(".") : -1;
        if (n > -1) {
            String string2 = string.substring(0, n);
            Map<String, Object> map2 = this.getOrInsertMap(map, string2);
            this.addValueIntoMap(map2, string.substring(n + 1), object3);
        } else if (object3 instanceof Map) {
            Map<String, Object> map3 = this.getOrInsertMap(map, string);
            Map map4 = (Map)object3;
            map4.forEach((object, object2) -> this.addValueIntoMap(map3, Objects.toString(object), object2));
        } else {
            map.put(string, object3);
        }
    }

    protected Map<String, Object> getOrInsertMap(Map<String, Object> map, String string) {
        Object object = map.get(string);
        if (object instanceof Map) {
            return (Map)object;
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        map.put(string, linkedHashMap);
        return linkedHashMap;
    }
}

