/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.configme.resource;

import java.util.ArrayList;
import java.util.List;
import me.glaremasters.guilds.libs.configme.configurationdata.ConfigurationData;
import me.glaremasters.guilds.libs.configme.utils.CollectionUtils;

public class PropertyPathTraverser {
    private final ConfigurationData configurationData;
    private List<String> parentPathElements = new ArrayList<String>(0);
    private boolean isFirstProperty = true;

    public PropertyPathTraverser(ConfigurationData configurationData) {
        this.configurationData = configurationData;
    }

    public List<PathElement> getPathElements(List<String> list2) {
        List<String> list3 = CollectionUtils.filterCommonStart(this.parentPathElements, list2.subList(0, list2.size() - 1));
        List<String> list4 = CollectionUtils.getRange(list2, list3.size());
        this.parentPathElements = list2.subList(0, list2.size() - 1);
        int n = list3.size();
        String string = list3.isEmpty() ? "" : String.join((CharSequence)".", list3) + ".";
        return this.convertToPathElements(n, string, list4);
    }

    private List<PathElement> convertToPathElements(int n, String string, List<String> list2) {
        ArrayList<PathElement> arrayList = new ArrayList<PathElement>(list2.size());
        for (String string2 : list2) {
            List<String> list3 = this.isFirstProperty ? this.getCommentsIncludingRoot(string + string2) : this.configurationData.getCommentsForSection(string + string2);
            arrayList.add(new PathElement(n, string2, list3, this.isFirstProperty));
            this.isFirstProperty = false;
            string = string + string2 + ".";
            ++n;
        }
        ((PathElement)arrayList.get(0)).setFirstOfGroup(true);
        return arrayList;
    }

    private List<String> getCommentsIncludingRoot(String string) {
        List<String> list2 = this.configurationData.getCommentsForSection("");
        if ("".equals(string)) {
            return list2;
        }
        List<String> list3 = this.configurationData.getCommentsForSection(string);
        if (list3.isEmpty()) {
            return list2;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list2);
        arrayList.addAll(list3);
        return arrayList;
    }

    public static class PathElement {
        private final int indentationLevel;
        private final String name;
        private final List<String> comments;
        private final boolean isFirstElement;
        private boolean isFirstOfGroup;

        public PathElement(int n, String string, List<String> list2, boolean bl) {
            this.indentationLevel = n;
            this.name = string;
            this.comments = list2;
            this.isFirstElement = bl;
        }

        public int getIndentationLevel() {
            return this.indentationLevel;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getComments() {
            return this.comments;
        }

        public boolean isFirstElement() {
            return this.isFirstElement;
        }

        public boolean isFirstOfGroup() {
            return this.isFirstOfGroup;
        }

        void setFirstOfGroup(boolean bl) {
            this.isFirstOfGroup = bl;
        }
    }
}

