/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.gui.builder.gui;

import java.util.function.Consumer;
import me.glaremasters.guilds.libs.gui.builder.gui.BaseGuiBuilder;
import me.glaremasters.guilds.libs.gui.components.ScrollType;
import me.glaremasters.guilds.libs.gui.components.util.Legacy;
import me.glaremasters.guilds.libs.gui.guis.ScrollingGui;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ScrollingBuilder
extends BaseGuiBuilder<ScrollingGui, ScrollingBuilder> {
    private ScrollType scrollType;
    private int pageSize = 0;

    public ScrollingBuilder(@NotNull ScrollType scrollType) {
        this.scrollType = scrollType;
    }

    @NotNull
    @Contract(value="_ -> this")
    public ScrollingBuilder scrollType(@NotNull ScrollType scrollType) {
        this.scrollType = scrollType;
        return this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public ScrollingBuilder pageSize(int n) {
        this.pageSize = n;
        return this;
    }

    @Override
    @NotNull
    @Contract(value=" -> new")
    public ScrollingGui create() {
        ScrollingGui scrollingGui = new ScrollingGui(this.getRows(), this.pageSize, Legacy.SERIALIZER.serialize(this.getTitle()), this.scrollType, this.getModifiers());
        Consumer consumer = this.getConsumer();
        if (consumer != null) {
            consumer.accept(scrollingGui);
        }
        return scrollingGui;
    }
}

