/*
 * Decompiled with CFR 0.152.
 */
package me.glaremasters.guilds.libs.jdbi.v3.core.argument;

import java.lang.reflect.Type;
import java.util.Optional;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.Argument;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.ArgumentFactory;
import me.glaremasters.guilds.libs.jdbi.v3.core.argument.NullArgument;
import me.glaremasters.guilds.libs.jdbi.v3.core.config.ConfigRegistry;
import me.glaremasters.guilds.libs.jdbi.v3.core.generic.GenericTypes;

public abstract class AbstractArgumentFactory<T>
implements ArgumentFactory {
    private final int sqlType;
    private final ArgumentPredicate isInstance;

    protected AbstractArgumentFactory(int n) {
        this.sqlType = n;
        Type type3 = GenericTypes.findGenericParameter(this.getClass(), AbstractArgumentFactory.class).orElseThrow(() -> new IllegalStateException(this.getClass().getSimpleName() + " must extend AbstractArgumentFactory with a concrete T parameter"));
        if (type3 instanceof Class) {
            Class clazz = (Class)type3;
            this.isInstance = (type, object) -> clazz.isAssignableFrom(GenericTypes.getErasedType(type)) || clazz.isInstance(object);
        } else {
            this.isInstance = (type2, object) -> type3.equals(type2);
        }
    }

    @Override
    public final Optional<Argument> build(Type type, Object object, ConfigRegistry configRegistry) {
        if (!this.isInstance.test(type, object)) {
            return Optional.empty();
        }
        return Optional.of(object == null ? new NullArgument(this.sqlType) : this.build(object, configRegistry));
    }

    protected abstract Argument build(T var1, ConfigRegistry var2);

    private static interface ArgumentPredicate {
        public boolean test(Type var1, Object var2);
    }
}

